/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtilCore;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.ui.CalendarView;
import java.awt.Component;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeZonedTimestampEditorFactory
extends FormatBasedGridCellEditorFactory {
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        GridColumn c2;
        if (grid == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(2);
        }
        return DbImplUtilCore.isZonedTimestampColumn((ColumnDescriptor)(c2 = Objects.requireNonNull((GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2))), DataGridUtil.getDbms(grid)) ? 2 : 0;
    }

    @NotNull
    protected Formatter getFormatInner(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (grid == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(3);
        }
        if (row == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(5);
        }
        GridColumn c2 = Objects.requireNonNull((GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2));
        Formatter formatter = (Formatter)FormatterCreator.get((CoreGrid)grid).create(FormatterCreator.getZonedTimestampKey((GridColumn)c2, null, (FormatsCache)FormatsCache.get((CoreGrid)grid)));
        if (formatter == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(6);
        }
        return formatter;
    }

    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, final @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<GridRow> row, final @NotNull ModelIndex<GridColumn> column2, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (project == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(7);
        }
        if (grid == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(8);
        }
        if (format == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(9);
        }
        if (row == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(10);
        }
        if (column2 == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(11);
        }
        if (valueParser == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(12);
        }
        if (valueFormatter == null) {
            TimeZonedTimestampEditorFactory.$$$reportNull$$$0(13);
        }
        return new FormatBasedGridCellEditor.WithBrowseButton<CalendarView, TimeZonedTimestamp>(project, grid, format, nullValue, initiator, row, column2, TimeZonedTimestamp.class, provider, valueParser, valueFormatter, (GridCellEditorFactory)this){

            protected void configurePopup(@NotNull JBPopup popup2, @NotNull CalendarView component) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (component == null) {
                    1.$$$reportNull$$$0(1);
                }
                component.registerEnterHandler(() -> this.processDate((JComponent)component, this.onAccept(popup2), () -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)component.getDaysCombo(), true))));
            }

            protected TimeZonedTimestamp getValue(CalendarView component) {
                TimeZonedTimestamp timestamp = (TimeZonedTimestamp)this.getInternalValue();
                ZoneOffset offset = timestamp == null ? DataGridFormattersUtilCore.getDefaultOffset() : ((OffsetDateTime)timestamp.getValue()).getOffset();
                int era = timestamp == null ? 1 : DataGridFormattersUtilCore.getEra(timestamp.getValue());
                Timestamp date = new Timestamp(component.getDate().getTime());
                OffsetDateTime dateTime = date.toLocalDateTime().atOffset(offset);
                OffsetDateTime dateTimeWithEra = dateTime.with(ChronoField.ERA, era);
                TimeZonedTimestamp t = new TimeZonedTimestamp(dateTime);
                TimeZonedTimestamp tWithEra = new TimeZonedTimestamp(dateTimeWithEra);
                BoundaryValueResolver resolver = GridCellEditorHelper.get((CoreGrid)grid).getResolver((CoreGrid)grid, column2);
                return timestamp != null && !resolver.isNegativeInfinity((Object)timestamp) || resolver.isNegativeInfinity((Object)tWithEra) ? tWithEra : t;
            }

            @NotNull
            protected CalendarView getPopupComponent() {
                CalendarView calendarView = new CalendarView();
                calendarView.setFocusCycleRoot(true);
                Object value = this.getValue();
                Date initial = value instanceof TimeZonedTimestamp ? DataGridFormattersUtilCore.getBoundedValue((Object)value, (ModelIndex)column2, (CoreGrid)grid) : new Date();
                calendarView.setDate(initial);
                CalendarView calendarView2 = calendarView;
                if (calendarView2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return calendarView2;
            }

            @NotNull
            protected JComponent getPreferredFocusedComponent(@NotNull CalendarView popupComponent) {
                if (popupComponent == null) {
                    1.$$$reportNull$$$0(3);
                }
                JComponent jComponent = popupComponent.getDaysCombo();
                if (jComponent == null) {
                    1.$$$reportNull$$$0(4);
                }
                return jComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "popup";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "popupComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPopupComponent";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPreferredFocusedComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "configurePopup";
                        break;
                    }
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getPreferredFocusedComponent";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 4 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParser";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/TimeZonedTimestampEditorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFormatInner";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

