/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewPanel;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004H\u0086\n\u00a2\u0006\u0002\u0010\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r*\u00020\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\n*\u00020\u0002\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\r*\u00020\u0002\u001a\u0010\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\r*\u00020\u0002\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r*\u00020\u0002\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0012*\u00020\u0002\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u0002\u001a\f\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0002\u001a\u0010\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a*\u00020\u0002\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\r*\u00020\u0002\u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\r*\u00020\u0002\u001a(\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00010\r\"\b\b\u0000\u0010\u0001*\u00020\"*\u00020\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00010$\u001a\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\r2\u0006\u0010'\u001a\u00020\u0002\u001a\u0010\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0\r*\u00020\u0002\u001a\u0010\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0\r*\u00020\u0002\u001a\u0012\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0\u001a*\u00020\u0002H\u0000\u001a\u0012\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0\r*\u00020\u0002H\u0002\u001a\f\u0010,\u001a\u0004\u0018\u00010\"*\u00020\u0002\u001a\f\u0010-\u001a\u0004\u0018\u00010\u0012*\u00020\u0002\u001a$\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\r2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001c0\rH\u0007\u001a\u001b\u00101\u001a\u0004\u0018\u00010/2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u001cH\u0083\b\u001a#\u00103\u001a\b\u0012\u0004\u0012\u0002H40\r\"\u0006\b\u0000\u00104\u0018\u0001*\n\u0012\u0006\b\u0001\u0012\u0002050\rH\u0086\b\u001aE\u00106\u001a\b\u0012\u0004\u0012\u0002H40\r\"\b\b\u0000\u00107*\u000205\"\b\b\u0001\u00104*\u000205*\b\u0012\u0004\u0012\u0002H70\r2\u0016\b\b\u00108\u001a\u0010\u0012\u0004\u0012\u0002H7\u0012\u0006\u0012\u0004\u0018\u0001H409H\u0082\b\"\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006:"}, d2={"get", "T", "Lcom/intellij/openapi/actionSystem/DataContext;", "key", "Lcom/intellij/openapi/actionSystem/DataKey;", "(Lcom/intellij/openapi/actionSystem/DataContext;Lcom/intellij/openapi/actionSystem/DataKey;)Ljava/lang/Object;", "fromDatabaseTree", "", "getSelectedNodesArray", "", "Lcom/intellij/database/model/basic/BasicNode;", "(Lcom/intellij/openapi/actionSystem/DataContext;)[Lcom/intellij/database/model/basic/BasicNode;", "getSelectedNodes", "Lcom/intellij/util/containers/JBIterable;", "getSelectedSingleNode", "getSelectedNodesExpandingGroups", "getSelectedNodesWithParentsForGroups", "getSelectedElements", "Lcom/intellij/database/model/basic/BasicElement;", "getSelectedSingleElement", "getSelectedTreeNodeRanks", "", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getSelectionRelatedSingleDataSource", "Lcom/intellij/database/view/DataSourceNode;", "getSelectionRelatedDataSources", "", "getSelectedDataSources", "Lcom/intellij/database/model/RawDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/openapi/project/Project;", "getSelectedDbElements", "Lcom/intellij/database/psi/DbElement;", "clazz", "Ljava/lang/Class;", "getSelectedPsiElements", "Lcom/intellij/psi/PsiElement;", "dataContext", "getSelectedDbElementsExpandingGroups", "getSelectedDbElementsWithParentsForGroups", "getSelectedDbElementsIfNoSelectionInTheTreeAsList", "getSelectedDbElementsIfNoSelectionInTheTree", "getSelectedDbElementFromEditor", "getEditorObject", "findDbDataSources", "Lcom/intellij/database/psi/DbDataSource;", "dataSources", "findDbDataSource", "dataSource", "filterBy", "Y", "", "filterMap2", "X", "f", "Lkotlin/Function1;", "intellij.database.impl"})
@JvmName(name="DatabaseContextFun")
@SourceDebugExtension(value={"SMAP\nDatabaseContextFun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseContextFun.kt\ncom/intellij/database/view/DatabaseContextFun\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,316:1\n39#1:317\n39#1:318\n39#1:319\n39#1:320\n39#1:323\n309#1:324\n315#1:325\n315#1:326\n39#1:327\n39#1:328\n39#1:329\n39#1:330\n309#1:331\n309#1:332\n39#1:333\n39#1:336\n309#1:337\n309#1:338\n39#1:339\n309#1:340\n39#1:341\n39#1:344\n39#1:347\n39#1:348\n39#1:360\n39#1:361\n39#1:362\n39#1:363\n306#1:364\n31#2,2:321\n31#2,2:334\n31#2,2:342\n31#2,2:345\n4135#3,11:349\n*S KotlinDebug\n*F\n+ 1 DatabaseContextFun.kt\ncom/intellij/database/view/DatabaseContextFun\n*L\n45#1:317\n52#1:318\n60#1:319\n68#1:320\n82#1:323\n88#1:324\n96#1:325\n97#1:326\n108#1:327\n125#1:328\n133#1:329\n140#1:330\n149#1:331\n154#1:332\n165#1:333\n187#1:336\n190#1:337\n191#1:338\n215#1:339\n219#1:340\n232#1:341\n251#1:344\n261#1:347\n264#1:348\n270#1:360\n271#1:361\n291#1:362\n293#1:363\n302#1:364\n74#1:321,2\n182#1:334,2\n233#1:342,2\n252#1:345,2\n266#1:349,11\n*E\n"})
public final class DatabaseContextFun {
    @Nullable
    public static final <T> T get(@NotNull DataContext $this$get, @NotNull DataKey<T> key2) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(key2, (String)"key");
        boolean $i$f$get = false;
        return (T)$this$get.getData(key2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean fromDatabaseTree(@NotNull DataContext $this$fromDatabaseTree) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fromDatabaseTree, (String)"<this>");
        DataContext dataContext = $this$fromDatabaseTree;
        DataKey<Boolean> dataKey = DatabaseView.DATABASE_TREE_IS_ORIGIN;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_TREE_IS_ORIGIN");
        DataKey<Boolean> key$iv = dataKey;
        boolean $i$f$get = false;
        return $this$get$iv.getData(key$iv) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BasicNode[] getSelectedNodesArray(@NotNull DataContext $this$getSelectedNodesArray) {
        void $this$get$iv;
        BasicNode[] selectedNodes;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedNodesArray, (String)"<this>");
        DataContext dataContext = $this$getSelectedNodesArray;
        DataKey<BasicNode[]> dataKey = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODES");
        DataKey<BasicNode[]> key$iv = dataKey;
        boolean $i$f$get = false;
        BasicNode[] basicNodeArray = selectedNodes = (BasicNode[])$this$get$iv.getData(key$iv);
        if (selectedNodes == null) {
            basicNodeArray = DatabaseViewPanel.Companion.getEMPTY_NODES_ARRAY();
        }
        return basicNodeArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<BasicNode> getSelectedNodes(@NotNull DataContext $this$getSelectedNodes) {
        JBIterable jBIterable;
        void $this$get$iv;
        BasicNode[] nodes2;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedNodes, (String)"<this>");
        BasicNode[] basicNodeArray = $this$getSelectedNodes;
        DataKey<BasicNode[]> dataKey = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODES");
        DataKey<BasicNode[]> key$iv = dataKey;
        boolean $i$f$get = false;
        basicNodeArray = nodes2 = (BasicNode[])$this$get$iv.getData(key$iv);
        if (!(basicNodeArray == null || basicNodeArray.length == 0)) {
            JBIterable jBIterable2 = JBIterable.of((Object[])Arrays.copyOf(nodes2, nodes2.length));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        } else {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        }
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final BasicNode getSelectedSingleNode(@NotNull DataContext $this$getSelectedSingleNode) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedSingleNode, (String)"<this>");
        DataContext dataContext = $this$getSelectedSingleNode;
        DataKey<BasicNode[]> dataKey = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODES");
        DataKey<BasicNode[]> key$iv = dataKey;
        boolean $i$f$get = false;
        BasicNode[] nodes2 = (BasicNode[])$this$get$iv.getData(key$iv);
        return nodes2 != null && nodes2.length == 1 ? nodes2[0] : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<BasicNode> getSelectedNodesExpandingGroups(@NotNull DataContext $this$getSelectedNodesExpandingGroups) {
        void $this$filterBy$iv;
        BasicNode[] $this$get$iv;
        BasicNode[] nodes2;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedNodesExpandingGroups, (String)"<this>");
        Project project = DatabaseContextFun.getProject($this$getSelectedNodesExpandingGroups);
        if (project == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        Project project2 = project;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service22 = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvTreeStructureService ss = (DvTreeStructureService)object;
        DataContext $i$f$service22 = $this$getSelectedNodesExpandingGroups;
        DataKey<BasicNode[]> dataKey = DatabaseView.DATABASE_NODES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODES");
        DataKey<BasicNode[]> key$iv = dataKey;
        boolean $i$f$get22 = false;
        $this$get$iv = nodes2 = (BasicNode[])$this$get$iv.getData(key$iv);
        if ($this$get$iv == null || $this$get$iv.length == 0) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        JBIterable $i$f$get22 = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DatabaseContextFun.getSelectedNodesExpandingGroups$lambda$1(arg_0 -> DatabaseContextFun.getSelectedNodesExpandingGroups$lambda$0(ss, arg_0), arg_0)).withRoots((Object[])Arrays.copyOf(nodes2, nodes2.length))).traverse(TreeTraversal.LEAVES_DFS);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$get22, (String)"traverse(...)");
        boolean $i$f$filterBy = false;
        JBIterable jBIterable = $this$filterBy$iv.filter(BasicNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable jBIterable2 = jBIterable.filter(arg_0 -> DatabaseContextFun.getSelectedNodesExpandingGroups$lambda$3(DatabaseContextFun::getSelectedNodesExpandingGroups$lambda$2, arg_0)).unique();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"unique(...)");
        JBIterable result2 = jBIterable2;
        return result2;
    }

    @NotNull
    public static final JBIterable<BasicNode> getSelectedNodesWithParentsForGroups(@NotNull DataContext $this$getSelectedNodesWithParentsForGroups) {
        JBIterable $this$filterMap2$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedNodesWithParentsForGroups, (String)"<this>");
        JBIterable<BasicNode> jBIterable = DatabaseContextFun.getSelectedNodes($this$getSelectedNodesWithParentsForGroups);
        Function1 f$iv = DatabaseContextFun::getSelectedNodesWithParentsForGroups$lambda$4;
        boolean $i$f$filterMap2 = false;
        JBIterable jBIterable2 = $this$filterMap2$iv.filterMap(new Function(f$iv){
            final /* synthetic */ Function1<X, Y> $f;
            {
                this.$f = $f;
            }

            public final Y fun(X x) {
                Intrinsics.checkNotNullParameter(x, (String)"x");
                return (Y)this.$f.invoke(x);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filterMap(...)");
        $this$filterMap2$iv = jBIterable2;
        f$iv = DatabaseContextFun::getSelectedNodesWithParentsForGroups$lambda$5;
        $i$f$filterMap2 = false;
        JBIterable jBIterable3 = $this$filterMap2$iv.filterMap(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filterMap(...)");
        JBIterable jBIterable4 = jBIterable3.unique();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"unique(...)");
        return jBIterable4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<BasicElement> getSelectedElements(@NotNull DataContext $this$getSelectedElements) {
        JBIterable jBIterable;
        void $this$get$iv;
        BasicElement[] elements;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedElements, (String)"<this>");
        BasicElement[] basicElementArray = $this$getSelectedElements;
        DataKey<BasicElement[]> dataKey = DatabaseView.DATABASE_ELEMENTS;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_ELEMENTS");
        DataKey<BasicElement[]> key$iv = dataKey;
        boolean $i$f$get = false;
        basicElementArray = elements = (BasicElement[])$this$get$iv.getData(key$iv);
        if (!(basicElementArray == null || basicElementArray.length == 0)) {
            JBIterable jBIterable2 = JBIterable.of((Object[])Arrays.copyOf(elements, elements.length));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        } else {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
        }
        return jBIterable;
    }

    @Nullable
    public static final BasicElement getSelectedSingleElement(@NotNull DataContext $this$getSelectedSingleElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedSingleElement, (String)"<this>");
        BasicNode node = DatabaseContextFun.getSelectedSingleNode($this$getSelectedSingleElement);
        return node instanceof BasicElement ? (BasicElement)node : (node instanceof Family ? (((Family)node).size() == 1 ? ((Family)node).first() : null) : (node instanceof DataSourceNode ? (BasicElement)((DataSourceNode)node).getModelRoot() : null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<DvTreeNodeRank> getSelectedTreeNodeRanks(@NotNull DataContext $this$getSelectedTreeNodeRanks) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedTreeNodeRanks, (String)"<this>");
        DataContext dataContext = $this$getSelectedTreeNodeRanks;
        DataKey<EnumSet<DvTreeNodeRank>> dataKey = DatabaseView.DATABASE_NODE_RANKS;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_NODE_RANKS");
        DataKey<EnumSet<DvTreeNodeRank>> key$iv = dataKey;
        boolean $i$f$get = false;
        EnumSet enumSet = (EnumSet)$this$get$iv.getData(key$iv);
        return enumSet != null ? (Set)enumSet : SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final DataSourceNode getSelectionRelatedSingleDataSource(@NotNull DataContext $this$getSelectionRelatedSingleDataSource) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectionRelatedSingleDataSource, (String)"<this>");
        DataContext dataContext = $this$getSelectionRelatedSingleDataSource;
        DataKey<DataSourceNode> dataKey = DatabaseView.DATABASE_RELATED_SINGLE_DATA_SOURCE;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_RELATED_SINGLE_DATA_SOURCE");
        DataKey<DataSourceNode> key$iv = dataKey;
        boolean $i$f$get = false;
        return (DataSourceNode)$this$get$iv.getData(key$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DataSourceNode> getSelectionRelatedDataSources(@NotNull DataContext $this$getSelectionRelatedDataSources) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectionRelatedDataSources, (String)"<this>");
        DataContext dataContext = $this$getSelectionRelatedDataSources;
        DataKey<DataSourceNode[]> dataKey = DatabaseView.DATABASE_RELATED_DATA_SOURCES;
        Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DATABASE_RELATED_DATA_SOURCES");
        DataKey<DataSourceNode[]> key$iv = dataKey;
        boolean $i$f$get = false;
        DataSourceNode[] arrayOfDSNs = (DataSourceNode[])$this$get$iv.getData(key$iv);
        if (arrayOfDSNs == null) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object[])Arrays.copyOf(arrayOfDSNs, arrayOfDSNs.length));
    }

    @NotNull
    public static final JBIterable<RawDataSource> getSelectedDataSources(@NotNull DataContext $this$getSelectedDataSources) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDataSources, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree($this$getSelectedDataSources)) {
            JBIterable<BasicNode> $this$filterBy$iv = DatabaseContextFun.getSelectedNodes($this$getSelectedDataSources);
            boolean $i$f$filterBy = false;
            JBIterable jBIterable2 = $this$filterBy$iv.filter(DataSourceNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
            JBIterable jBIterable3 = jBIterable2.map(arg_0 -> DatabaseContextFun.getSelectedDataSources$lambda$6((Function1)getSelectedDataSources.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)jBIterable3);
            jBIterable = jBIterable3;
        } else {
            JBIterable<DbElement> $this$filterBy$iv = DatabaseContextFun.getSelectedDbElements($this$getSelectedDataSources);
            boolean $i$f$filterBy = false;
            JBIterable jBIterable4 = $this$filterBy$iv.filter(DbDataSource.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
            JBIterable jBIterable5 = jBIterable4.filterMap(arg_0 -> DatabaseContextFun.getSelectedDataSources$lambda$7(getSelectedDataSources.2.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)jBIterable5);
            jBIterable = jBIterable5;
        }
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Project getProject(@NotNull DataContext $this$project) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$project, (String)"<this>");
        DataContext dataContext = $this$project;
        DataKey dataKey = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
        DataKey key$iv = dataKey;
        boolean $i$f$get = false;
        return (Project)$this$get$iv.getData(key$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<DbElement> getSelectedDbElements(@NotNull DataContext $this$getSelectedDbElements) {
        JBIterable jBIterable;
        void $this$get$iv;
        PsiElement[] psiArray;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElements, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree($this$getSelectedDbElements)) {
            Project project = DatabaseContextFun.getProject($this$getSelectedDbElements);
            if (project == null) {
                JBIterable jBIterable2 = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
                return jBIterable2;
            }
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DbModelRegistry modelRegistry = (DbModelRegistry)object;
            JBIterable<BasicNode> selectedNodes = DatabaseContextFun.getSelectedNodes($this$getSelectedDbElements);
            JBIterable jBIterable3 = selectedNodes.filterMap(arg_0 -> DatabaseContextFun.getSelectedDbElements$lambda$9(arg_0 -> DatabaseContextFun.getSelectedDbElements$lambda$8(modelRegistry, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filterMap(...)");
            return jBIterable3;
        }
        DataContext modelRegistry = $this$getSelectedDbElements;
        Intrinsics.checkNotNullExpressionValue((Object)LangDataKeys.PSI_ELEMENT_ARRAY, (String)"PSI_ELEMENT_ARRAY");
        PsiElement[] key$iv = LangDataKeys.PSI_ELEMENT_ARRAY;
        boolean $i$f$get = false;
        key$iv = psiArray = (PsiElement[])$this$get$iv.getData((DataKey)key$iv);
        if (!(key$iv == null || key$iv.length == 0)) {
            JBIterable jBIterable4 = JBIterable.of((Object[])Arrays.copyOf(psiArray, psiArray.length));
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"of(...)");
        } else {
            JBIterable jBIterable5 = JBIterable.empty();
            jBIterable = jBIterable5;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"empty(...)");
        }
        JBIterable psiElements = jBIterable;
        JBIterable jBIterable6 = psiElements.filterMap(arg_0 -> DatabaseContextFun.getSelectedDbElements$lambda$11(DatabaseContextFun::getSelectedDbElements$lambda$10, arg_0)).flatMap((Function)Functions.id());
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable6, (String)"flatMap(...)");
        JBIterable $this$filterBy$iv = jBIterable6;
        boolean $i$f$filterBy = false;
        JBIterable jBIterable7 = $this$filterBy$iv.filter(PsiElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable7, (String)"filter(...)");
        JBIterable jBIterable8 = psiElements.append((Iterable)jBIterable7);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable8, (String)"append(...)");
        JBIterable $this$filterBy$iv2 = jBIterable8;
        boolean $i$f$filterBy2 = false;
        JBIterable jBIterable9 = $this$filterBy$iv2.filter(DbElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable9, (String)"filter(...)");
        return jBIterable9;
    }

    @NotNull
    public static final <T extends DbElement> JBIterable<T> getSelectedDbElements(@NotNull DataContext $this$getSelectedDbElements, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElements, (String)"<this>");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        JBIterable jBIterable = DatabaseContextFun.getSelectedDbElements($this$getSelectedDbElements).filter(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<PsiElement> getSelectedPsiElements(@NotNull DataContext dataContext) {
        void $this$filterBy$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DataContext dataContext2 = dataContext;
        DataKey dataKey = LangDataKeys.PSI_ELEMENT_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_ELEMENT_ARRAY");
        DataKey key$iv = dataKey;
        boolean $i$f$get = false;
        PsiElement[] psiElementArray = (PsiElement[])$this$get$iv.getData(key$iv);
        if (psiElementArray == null) {
            psiElementArray = new PsiElement[]{};
        }
        PsiElement[] psiElements = psiElementArray;
        JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(psiElements, psiElements.length));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
        JBIterable elements = jBIterable;
        key$iv = elements.filterMap(arg_0 -> DatabaseContextFun.getSelectedPsiElements$lambda$13(DatabaseContextFun::getSelectedPsiElements$lambda$12, arg_0)).flatMap((Function)Functions.id());
        Intrinsics.checkNotNullExpressionValue((Object)key$iv, (String)"flatMap(...)");
        boolean $i$f$filterBy = false;
        JBIterable jBIterable2 = $this$filterBy$iv.filter(PsiElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        JBIterable jBIterable3 = elements.append((Iterable)jBIterable2);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"append(...)");
        return jBIterable3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<DbElement> getSelectedDbElementsExpandingGroups(@NotNull DataContext $this$getSelectedDbElementsExpandingGroups) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElementsExpandingGroups, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree($this$getSelectedDbElementsExpandingGroups)) {
            void $this$get$iv;
            DataContext dataContext = $this$getSelectedDbElementsExpandingGroups;
            DataKey dataKey = CommonDataKeys.PROJECT;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
            DataKey key$iv = dataKey;
            boolean $i$f$get = false;
            Project project = (Project)$this$get$iv.getData(key$iv);
            if (project == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DbModelRegistry modelRegistry = (DbModelRegistry)object;
            JBIterable jBIterable = DatabaseContextFun.getSelectedNodesExpandingGroups($this$getSelectedDbElementsExpandingGroups).filterMap(arg_0 -> DatabaseContextFun.getSelectedDbElementsExpandingGroups$lambda$15(arg_0 -> DatabaseContextFun.getSelectedDbElementsExpandingGroups$lambda$14(modelRegistry, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return jBIterable;
        }
        return DatabaseContextFun.getSelectedDbElementsIfNoSelectionInTheTree($this$getSelectedDbElementsExpandingGroups);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JBIterable<DbElement> getSelectedDbElementsWithParentsForGroups(@NotNull DataContext $this$getSelectedDbElementsWithParentsForGroups) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElementsWithParentsForGroups, (String)"<this>");
        if (DatabaseContextFun.fromDatabaseTree($this$getSelectedDbElementsWithParentsForGroups)) {
            void $this$get$iv;
            DataContext dataContext = $this$getSelectedDbElementsWithParentsForGroups;
            DataKey dataKey = CommonDataKeys.PROJECT;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
            DataKey key$iv = dataKey;
            boolean $i$f$get = false;
            Project project = (Project)$this$get$iv.getData(key$iv);
            if (project == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<DbModelRegistry> serviceClass$iv = DbModelRegistry.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DbModelRegistry modelRegistry = (DbModelRegistry)object;
            JBIterable jBIterable = DatabaseContextFun.getSelectedNodesWithParentsForGroups($this$getSelectedDbElementsWithParentsForGroups).filterMap(arg_0 -> DatabaseContextFun.getSelectedDbElementsWithParentsForGroups$lambda$17(arg_0 -> DatabaseContextFun.getSelectedDbElementsWithParentsForGroups$lambda$16(modelRegistry, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            return jBIterable;
        }
        return DatabaseContextFun.getSelectedDbElementsIfNoSelectionInTheTree($this$getSelectedDbElementsWithParentsForGroups);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DbElement> getSelectedDbElementsIfNoSelectionInTheTreeAsList(@NotNull DataContext $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList) {
        DbElement element;
        void $this$get$iv;
        void $this$get$iv2;
        DataContext $this$filterIsInstance$iv;
        void $this$get$iv3;
        Object[] elements;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElementsIfNoSelectionInTheTreeAsList, (String)"<this>");
        DataContext dataContext = $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList;
        DataContext dataContext2 = DatabaseView.DB_ELEMENTS;
        Intrinsics.checkNotNullExpressionValue(dataContext2, (String)"DB_ELEMENTS");
        DataContext key$iv = dataContext2;
        boolean $i$f$get = false;
        if (elements != null) {
            void $this$get$iv4;
            elements = (DbElement[])$this$get$iv4.getData(key$iv);
            return ArraysKt.asList((Object[])elements);
        }
        key$iv = $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList;
        DataKey dataKey = PlatformCoreDataKeys.PSI_ELEMENT_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PSI_ELEMENT_ARRAY");
        DataKey key$iv2 = dataKey;
        boolean $i$f$get2 = false;
        DataContext psiElements = (DataContext)$this$get$iv3.getData(key$iv2);
        if (psiElements != null) {
            void $this$filterIsInstanceTo$iv$iv;
            $this$filterIsInstance$iv = psiElements;
            boolean $i$f$filterIsInstance = false;
            DataContext dataContext3 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof DbElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List dbElements = (List)destination$iv$iv;
            if (!((Collection)dbElements).isEmpty()) {
                return dbElements;
            }
        }
        $this$filterIsInstance$iv = $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList;
        DataKey dataKey2 = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PROJECT");
        DataKey key$iv3 = dataKey2;
        boolean $i$f$get3 = false;
        Project project = (Project)$this$get$iv2.getData(key$iv3);
        key$iv3 = $this$getSelectedDbElementsIfNoSelectionInTheTreeAsList;
        DataKey dataKey3 = PlatformCoreDataKeys.FILE_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"FILE_EDITOR");
        DataKey key$iv4 = dataKey3;
        boolean $i$f$get4 = false;
        FileEditor fileEditor = (FileEditor)$this$get$iv.getData(key$iv4);
        DbElement dbElement = element = project == null || fileEditor == null ? null : DatabaseContextFun.getSelectedDbElementFromEditor($this$getSelectedDbElementsIfNoSelectionInTheTreeAsList);
        return dbElement != null ? CollectionsKt.listOf((Object)dbElement) : CollectionsKt.emptyList();
    }

    private static final JBIterable<DbElement> getSelectedDbElementsIfNoSelectionInTheTree(DataContext $this$getSelectedDbElementsIfNoSelectionInTheTree) {
        return UtilKt.asJBIterable((Iterable)DatabaseContextFun.getSelectedDbElementsIfNoSelectionInTheTreeAsList($this$getSelectedDbElementsIfNoSelectionInTheTree));
    }

    @Nullable
    public static final DbElement getSelectedDbElementFromEditor(@NotNull DataContext $this$getSelectedDbElementFromEditor) {
        SelectInContext context;
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedDbElementFromEditor, (String)"<this>");
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)$this$getSelectedDbElementFromEditor);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent event = anActionEvent;
        SelectInContext selectInContext = context = SelectInContextImpl.createContext((AnActionEvent)event);
        return selectInContext == null ? null : SelectInDatabaseView.askProviders(selectInContext);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final BasicElement getEditorObject(@NotNull DataContext $this$getEditorObject) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getEditorObject, (String)"<this>");
        DataContext dataContext = $this$getEditorObject;
        DataContext dataContext2 = DatabaseDataKeysCore.DATABASE_EDITOR_OBJECT;
        Intrinsics.checkNotNullExpressionValue(dataContext2, (String)"DATABASE_EDITOR_OBJECT");
        DataContext key$iv = dataContext2;
        boolean $i$f$get = false;
        BasicElement element = (BasicElement)$this$get$iv.getData(key$iv);
        if (element == null) {
            void $this$get$iv2;
            key$iv = $this$getEditorObject;
            DataKey<DbElement> dataKey = DatabaseDataKeysCore.DB_EDITOR_OBJECT;
            Intrinsics.checkNotNullExpressionValue(dataKey, (String)"DB_EDITOR_OBJECT");
            DataKey<DbElement> key$iv2 = dataKey;
            boolean $i$f$get2 = false;
            DbElement o = (DbElement)$this$get$iv2.getData(key$iv2);
            if (o != null) {
                element = DasObjectFun.getBasicElement(o);
            }
        }
        return element;
    }

    @ApiStatus.Internal
    @NotNull
    public static final JBIterable<DbDataSource> findDbDataSources(@NotNull Project project, @NotNull JBIterable<RawDataSource> dataSources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        JBIterable jBIterable = dataSources.filterMap(arg_0 -> DatabaseContextFun.findDbDataSources$lambda$19(arg_0 -> DatabaseContextFun.findDbDataSources$lambda$18(project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return jBIterable;
    }

    @ApiStatus.Internal
    private static final DbDataSource findDbDataSource(Project project, RawDataSource dataSource) {
        boolean $i$f$findDbDataSource = false;
        return DbImplUtil.getDbDataSource(project, dataSource);
    }

    public static final /* synthetic */ <Y> JBIterable<Y> filterBy(JBIterable<? extends Object> $this$filterBy) {
        Intrinsics.checkNotNullParameter($this$filterBy, (String)"<this>");
        boolean $i$f$filterBy = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"Y");
        JBIterable jBIterable = $this$filterBy.filter(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private static final <X, Y> JBIterable<Y> filterMap2(JBIterable<X> $this$filterMap2, Function1<? super X, ? extends Y> f) {
        boolean $i$f$filterMap2 = false;
        JBIterable jBIterable = $this$filterMap2.filterMap(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return jBIterable;
    }

    private static final Iterable<Object> getSelectedNodesExpandingGroups$iterateGroupChildren(DvTreeStructureService ss, Object node) {
        Iterable iterable;
        if (node instanceof FamilyWithId) {
            iterable = (Iterable)ss.childrenOf((BasicNode)node);
        } else {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            iterable = list;
        }
        return iterable;
    }

    private static final Iterable getSelectedNodesExpandingGroups$lambda$0(DvTreeStructureService $ss, Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return DatabaseContextFun.getSelectedNodesExpandingGroups$iterateGroupChildren($ss, node);
    }

    private static final Iterable getSelectedNodesExpandingGroups$lambda$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean getSelectedNodesExpandingGroups$lambda$2(BasicNode x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return x instanceof BasicObjectNode || x instanceof DataSourceNode;
    }

    private static final boolean getSelectedNodesExpandingGroups$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicNode getSelectedNodesWithParentsForGroups$lambda$4(BasicNode node) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof DataSourceNode) {
            BasicRoot basicRoot = ((DataSourceNode)node).getModelRoot();
            basicNode = basicRoot != null ? (BasicNode)basicRoot : node;
        } else {
            basicNode = node;
        }
        return basicNode;
    }

    private static final BasicNode getSelectedNodesWithParentsForGroups$lambda$5(BasicNode node) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof HostFamily) {
            BasicElement basicElement = ((HostFamily)node).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
            basicNode = basicElement;
        } else {
            basicNode = node instanceof DvHostNode ? (BasicNode)((DvHostNode)node).host : node;
        }
        return basicNode;
    }

    private static final RawDataSource getSelectedDataSources$lambda$6(Function1 $tmp0, Object p0) {
        return (RawDataSource)$tmp0.invoke(p0);
    }

    private static final RawDataSource getSelectedDataSources$lambda$7(Function1 $tmp0, Object p0) {
        return (RawDataSource)$tmp0.invoke(p0);
    }

    private static final DbElement getSelectedDbElements$lambda$8(DbModelRegistry $modelRegistry, BasicNode node) {
        Intrinsics.checkNotNull((Object)node);
        return DatabaseViewTreeFun.getDbWrapperFor(node, $modelRegistry);
    }

    private static final DbElement getSelectedDbElements$lambda$9(Function1 $tmp0, Object p0) {
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final JBIterable getSelectedDbElements$lambda$10(PsiElement it) {
        return DbNavigationUtils.unwrapElements(it);
    }

    private static final JBIterable getSelectedDbElements$lambda$11(Function1 $tmp0, Object p0) {
        return (JBIterable)$tmp0.invoke(p0);
    }

    private static final JBIterable getSelectedPsiElements$lambda$12(PsiElement it) {
        return DbNavigationUtils.unwrapElements(it);
    }

    private static final JBIterable getSelectedPsiElements$lambda$13(Function1 $tmp0, Object p0) {
        return (JBIterable)$tmp0.invoke(p0);
    }

    private static final DbElement getSelectedDbElementsExpandingGroups$lambda$14(DbModelRegistry $modelRegistry, BasicNode node) {
        Intrinsics.checkNotNull((Object)node);
        return DatabaseViewTreeFun.getDbWrapperFor(node, $modelRegistry);
    }

    private static final DbElement getSelectedDbElementsExpandingGroups$lambda$15(Function1 $tmp0, Object p0) {
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final DbElement getSelectedDbElementsWithParentsForGroups$lambda$16(DbModelRegistry $modelRegistry, BasicNode node) {
        Intrinsics.checkNotNull((Object)node);
        return DatabaseViewTreeFun.getDbWrapperFor(node, $modelRegistry);
    }

    private static final DbElement getSelectedDbElementsWithParentsForGroups$lambda$17(Function1 $tmp0, Object p0) {
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final DbDataSource findDbDataSources$lambda$18(Project $project, RawDataSource it) {
        Intrinsics.checkNotNull((Object)it);
        RawDataSource dataSource$iv = it;
        boolean $i$f$findDbDataSource = false;
        return DbImplUtil.getDbDataSource($project, dataSource$iv);
    }

    private static final DbDataSource findDbDataSources$lambda$19(Function1 $tmp0, Object p0) {
        return (DbDataSource)$tmp0.invoke(p0);
    }
}

