/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.DynamicBundle;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DataGridEditorUtil;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseForeignKeyRefEditor;
import com.intellij.database.view.editors.DatabaseTableRefEditor;
import com.intellij.database.view.editors.EmbComboBox;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.ForeignKeyEditorModel;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.JBListTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DatabaseForeignKeyEditor
extends DatabaseEditorBaseEx
implements DataGridEditorUtil.EmbeddableEditor {
    private final TableEditorModel myTableModel;
    private EditorTextField myNameField;
    private JPanel myMainPanel;
    private JPanel myTablePanel;
    private final DatabaseTableRefEditor myTargetEditor;
    private EditorTextField myTargetEditorComponent;
    private JComboBox<DasForeignKey.RuleAction> myUpdateRule;
    private JComboBox<DasForeignKey.RuleAction> myDeleteRule;
    private JComboBox<DasForeignKey.Deferrability> myDeferrability;
    private JPanel myUpdateRuleWrapper;
    private JPanel myDeleteRuleWrapper;
    private JPanel myDeferrabilityWrapper;
    private ListTableModel<DatabaseForeignKeyRefEditor> myRefsTableModel;
    private final ForeignKeyEditorModel myForeignKeyModel;
    private final DatabaseEditorCapabilities.ForeignKeyEditorCaps myCaps;
    private final EditorModelBase.Listener myChangeListener;
    private final Map<ColumnEditorModel, Disposable> mySubscribedColumns;
    private JBListTable myTable;
    private boolean myValid;

    public DatabaseForeignKeyEditor(@NotNull DatabaseEditorState state, @NotNull ForeignKeyEditorModel model, @NotNull DatabaseEditorCapabilities.ForeignKeyEditorCaps caps) {
        DasForeignKey.Deferrability[] deferrabilities;
        DasForeignKey.RuleAction[] deleteRules;
        if (state == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(1);
        }
        if (caps == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(2);
        }
        super(state);
        this.myChangeListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseForeignKeyEditor.this.fromModelToUi();
            }
        };
        this.mySubscribedColumns = new HashMap<ColumnEditorModel, Disposable>();
        this.myForeignKeyModel = model;
        this.myCaps = caps;
        this.myTargetEditor = new DatabaseTableRefEditor(model.getModel(), ((DeForeignKey)model.getObject()).table.parent, this.getContext());
        this.myTableModel = this.myForeignKeyModel.modelsCache.get(this.myForeignKeyModel.getTable(), TableEditorModel.class);
        DasForeignKey.RuleAction[] updateRules = this.myCaps.getUpdateRule().values();
        if (updateRules.length != 0 && !ArrayUtil.contains((Object)((Object)((DeForeignKey)model.getObject()).updateRule), (Object[])updateRules)) {
            ((DeForeignKey)model.getObject()).updateRule = updateRules[0];
        }
        if ((deleteRules = this.myCaps.getDeleteRule().values()).length != 0 && !ArrayUtil.contains((Object)((Object)((DeForeignKey)model.getObject()).deleteRule), (Object[])deleteRules)) {
            ((DeForeignKey)model.getObject()).deleteRule = deleteRules[0];
        }
        if ((deferrabilities = this.myCaps.getDeferrability().values()).length != 0 && !ArrayUtil.contains((Object)((Object)((DeForeignKey)model.getObject()).deferrability), (Object[])deferrabilities)) {
            ((DeForeignKey)model.getObject()).deferrability = deferrabilities[0];
        }
        this.$$$setupUI$$$();
        this.applyCaps();
        this.setupControls();
    }

    private void applyCaps() {
        this.myNameField.setEnabled(this.myCaps.getRename().isAvailable());
        this.myUpdateRule.setEnabled(this.myCaps.getUpdateRule().isAvailable());
        this.myDeleteRule.setEnabled(this.myCaps.getDeleteRule().isAvailable());
        this.myDeferrability.setEnabled(this.myCaps.getDeferrability().isAvailable());
        this.myUpdateRuleWrapper.setVisible(this.myCaps.getUpdateRule().isSupported());
        this.myDeleteRuleWrapper.setVisible(this.myCaps.getDeleteRule().isSupported());
        this.myDeferrabilityWrapper.setVisible(this.myCaps.getDeferrability().isSupported());
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.myTableModel.getObject();
        if (deTable == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(3);
        }
        return deTable;
    }

    @Nullable
    public DeTable getTargetTable() {
        return this.myForeignKeyModel.getTargetTable();
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    public boolean canDoAnything() {
        return this.myCaps.canDoAnything();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField2 = this.myNameField;
        if (editorTextField2 == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(5);
        }
        return editorTextField2;
    }

    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = new JComponent[]{this.myNameField, this.myTargetEditorComponent.getFocusTarget(), this.myUpdateRule, this.myDeleteRule, this.myDeferrability, this.myTable.getTable()};
        if (jComponentArray == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(6);
        }
        return jComponentArray;
    }

    @NotNull
    public ForeignKeyEditorModel getForeignKeyModel() {
        ForeignKeyEditorModel foreignKeyEditorModel = this.myForeignKeyModel;
        if (foreignKeyEditorModel == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(7);
        }
        return foreignKeyEditorModel;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeForeignKey> getModel() {
        ForeignKeyEditorModel foreignKeyEditorModel = this.getForeignKeyModel();
        if (foreignKeyEditorModel == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(8);
        }
        return foreignKeyEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        int i2;
        DatabaseForeignKeyEditor.setValue(this.myNameField, this.myForeignKeyModel.getName());
        this.myDeferrability.setSelectedItem((Object)this.myForeignKeyModel.getDeferrability());
        this.myDeleteRule.setSelectedItem((Object)this.myForeignKeyModel.getDeleteRule());
        this.myUpdateRule.setSelectedItem((Object)this.myForeignKeyModel.getUpdateRule());
        this.myTargetEditor.setObject(this.myForeignKeyModel.getTargetTable());
        ArrayList<DatabaseForeignKeyRefEditor> items = new ArrayList<DatabaseForeignKeyRefEditor>(this.myRefsTableModel.getItems());
        int count = this.myForeignKeyModel.getRefsCount();
        if (items.size() > count) {
            items.subList(count, items.size()).clear();
        } else {
            for (i2 = items.size(); i2 < count; ++i2) {
                items.add(new DatabaseForeignKeyRefEditor(this));
            }
        }
        for (i2 = 0; i2 < items.size(); ++i2) {
            ((DatabaseForeignKeyRefEditor)items.get(i2)).updateFromModel(i2);
        }
        if (!items.equals(this.myRefsTableModel.getItems())) {
            this.myRefsTableModel.setItems(items);
        }
        this.myValid = this.myForeignKeyModel.getTargetTable() != null && !EditorModelUtil.isStub(this.myForeignKeyModel.getTargetTable());
        for (DatabaseForeignKeyRefEditor item : items) {
            this.myValid |= item.isObjectValid();
        }
        this.updateColumnSubscriptions();
        this.myTable.getTable().revalidate();
        this.myTable.getTable().repaint();
    }

    @NotNull
    private ColumnEditorModel subscribeColumn(@NotNull DeColumn col) {
        ColumnEditorModel m;
        if (col == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(9);
        }
        if (!this.mySubscribedColumns.containsKey(m = ((ObjectEditorModel)this.getModel()).modelsCache.get(col, ColumnEditorModel.class))) {
            Disposable holder = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)holder);
            m.addListener(this.myChangeListener, holder);
            this.mySubscribedColumns.put(m, holder);
        }
        ColumnEditorModel columnEditorModel = m;
        if (columnEditorModel == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(10);
        }
        return columnEditorModel;
    }

    private void updateColumnSubscriptions() {
        HashSet<ColumnEditorModel> subs = new HashSet<ColumnEditorModel>();
        for (DeForeignKey.Ref ref2 : this.myForeignKeyModel.getRefs()) {
            if (!EditorModelUtil.isStub(ref2.ref)) {
                subs.add(this.subscribeColumn(ref2.ref));
            }
            if (EditorModelUtil.isStub(ref2.target)) continue;
            subs.add(this.subscribeColumn(ref2.target));
        }
        for (Map.Entry entry : new ArrayList<Map.Entry<ColumnEditorModel, Disposable>>(this.mySubscribedColumns.entrySet())) {
            if (subs.contains(entry.getKey())) continue;
            Disposer.dispose((Disposable)((Disposable)entry.getValue()));
            this.mySubscribedColumns.remove(entry.getKey());
        }
    }

    @NotNull
    public List<DeColumn> getTargetTableColumns() {
        List<DeColumn> list = this.getTargetTable() == null ? Collections.emptyList() : this.getTargetTable().columns;
        if (list == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(11);
        }
        return list;
    }

    private void initSubscriptions() {
        this.myForeignKeyModel.addListener(this.myChangeListener, this);
        this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!DatabaseForeignKeyEditor.this.myUpdating) {
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.setName(DatabaseForeignKeyEditor.this.myNameField.getText());
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/editors/DatabaseForeignKeyEditor$2", "documentChanged"));
            }
        });
        this.myTargetEditor.getEditor().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!DatabaseForeignKeyEditor.this.myUpdating) {
                    DeTable target2 = DatabaseForeignKeyEditor.this.myTargetEditor.getObjectOrStub(null);
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.setTargetTable(target2);
                    ArrayList<DeForeignKey.Ref> refs = new ArrayList<DeForeignKey.Ref>(DatabaseForeignKeyEditor.this.myRefsTableModel.getRowCount());
                    for (int i2 = 0; i2 < DatabaseForeignKeyEditor.this.myRefsTableModel.getRowCount(); ++i2) {
                        DatabaseForeignKeyRefEditor item = (DatabaseForeignKeyRefEditor)DatabaseForeignKeyEditor.this.myRefsTableModel.getItem(i2);
                        refs.add(new DeForeignKey.Ref(item.getRef(), item.getTarget()));
                    }
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.setRefs(refs);
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseForeignKeyEditor$3", "documentChanged"));
            }
        });
        this.myDeferrability.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DatabaseForeignKeyEditor.this.myUpdating && e.getStateChange() == 1) {
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.setDeferrability((DasForeignKey.Deferrability)((Object)e.getItem()));
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.commit();
                }
            }
        });
        this.myUpdateRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DatabaseForeignKeyEditor.this.myUpdating && e.getStateChange() == 1) {
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.setUpdateRule((DasForeignKey.RuleAction)((Object)e.getItem()));
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.commit();
                }
            }
        });
        this.myDeleteRule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!DatabaseForeignKeyEditor.this.myUpdating && e.getStateChange() == 1) {
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.setDeleteRule((DasForeignKey.RuleAction)((Object)e.getItem()));
                    DatabaseForeignKeyEditor.this.myForeignKeyModel.commit();
                }
            }
        });
        this.myTableModel.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseForeignKeyEditor.this.fromModelToUi();
            }
        }, this);
    }

    private void createUIComponents() {
        this.myNameField = new EditorTextField(this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        this.myRefsTableModel = DatabaseEditorUtil.createTableModel(this.myForeignKeyModel, new DatabaseEditorUtil.EditorModelHelper<DatabaseForeignKeyRefEditor>(){

            @Override
            public DatabaseForeignKeyRefEditor createRow() {
                ArrayList<DeForeignKey.Ref> refs = new ArrayList<DeForeignKey.Ref>(DatabaseForeignKeyEditor.this.myForeignKeyModel.getRefs());
                List<DeColumn> refColumns = DatabaseForeignKeyEditor.this.getTable().columns;
                List<DeColumn> targetColumns = DatabaseForeignKeyEditor.this.getTargetTableColumns();
                refs.add(new DeForeignKey.Ref(refColumns.isEmpty() ? DatabaseColumnRefEditor.createStub("", DatabaseForeignKeyEditor.this.getTable()) : refColumns.get(0), targetColumns.isEmpty() ? DatabaseColumnRefEditor.createStub("", DatabaseForeignKeyEditor.this.getTable()) : targetColumns.get(0)));
                DatabaseForeignKeyEditor.this.myForeignKeyModel.setRefs(refs);
                return new DatabaseForeignKeyRefEditor(DatabaseForeignKeyEditor.this);
            }

            @Override
            public boolean removeRow(DatabaseForeignKeyRefEditor item, int idx) {
                ArrayList<DeForeignKey.Ref> refs = new ArrayList<DeForeignKey.Ref>(DatabaseForeignKeyEditor.this.myForeignKeyModel.getRefs());
                refs.remove(idx);
                DatabaseForeignKeyEditor.this.myForeignKeyModel.setRefs(refs);
                return true;
            }

            @Override
            public boolean exchangeRows(DatabaseForeignKeyRefEditor item0, int idx0, DatabaseForeignKeyRefEditor item1, int idx1) {
                ArrayList<DeForeignKey.Ref> refs = new ArrayList<DeForeignKey.Ref>(DatabaseForeignKeyEditor.this.myForeignKeyModel.getRefs());
                DeForeignKey.Ref tmp = (DeForeignKey.Ref)refs.get(idx0);
                refs.set(idx0, (DeForeignKey.Ref)refs.get(idx1));
                refs.set(idx1, tmp);
                DatabaseForeignKeyEditor.this.myForeignKeyModel.setRefs(refs);
                return true;
            }
        }, true);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myRefsTableModel, this, null);
        this.myTablePanel = new JPanel(new BorderLayout());
        JPanel toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable.getTable()).setToolbarPosition(ActionToolbarPosition.LEFT).createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(toolbarDecorator, (JTable)this.myTable.getTable());
        this.myTablePanel.add((Component)toolbarDecorator, "Center");
        this.myTargetEditorComponent = this.myTargetEditor.getEditor();
        this.myUpdateRule = new EmbComboBox<DasForeignKey.RuleAction>(new DefaultComboBoxModel<DasForeignKey.RuleAction>(this.myCaps.getUpdateRule().values()));
        this.myUpdateRule.setRenderer(EmbComboBox.ENUM_RENDERER);
        this.myDeleteRule = new EmbComboBox<DasForeignKey.RuleAction>(new DefaultComboBoxModel<DasForeignKey.RuleAction>(this.myCaps.getDeleteRule().values()));
        this.myDeleteRule.setRenderer(EmbComboBox.ENUM_RENDERER);
        this.myDeferrability = new EmbComboBox<DasForeignKey.Deferrability>(new DefaultComboBoxModel<DasForeignKey.Deferrability>(this.myCaps.getDeferrability().values()));
        this.myDeferrability.setRenderer(EmbComboBox.ENUM_RENDERER);
    }

    public int getIndex(@NotNull DatabaseForeignKeyRefEditor editor2) {
        if (editor2 == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(12);
        }
        return this.myRefsTableModel.getItems().indexOf(editor2);
    }

    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        DeForeignKey fk = (DeForeignKey)this.myForeignKeyModel.getObject();
        DatabaseEditorUtil.ColoredFragmentsBuilder res2 = new DatabaseEditorUtil.ColoredFragmentsBuilder();
        res2.append(this.getObjectName(fk)).append(" FOREIGN KEY (");
        boolean first2 = true;
        for (DeForeignKey.Ref ref2 : fk.refs) {
            if (!first2) {
                res2.append(", ");
            }
            first2 = false;
            res2.appendRef(this.getObjectName(ref2.ref), DatabaseForeignKeyEditor.isGood(ref2.ref));
        }
        res2.append(") REFERENCES ").appendRef(this.getObjectName(fk.target), !EditorModelUtil.isStub(fk.target));
        res2.append(" (");
        first2 = true;
        for (DeForeignKey.Ref ref2 : fk.refs) {
            if (!first2) {
                res2.append(", ");
            }
            first2 = false;
            res2.appendRef(this.getObjectName(ref2.target), DatabaseForeignKeyEditor.isGood(ref2.target));
        }
        res2.append(")");
        if (fk.deleteRule == DasForeignKey.RuleAction.CASCADE || fk.deleteRule == DasForeignKey.RuleAction.SET_NULL || fk.deleteRule == DasForeignKey.RuleAction.SET_DEFAULT) {
            res2.append(" ON DELETE ").append(fk.deleteRule.toString().replace('_', ' '));
        }
        if (fk.updateRule == DasForeignKey.RuleAction.CASCADE || fk.updateRule == DasForeignKey.RuleAction.SET_NULL || fk.updateRule == DasForeignKey.RuleAction.SET_DEFAULT) {
            res2.append(" ON UPDATE ").append(fk.updateRule.toString().replace('_', ' '));
        }
        if (fk.deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE) {
            res2.append(" DEFERRABLE");
        }
        if (fk.deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED) {
            res2.append(" INITIALLY DEFERRED");
        }
        Iterable<Pair<String, TextAttributesKey>> iterable = res2.build();
        if (iterable == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(13);
        }
        return iterable;
    }

    public boolean isObjectValid() {
        return this.myValid;
    }

    @NotNull
    public DeForeignKey getForeignKey() {
        DeForeignKey deForeignKey = (DeForeignKey)this.getForeignKeyModel().getObject();
        if (deForeignKey == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(14);
        }
        return deForeignKey;
    }

    @TestOnly
    @NotNull
    public EditorTextField getNameEditor() {
        EditorTextField editorTextField2 = this.myNameField;
        if (editorTextField2 == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(15);
        }
        return editorTextField2;
    }

    @TestOnly
    @NotNull
    public EditorTextField getTargetEditor() {
        EditorTextField editorTextField2 = this.myTargetEditor.getEditor();
        if (editorTextField2 == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(16);
        }
        return editorTextField2;
    }

    @TestOnly
    @NotNull
    public ListTableModel<DatabaseForeignKeyRefEditor> getRefListModel() {
        ListTableModel<DatabaseForeignKeyRefEditor> listTableModel = this.myRefsTableModel;
        if (listTableModel == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(17);
        }
        return listTableModel;
    }

    @TestOnly
    @NotNull
    public JComboBox getUpdateRuleEditor() {
        JComboBox<DasForeignKey.RuleAction> jComboBox = this.myUpdateRule;
        if (jComboBox == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(18);
        }
        return jComboBox;
    }

    @TestOnly
    @NotNull
    public JComboBox getDeleteRuleEditor() {
        JComboBox<DasForeignKey.RuleAction> jComboBox = this.myDeleteRule;
        if (jComboBox == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(19);
        }
        return jComboBox;
    }

    @TestOnly
    @NotNull
    public JComboBox getDeferrabilityEditor() {
        JComboBox<DasForeignKey.Deferrability> jComboBox = this.myDeferrability;
        if (jComboBox == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(20);
        }
        return jComboBox;
    }

    @Override
    @TestOnly
    @NotNull
    public DatabaseEditorCapabilities.ForeignKeyEditorCaps getCaps() {
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = this.myCaps;
        if (foreignKeyEditorCaps == null) {
            DatabaseForeignKeyEditor.$$$reportNull$$$0(21);
        }
        return foreignKeyEditorCaps;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = this.myTablePanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 1, 8, 1, 0, 3, 7, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseForeignKeyEditor.class).getString("DatabaseColumnEditor.label.name"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseForeignKeyEditor.class).getString("DatabaseColumnEditor.label.columns"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 7, 1, 0, 3, 3, 0, null, new Dimension(200, -1), null));
        EditorTextField editorTextField2 = this.myNameField;
        jPanel6.add((Component)editorTextField2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        EditorTextField editorTextField3 = this.myTargetEditorComponent;
        jPanel6.add((Component)editorTextField3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseForeignKeyEditor.class).getString("DatabaseColumnEditor.label.target.table"));
        jPanel6.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myUpdateRuleWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel3, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseForeignKeyEditor.class).getString("DatabaseColumnEditor.label.update.rule"));
        jPanel3.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<DasForeignKey.RuleAction> jComboBox = this.myUpdateRule;
        jPanel3.add(jComboBox, new GridConstraints(1, 0, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDeleteRuleWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(0, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseForeignKeyEditor.class).getString("DatabaseColumnEditor.label.delete.rule"));
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<DasForeignKey.RuleAction> jComboBox2 = this.myDeleteRule;
        jPanel2.add(jComboBox2, new GridConstraints(1, 0, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDeferrabilityWrapper = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseForeignKeyEditor.class).getString("DatabaseColumnEditor.label.deferrability"));
        jPanel.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JComboBox<DasForeignKey.Deferrability> jComboBox3 = this.myDeferrability;
        jPanel.add(jComboBox3, new GridConstraints(1, 0, 1, 2, 0, 1, 2, 0, null, null, null));
        jBLabel.setLabelFor((Component)editorTextField2);
        jBLabel2.setLabelFor((Component)editorTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseForeignKeyEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseForeignKeyEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusableComponents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribeColumn";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetTableColumns";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKey";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEditor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefListModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateRuleEditor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteRuleEditor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeferrabilityEditor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "subscribeColumn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

