/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoaderImpl;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DriverClasspathPanel
implements Disposable {
    @NotNull
    private final Project myProject;
    @Nullable
    private final LocalDataSource myDataSource;
    private final AbstractDatabaseConfigurable<?> myConfigurable;
    @NotNull
    private DatabaseDriverImpl myDriver;
    @NotNull
    private final DatabaseConfigEditor myController;
    private TableView<ClassPathItem> myArtifactList;
    private MyUserActivityPanel myArtifactsPanel;
    private Runnable onUpdate;
    private ListTableModel<ClassPathItem> myArtifactsModel;

    private void replaceProvided(ProvidedItem providedItem, @NotNull String id, @Nullable Version version, String channel, @Nullable List<SimpleClasspathElement> legacy) {
        if (id == null) {
            DriverClasspathPanel.$$$reportNull$$$0(0);
        }
        ProvidedItem item = new ProvidedItem(id, version, channel, legacy);
        int idx = this.myArtifactsModel.indexOf((Object)providedItem);
        if (idx != -1) {
            this.myArtifactsModel.setItem(idx, (Object)item);
        }
    }

    public DriverClasspathPanel(@NotNull Project project, @NotNull AbstractDatabaseConfigurable<?> configurable, @NotNull DatabaseDriver driver, @Nullable LocalDataSource dataSource, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            DriverClasspathPanel.$$$reportNull$$$0(1);
        }
        if (configurable == null) {
            DriverClasspathPanel.$$$reportNull$$$0(2);
        }
        if (driver == null) {
            DriverClasspathPanel.$$$reportNull$$$0(3);
        }
        if (controller == null) {
            DriverClasspathPanel.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myConfigurable = configurable;
        this.myDriver = (DatabaseDriverImpl)driver;
        this.myDataSource = dataSource;
        this.myController = controller;
        DatabaseDriverManager.getInstance().addDriverListener(new DatabaseDriverListener.Adapter(){

            @Override
            public void driverUpdated(DatabaseDriver driver) {
                if (driver == DriverClasspathPanel.this.myDriver) {
                    DriverClasspathPanel.this.updateClasspath();
                    DriverClasspathPanel.this.providedChanged(null);
                    DriverClasspathPanel.this.fireUserActivity();
                }
            }
        }, this);
    }

    private void providedChanged(@Nullable ProvidedItem provided) {
        int i2 = this.myArtifactsModel.indexOf((Object)provided);
        if (i2 == -1) {
            this.myArtifactsModel.fireTableDataChanged();
        } else {
            this.myArtifactsModel.fireTableRowsUpdated(i2, i2);
        }
    }

    public void dispose() {
    }

    private void fireUserActivity() {
        ((ChangeListener)this.myArtifactsPanel.myDispatcher.getMulticaster()).stateChanged(this.myArtifactsPanel.myEvent);
    }

    public void setDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DriverClasspathPanel.$$$reportNull$$$0(5);
        }
        this.myDriver = (DatabaseDriverImpl)driver;
        this.updateClasspath();
        this.providedChanged(null);
    }

    public void setOnUpdate(Runnable onUpdate) {
        this.onUpdate = onUpdate;
    }

    public JComponent createComponent() {
        this.myArtifactsPanel = new MyUserActivityPanel();
        this.myArtifactsPanel.setLayout(new BorderLayout());
        this.myArtifactsModel = new ListTableModel<ClassPathItem>((ColumnInfo[])ContainerUtil.ar((Object[])new 2[]{new ColumnInfo<ClassPathItem, ClassPathItem>(""){
            private final MyProvidedEditor myProvidedEditor;
            private final MyProvidedRenderer myProvidedRenderer;
            private final TableCellRenderer mySimpleRenderer;
            {
                this.myProvidedEditor = new MyProvidedEditor();
                this.myProvidedRenderer = new MyProvidedRenderer();
                this.mySimpleRenderer = new MySimpleRenderer();
            }

            @Nullable
            public ClassPathItem valueOf(ClassPathItem o) {
                return o;
            }

            public boolean isCellEditable(ClassPathItem item) {
                return this.isProvided(item);
            }

            private boolean isProvided(ClassPathItem item) {
                return item instanceof ProvidedItem;
            }

            @NotNull
            public TableCellRenderer getRenderer(ClassPathItem item) {
                TableCellRenderer tableCellRenderer = this.isProvided(item) ? this.myProvidedRenderer : this.mySimpleRenderer;
                if (tableCellRenderer == null) {
                    2.$$$reportNull$$$0(0);
                }
                return tableCellRenderer;
            }

            @Nullable
            public TableCellEditor getEditor(ClassPathItem item) {
                return this.isProvided(item) ? this.myProvidedEditor : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel$2", "getRenderer"));
            }
        }})){

            public void setValueAt(Object aValue, int rowIndex, int columnIndex, boolean notifyListeners) {
            }
        };
        this.myArtifactsModel.addTableModelListener(e -> this.onUpdateClasspath());
        this.myArtifactList = new TableView<ClassPathItem>(this.myArtifactsModel){

            public String getToolTipText(@NotNull MouseEvent event) {
                int row;
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                ProvidedItem item = (row = this.rowAtPoint(event.getPoint())) == -1 ? null : (ProvidedItem)ObjectUtils.tryCast((Object)DriverClasspathPanel.this.myArtifactsModel.getItem(row), ProvidedItem.class);
                return item == null ? null : item.getToolTipText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/ui/DriverClasspathPanel$5", "getToolTipText"));
            }
        };
        this.myArtifactList.setTableHeader(null);
        this.myArtifactList.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DriverClasspathPanel.this.myArtifactList.repaint();
            }
        });
        this.myArtifactList.setShowGrid(false);
        this.myArtifactList.getEmptyText().setText(DatabaseBundle.message("status.text.no.driver.files", new Object[0]));
        this.myArtifactList.setVisibleRowCount(5);
        final String CUSTOM_JAR = DatabaseBundle.message("database.driver.settings.classpath.custom.jars", new Object[0]);
        final String CUSTOM_NATIVE = DatabaseBundle.message("database.driver.settings.classpath.native.lib.path", new Object[0]);
        final String PROVIDED = DatabaseBundle.message("database.driver.settings.classpath.provided.driver", new Object[0]);
        JPanel artifactsListPanel = ToolbarDecorator.createDecorator(this.myArtifactList).setAddAction(button -> {
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, new String[]{CUSTOM_JAR, CUSTOM_NATIVE, PROVIDED}){

                @Nls
                @NotNull
                public String getTextFor(@Nls String value) {
                    String string = value;
                    if (string == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean hasSubstep(String selectedValue) {
                    return selectedValue.equals(PROVIDED);
                }

                public Icon getIconFor(String value) {
                    if (CUSTOM_JAR.equals(value)) {
                        return AllIcons.Nodes.PpJar;
                    }
                    if (CUSTOM_NATIVE.equals(value)) {
                        return AllIcons.Nodes.NativeLibrariesFolder;
                    }
                    if (PROVIDED.equals(value)) {
                        return AllIcons.Nodes.PpLib;
                    }
                    return null;
                }

                public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                    if (selectedValue == null) {
                        return FINAL_CHOICE;
                    }
                    if (selectedValue.equals(PROVIDED)) {
                        return new ArtifactsPopupStep();
                    }
                    this.doFinalStep(() -> DriverClasspathPanel.this.addCustomDrivers(selectedValue.equals(CUSTOM_NATIVE)));
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel$7", "getTextFor"));
                }
            });
            RelativePoint pref = button.getPreferredPopupPoint();
            popup2.show(pref);
        }).disableUpDownActions().createPanel();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DatabaseArtifactManager.TOPIC, version -> {
            if (this.getProvided().isEmpty()) {
                return;
            }
            ProvidedItem provided = this.getProvided(version);
            this.onUpdateClasspath();
            this.providedChanged(provided);
        });
        this.myArtifactsPanel.add((Component)new TitledSeparator(DatabaseBundle.message("separator.driver.files", new Object[0])), "North");
        this.myArtifactsPanel.add(artifactsListPanel);
        return this.myArtifactsPanel;
    }

    private void downloadImpl(final @NotNull DatabaseArtifactList.ArtifactVersion version) {
        if (version == null) {
            DriverClasspathPanel.$$$reportNull$$$0(6);
        }
        new Task.Modal(this.myProject, DatabaseBundle.message("progress.title.downloading", new Object[0]) + version.artifact.name, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    8.$$$reportNull$$$0(0);
                }
                DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
                try {
                    Consumer uiUpdate = version -> {
                        ProvidedItem provided = (ProvidedItem)DriverClasspathPanel.this.getProvided().filter(p2 -> version2.artifact.isId(p2.id)).first();
                        if (provided != null) {
                            DriverClasspathPanel.this.replaceProvided(provided, provided.id, version2.version, provided.channel, provided.legacy);
                        }
                        DriverClasspathPanel.this.providedChanged(provided);
                        DriverClasspathPanel.this.onUpdateClasspath();
                        DriverClasspathPanel.this.fireUserActivity();
                    };
                    if (loader.isValid(version)) {
                        ApplicationManager.getApplication().invokeLater(() -> uiUpdate.consume((Object)version));
                    } else {
                        DatabaseArtifactManager.getInstance().downloadArtifact(version, (Consumer<? super DatabaseArtifactList.ArtifactVersion>)uiUpdate);
                    }
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> DriverClasspathPanel.this.myController.showErrorNotification(DriverClasspathPanel.this.myConfigurable, (Object)this, e));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DriverClasspathPanel$8", "run"));
            }
        }.queue();
    }

    private void doChooseFiles(boolean isNative, @NotNull Consumer<? super List<VirtualFile>> consumer) {
        if (consumer == null) {
            DriverClasspathPanel.$$$reportNull$$$0(7);
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, isNative, true, true, false, true).withExtensionFilter((FileType)ArchiveFileType.INSTANCE).withTitle(DatabaseBundle.message("dialog.title.select.database.driver.files", new Object[0]));
        File dir = new File(DatabaseArtifactLoaderImpl.getDownloadPath());
        try {
            FileUtil.ensureExists((File)dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VirtualFile toSelect = VfsUtil.findFileByIoFile((File)dir, (boolean)true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)this.myProject, (Component)this.myArtifactsPanel, (VirtualFile)toSelect, consumer);
    }

    public void updateClasspath() {
        ArrayList<ClassPathItem> items = new ArrayList<ClassPathItem>();
        if (this.myDataSource != null) {
            if (this.myArtifactsModel.getRowCount() == 0) {
                for (SimpleClasspathElement cp : this.myDataSource.getOwnClasspath()) {
                    items.add(new SimpleItem(cp, false));
                }
            } else {
                items.addAll(this.myArtifactsModel.getItems());
            }
        } else {
            for (DatabaseDriver.ArtifactRef artifact : this.myDriver.getArtifacts()) {
                List<SimpleClasspathElement> cp = DatabaseDriverImpl.getLegacyElements(artifact);
                items.add(new ProvidedItem(artifact.getId(), artifact.getArtifactVersion(), artifact.getChannel(), cp));
            }
            for (SimpleClasspathElement element : this.myDriver.getAdditionalClasspathElements()) {
                items.add(new SimpleItem(element, false));
            }
            for (SimpleClasspathElement element : this.myDriver.getNativeLibraryPaths()) {
                items.add(new SimpleItem(element, true));
            }
        }
        this.myArtifactsModel.setItems(items);
        this.onUpdateClasspath();
    }

    private void onUpdateClasspath() {
        if (this.onUpdate != null) {
            this.onUpdate.run();
        }
    }

    public List<SimpleClasspathElement> getClasspath(boolean isNative) {
        TableModel artifactListModel = this.myArtifactList.getModel();
        ArrayList<SimpleClasspathElement> fileList = new ArrayList<SimpleClasspathElement>();
        for (int i2 = 0; i2 < artifactListModel.getRowCount(); ++i2) {
            SimpleItem item = (SimpleItem)ObjectUtils.tryCast((Object)artifactListModel.getValueAt(i2, 0), SimpleItem.class);
            if (item == null || item.isNative != isNative) continue;
            fileList.add(item.element);
        }
        return fileList;
    }

    public List<SimpleClasspathElement> getClasspathFull() {
        List classpath = (List)JdbcConsoleRunContext.expandPacks(this.getClasspath(false)).addAllTo(new ArrayList());
        for (ProvidedItem provided : this.getProvided()) {
            if (provided.version == null) {
                if (provided.legacy == null) continue;
                classpath.addAll(provided.legacy);
                continue;
            }
            classpath.addAll(provided.getClasspathElements());
        }
        return classpath;
    }

    @NotNull
    public List<DatabaseDriver.ArtifactRef> getArtifactRefs() {
        List list = this.getProvided().map(p2 -> DatabaseDriverImpl.createArtifactRef(p2.id, p2.version, p2.channel)).toList();
        if (list == null) {
            DriverClasspathPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    private ProvidedItem getProvided(@Nullable DatabaseArtifactList.ArtifactVersion version) {
        return version == null ? null : (ProvidedItem)this.getProvided().find(p2 -> version.artifact.isId(p2.id) && version.version.equals(p2.version));
    }

    private JBIterable<ProvidedItem> getProvided() {
        return JBIterable.from((Iterable)this.myArtifactList.getItems()).filter(ProvidedItem.class);
    }

    public void addCustomDrivers(boolean isNative) {
        this.doChooseFiles(isNative, (Consumer<? super List<VirtualFile>>)((Consumer)files2 -> {
            for (VirtualFile file : files2) {
                for (SimpleClasspathElement cpe : SimpleClasspathElementFactory.createElements((String[])new String[]{file.getUrl()})) {
                    this.myArtifactsModel.addRow((Object)new SimpleItem(cpe, isNative));
                }
            }
        }));
    }

    @NotNull
    public static List<DatabaseArtifactList.VersionRef> getAllArtifacts(@NotNull DatabaseArtifactList artifacts, @NotNull DatabaseDriverImpl driver, @NotNull String id) {
        DatabaseArtifactList.Artifact artifact;
        if (artifacts == null) {
            DriverClasspathPanel.$$$reportNull$$$0(9);
        }
        if (driver == null) {
            DriverClasspathPanel.$$$reportNull$$$0(10);
        }
        if (id == null) {
            DriverClasspathPanel.$$$reportNull$$$0(11);
        }
        if ((artifact = artifacts.getArtifact(id)) == null) {
            List<DatabaseArtifactList.VersionRef> list = Collections.emptyList();
            if (list == null) {
                DriverClasspathPanel.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<DatabaseArtifactList.VersionRef> res2 = new ArrayList<DatabaseArtifactList.VersionRef>();
        for (DatabaseArtifactList.Channel channel : artifacts.getChannels()) {
            if (!channel.isEnabledFor(artifact)) continue;
            res2.add(channel);
        }
        res2.addAll(ContainerUtil.filter(artifact.versions, v -> DatabaseArtifactList.isCompatible(driver, v)));
        ArrayList<DatabaseArtifactList.VersionRef> arrayList = res2;
        if (arrayList == null) {
            DriverClasspathPanel.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DriverClasspathPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactRefs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceProvided";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDriver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "downloadImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doChooseFiles";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllArtifacts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 12, 13 -> new IllegalStateException(string);
        };
    }

    private final class ProvidedItem
    implements ClassPathItem {
        private final String id;
        private final Version version;
        private final List<SimpleClasspathElement> legacy;
        private final String channel;
        boolean actualDownloaded;
        boolean invalid;
        boolean needUpdate;

        ProvidedItem(@Nullable String id, Version version, @Nullable String channel, List<SimpleClasspathElement> legacy) {
            if (id == null) {
                ProvidedItem.$$$reportNull$$$0(0);
            }
            this.id = id;
            this.version = version;
            this.channel = channel;
            this.legacy = version == null ? legacy : null;
            DatabaseArtifactList artifactList = DatabaseArtifactManager.getArtifacts();
            this.invalid = !DatabaseDriverUtils.isDriverFilesValid(artifactList, id, version, this.legacy);
            boolean bl = this.needUpdate = this.invalid || !DatabaseDriverUtils.isDriverFilesUpToDate(artifactList, DriverClasspathPanel.this.myDriver, id, version, channel);
            this.actualDownloaded = !this.needUpdate || DatabaseDriverUtils.isDriverFilesUpToDate(artifactList, DriverClasspathPanel.this.myDriver, id, version == null ? Version.INFINITY : version, channel);
        }

        @Nullable
        DatabaseArtifactList.ArtifactVersion resolve() {
            return DatabaseArtifactList.resolveVersion(DatabaseArtifactManager.getArtifacts(), this.id, this.version, this.channel, DriverClasspathPanel.this.myDriver);
        }

        @NlsContexts.Tooltip
        public String getToolTipText() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.id);
            if (this.channel != null) {
                builder.append(DatabaseBundle.message("driver.classpath.channel.0", this.channel));
            }
            if (this.version == null) {
                if (ContainerUtil.isEmpty(this.legacy)) {
                    builder.append(DatabaseBundle.message("driver.classpath.with.no.files", new Object[0]));
                } else {
                    builder.append(DatabaseBundle.message("driver.classpath.with.old.files", new Object[0])).append("<br>");
                    for (SimpleClasspathElement element : this.legacy) {
                        for (String url2 : element.getClassesRootUrls()) {
                            if (builder.length() != 0) {
                                builder.append("<br>");
                            }
                            builder.append(VfsUtilCore.urlToPath((String)url2));
                        }
                    }
                }
            } else {
                builder.append(DatabaseBundle.message("driver.classpath.ver.0", this.version)).append("<br>");
                this.getClasspathElements().stream().flatMap(o -> o.getClassesRootUrls().stream()).forEach(url -> {
                    if (builder.length() != 0) {
                        builder.append("<br>");
                    }
                    builder.append(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
                });
            }
            return builder.toString();
        }

        public String toString() {
            return this.id + ":" + this.version + (String)(this.channel != null ? "[" + this.channel + "]" : "");
        }

        @NotNull
        public List<SimpleClasspathElement> getClasspathElements() {
            List<SimpleClasspathElement> list = DatabaseArtifactManager.getClasspathElements(this.id, this.version);
            if (list == null) {
                ProvidedItem.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DriverClasspathPanel$ProvidedItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel$ProvidedItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClasspathElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyUserActivityPanel
    extends JPanel
    implements UserActivityProviderComponent {
        private final EventDispatcher<ChangeListener> myDispatcher = EventDispatcher.create(ChangeListener.class);
        private final ChangeEvent myEvent = new ChangeEvent(this);

        private MyUserActivityPanel() {
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyUserActivityPanel.$$$reportNull$$$0(0);
            }
            this.myDispatcher.addListener((EventListener)changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyUserActivityPanel.$$$reportNull$$$0(1);
            }
            this.myDispatcher.removeListener((EventListener)changeListener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel$MyUserActivityPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SimpleItem
    implements ClassPathItem {
        @NotNull
        SimpleClasspathElement element;
        @Nullable
        File file;
        boolean isNative;

        SimpleItem(@NotNull SimpleClasspathElement element, boolean isNative) {
            if (element == null) {
                SimpleItem.$$$reportNull$$$0(0);
            }
            this.element = element;
            this.isNative = isNative;
            String url = (String)ContainerUtil.getFirstItem((List)element.getClassesRootUrls());
            if (url != null) {
                this.file = new File(PathUtil.toPresentableUrl((String)url));
            }
        }

        public String toString() {
            String url = (String)ContainerUtil.getFirstItem((List)this.element.getClassesRootUrls());
            return url == null ? "" : PathUtil.toPresentableUrl((String)url);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/ui/DriverClasspathPanel$SimpleItem", "<init>"));
        }
    }

    private static class VersionsPopupStep
    extends BaseListPopupStep<DatabaseArtifactList.VersionRef> {
        public static List<DatabaseArtifactList.VersionRef> getVersions(@NotNull String name2, @NotNull DatabaseDriverImpl driver) {
            if (name2 == null) {
                VersionsPopupStep.$$$reportNull$$$0(0);
            }
            if (driver == null) {
                VersionsPopupStep.$$$reportNull$$$0(1);
            }
            return DriverClasspathPanel.getAllArtifacts(DatabaseArtifactManager.getArtifacts(), driver, name2);
        }

        VersionsPopupStep(@NotNull String name2, @NotNull DatabaseDriverImpl driver) {
            if (name2 == null) {
                VersionsPopupStep.$$$reportNull$$$0(2);
            }
            if (driver == null) {
                VersionsPopupStep.$$$reportNull$$$0(3);
            }
            super(null, VersionsPopupStep.getVersions(name2, driver));
        }

        @NotNull
        public String getTextFor(DatabaseArtifactList.VersionRef value) {
            String string = value.getVersionDisplayName();
            if (string == null) {
                VersionsPopupStep.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(DatabaseArtifactList.VersionRef value) {
            DatabaseArtifactList.ArtifactVersion version = (DatabaseArtifactList.ArtifactVersion)ObjectUtils.tryCast((Object)value, DatabaseArtifactList.ArtifactVersion.class);
            if (version == null) {
                return null;
            }
            List values = this.getValues();
            int idx = values.indexOf(value);
            DatabaseArtifactList.ArtifactVersion prev2 = idx < 1 ? null : (DatabaseArtifactList.ArtifactVersion)ObjectUtils.tryCast(values.get(idx - 1), DatabaseArtifactList.ArtifactVersion.class);
            return prev2 == null ? new ListSeparator() : null;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driver";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DriverClasspathPanel$VersionsPopupStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DriverClasspathPanel$VersionsPopupStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getVersions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private class ArtifactsPopupStep
    extends BaseListPopupStep<DatabaseArtifactList.Artifact> {
        private final DatabaseArtifactList.Artifact myPredef;
        private final DatabaseArtifactList.Artifact myUpdate;

        ArtifactsPopupStep() {
            super(null, (Object[])new DatabaseArtifactList.Artifact[0]);
            this.myUpdate = new DatabaseArtifactList.Artifact("UPDATE", "Update List");
            DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
            this.getValues().addAll(artifacts.getArtifacts());
            this.getValues().sort((s1, s2) -> StringUtil.naturalCompare((String)s1.name, (String)s2.name));
            this.myPredef = artifacts.getArtifact(DatabaseDriverManager.getInstance().getPredefinedArtifact(DriverClasspathPanel.this.myDriver.getId()));
            if (this.myPredef != null) {
                this.getValues().remove(this.myPredef);
                this.getValues().add(0, this.myPredef);
            }
            this.getValues().add(this.myUpdate);
        }

        @Nullable
        public ListSeparator getSeparatorAbove(DatabaseArtifactList.Artifact value) {
            List values = this.getValues();
            return this.myPredef != null && values.size() > 1 && Objects.equals(value, values.get(1)) || value == this.myUpdate ? new ListSeparator() : null;
        }

        public boolean hasSubstep(DatabaseArtifactList.Artifact selectedValue) {
            return selectedValue != this.myUpdate;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(DatabaseArtifactList.Artifact value) {
            String string = value.name;
            if (string == null) {
                ArtifactsPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PopupStep<?> onChosen(final DatabaseArtifactList.Artifact artifact, boolean finalChoice) {
            if (artifact == null) {
                return FINAL_CHOICE;
            }
            if (artifact == this.myUpdate) {
                ApplicationManager.getApplication().invokeLater(() -> DatabaseArtifactManager.getInstance().forceUpdate(DriverClasspathPanel.this.myProject));
                return FINAL_CHOICE;
            }
            return new VersionsPopupStep(artifact.id, DriverClasspathPanel.this.myDriver){

                public PopupStep<?> onChosen(DatabaseArtifactList.VersionRef v, boolean finalChoice) {
                    if (v == null) {
                        return FINAL_CHOICE;
                    }
                    return this.doFinalStep(() -> {
                        String cn;
                        DatabaseArtifactList.Channel channel = (DatabaseArtifactList.Channel)ObjectUtils.tryCast((Object)v, DatabaseArtifactList.Channel.class);
                        DriverClasspathPanel.this.fireUserActivity();
                        ProvidedItem provided = (ProvidedItem)DriverClasspathPanel.this.getProvided().find(p2 -> artifact.isId(p2.id));
                        DatabaseArtifactList.ArtifactVersion version = (DatabaseArtifactList.ArtifactVersion)ObjectUtils.tryCast((Object)v, DatabaseArtifactList.ArtifactVersion.class);
                        Version ver = version == null ? null : version.version;
                        String string = cn = channel == null ? null : channel.id;
                        if (provided != null) {
                            DriverClasspathPanel.this.replaceProvided(provided, artifact2.id, ver, cn, null);
                        } else {
                            provided = new ProvidedItem(artifact2.id, ver, cn, null);
                            DriverClasspathPanel.this.myArtifactsModel.addRow((Object)provided);
                        }
                        if (version != null) {
                            DriverClasspathPanel.this.downloadImpl(version);
                        }
                    });
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DriverClasspathPanel$ArtifactsPopupStep", "getTextFor"));
        }
    }

    private class MyProvidedRenderer
    implements TableCellRenderer {
        private final JComponent myComponent = new Box(0){

            @Override
            public void validate() {
                super.validate();
                1.sendMouseMove(MyProvidedRenderer.this.myVersionLink);
                1.sendMouseMove(MyProvidedRenderer.this.myFixLink);
                1.sendMouseMove(MyProvidedRenderer.this.myLicenseLink);
            }

            private static void sendMouseMove(LinkLabel<?> link) {
                PointerInfo info2 = MouseInfo.getPointerInfo();
                Point pos = info2 == null ? new Point(-1, -1) : info2.getLocation();
                SwingUtilities.convertPointFromScreen(pos, link);
                boolean outside = pos.x < 0 || pos.y < 0 || pos.x > link.getWidth() || pos.y > link.getHeight();
                MouseEvent e = new MouseEvent((Component)link, outside ? 505 : 503, System.currentTimeMillis(), 0, pos.x, pos.y, 0, false);
                link.dispatchEvent((AWTEvent)e);
            }
        };
        private final SimpleColoredRenderer myColored = new SimpleColoredRenderer();
        private final LinkLabel<ProvidedItem> myVersionLink = new MyLinkLabel<ProvidedItem>(DatabaseBundle.message("database.driver.settings.classpath.ver.label", new Object[0]));
        private final LinkLabel<ProvidedItem> myFixLink = new MyLinkLabel<ProvidedItem>("");
        private final LinkLabel<ProvidedItem> myLicenseLink = new MyLinkLabel<ProvidedItem>(DatabaseBundle.message("database.driver.settings.classpath.show.license.label", new Object[0]));
        private boolean mySelected;

        private MyProvidedRenderer() {
            this.myComponent.setOpaque(true);
            this.myComponent.add((Component)this.myColored);
            this.myComponent.add(Box.createHorizontalStrut(10));
            this.myComponent.add((Component)this.myVersionLink);
            this.myComponent.add(Box.createHorizontalGlue());
            this.myComponent.add((Component)this.myFixLink);
            this.myComponent.add(Box.createHorizontalStrut(20));
            this.myComponent.add((Component)this.myLicenseLink);
            this.myComponent.add(Box.createHorizontalStrut(10));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
            this.mySelected = isSelected;
            this.myColored.clear();
            this.myColored.acquireState(table, isSelected, false, row, column2);
            this.myColored.getCellState().updateRenderer(this.myComponent);
            this.myComponent.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)hasFocus));
            this.myColored.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)hasFocus));
            ProvidedItem item = (ProvidedItem)ObjectUtils.tryCast((Object)value, ProvidedItem.class);
            if (item != null) {
                DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
                DatabaseArtifactList.Artifact artifact = artifacts.getArtifact(item.id);
                this.myColored.append(artifact == null ? item.id : artifact.name, item.invalid ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.myColored.setIcon(PlatformIcons.LIBRARY_ICON);
                this.myVersionLink.setVisible(item.version != null);
                this.myVersionLink.setText(DatabaseBundle.message("database.driver.settings.classpath.ver.pattern", item.version, item.channel != null ? " [" + item.channel + "]" : ""));
                this.myVersionLink.setListener(this::switchVersion, (Object)item);
                DatabaseArtifactList.ArtifactVersion actual = item.resolve();
                this.myFixLink.setVisible(actual != null && (item.invalid || item.needUpdate));
                Version version = actual == null ? null : actual.version;
                String versionText = version == null ? "<unknown>" : version.toString();
                this.myFixLink.setText(item.actualDownloaded ? DatabaseBundle.message("database.driver.settings.classpath.switch.to.link", versionText) : DatabaseBundle.message("database.driver.settings.classpath.download.link", versionText));
                this.myFixLink.setListener(this::fixArtifact, (Object)item);
                this.myLicenseLink.setVisible(item.version != null);
                this.myLicenseLink.setListener(this::showLicense, (Object)item);
            }
            this.myColored.setMaximumSize(this.myColored.getPreferredSize());
            return this.myComponent;
        }

        private void switchVersion(LinkLabel<?> label, final ProvidedItem item) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new VersionsPopupStep(item.id, DriverClasspathPanel.this.myDriver){

                public PopupStep<?> onChosen(DatabaseArtifactList.VersionRef selectedValue, boolean finalChoice) {
                    if (selectedValue != null) {
                        this.doFinalStep(() -> {
                            DatabaseArtifactList.Channel channel = (DatabaseArtifactList.Channel)ObjectUtils.tryCast((Object)selectedValue, DatabaseArtifactList.Channel.class);
                            DatabaseArtifactList.ArtifactVersion version = channel == null ? (DatabaseArtifactList.ArtifactVersion)ObjectUtils.tryCast((Object)selectedValue, DatabaseArtifactList.ArtifactVersion.class) : DatabaseArtifactList.resolveVersion(DatabaseArtifactManager.getArtifacts(), item2.id, null, channel.id, DriverClasspathPanel.this.myDriver);
                            DriverClasspathPanel.this.replaceProvided(item, item2.id, version == null ? null : version.version, channel == null ? null : channel.id, null);
                            if (version != null) {
                                DriverClasspathPanel.this.downloadImpl(version);
                            }
                            DriverClasspathPanel.this.fireUserActivity();
                        });
                    }
                    return FINAL_CHOICE;
                }
            }).show(RelativePoint.getSouthWestOf(label));
        }

        private void fixArtifact(LinkLabel<?> label, ProvidedItem item) {
            DatabaseArtifactList.ArtifactVersion version = item.resolve();
            if (version != null) {
                DriverClasspathPanel.this.downloadImpl(version);
            }
        }

        private void showLicense(LinkLabel<ProvidedItem> label, ProvidedItem o) {
            if (o.version == null) {
                return;
            }
            DatabaseArtifactList.ArtifactVersion actual = o.resolve();
            JBIterable licenses = actual == null ? JBIterable.from(o.getClasspathElements()).flatMap(SimpleClasspathElement::getClassesRootUrls).filter(e -> StringUtil.endsWithIgnoreCase((String)e, (String)"-license.txt") || StringUtil.endsWithIgnoreCase((String)e, (String)"-agreement.txt") || StringUtil.endsWithIgnoreCase((String)e, (String)"/COPYING") || StringUtil.endsWithIgnoreCase((String)e, (String)"/LICENSE")) : JBIterable.from(actual.items).filter(i2 -> i2.type == DatabaseArtifactList.Item.Type.LICENSE).map(i2 -> i2.url);
            licenses.forEach(l -> BrowserUtil.browse((String)l, (Project)DriverClasspathPanel.this.myProject));
        }

        private class MyLinkLabel<T>
        extends LinkLabel<T> {
            MyLinkLabel(String text2) {
                super(text2, null);
            }

            protected Color getNormal() {
                return MyProvidedRenderer.this.mySelected ? UIUtil.getListForeground((boolean)true, (boolean)true) : super.getNormal();
            }

            protected Color getHover() {
                return MyProvidedRenderer.this.mySelected ? UIUtil.getListForeground((boolean)true, (boolean)true) : super.getHover();
            }
        }
    }

    private class MyProvidedEditor
    extends AbstractTableCellEditor {
        private final MyProvidedRenderer myDelegate;
        Object v;

        private MyProvidedEditor() {
            this.myDelegate = new MyProvidedRenderer();
            this.v = null;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column2) {
            this.v = value;
            return this.myDelegate.getTableCellRendererComponent(table, value, isSelected, true, row, column2);
        }

        public Object getCellEditorValue() {
            return this.v;
        }
    }

    private static class MySimpleRenderer
    implements TableCellRenderer {
        SimpleColoredRenderer myComponent = new SimpleColoredRenderer();

        private MySimpleRenderer() {
            this.myComponent.setTransparentIconBackground(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column2) {
            this.myComponent.clear();
            this.myComponent.acquireState(table, isSelected, false, row, column2);
            this.myComponent.getCellState().updateRenderer((JComponent)this.myComponent);
            SimpleItem item = (SimpleItem)ObjectUtils.tryCast((Object)value, SimpleItem.class);
            if (item != null) {
                SimpleTextAttributes style = item.file != null && item.file.exists() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
                this.myComponent.append(item.file != null ? item.file.getPath() : item.element.getPresentableName(), style);
                if (item.file != null) {
                    this.myComponent.setIcon(item.isNative ? AllIcons.Nodes.NativeLibrariesFolder : (!item.file.exists() ? PlatformIcons.FILE_ICON : (item.file.isDirectory() ? PlatformIcons.FOLDER_ICON : FileTypeManager.getInstance().getFileTypeByExtension(FileUtilRt.getExtension((String)item.file.getName())).getIcon())));
                } else {
                    this.myComponent.setIcon(PlatformIcons.LIBRARY_ICON);
                }
            }
            return this.myComponent;
        }
    }

    private static interface ClassPathItem {
    }
}

