/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JSFlexAdapter;
import com.intellij.sql.dialects.mongo.js._MongoJSLexer;
import org.jetbrains.annotations.NotNull;

public final class MongoJSStringUtil {
    public static String escapeTemplateStringChars(@NotNull String source, boolean escapeSlash, boolean escapeWhitespace, @NotNull PsiElement context) {
        if (source == null) {
            MongoJSStringUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MongoJSStringUtil.$$$reportNull$$$0(1);
        }
        StringBuilder result2 = new StringBuilder();
        int index = 0;
        while (index < source.length()) {
            char ch = source.charAt(index);
            if (ch == '$' && index < source.length() - 1 && source.charAt(index + 1) == '{' && (index == 0 || source.charAt(index - 1) != '/')) {
                int end = MongoJSStringUtil.findTemplateArgumentEnd(source, index + 2, context);
                result2.append(source, index, end);
                index = end;
                continue;
            }
            MongoJSStringUtil.escapeSingleChar(source, '`', escapeSlash, false, escapeWhitespace, false, result2, index);
            ++index;
        }
        return result2.toString();
    }

    private static void escapeSingleChar(@NotNull String str, char quote, boolean escapeSlash, boolean escapeNewlines, boolean escapeWhitespace, boolean escapeTemplateStringArg, @NotNull StringBuilder buffer, int idx) {
        char previous;
        if (str == null) {
            MongoJSStringUtil.$$$reportNull$$$0(2);
        }
        if (buffer == null) {
            MongoJSStringUtil.$$$reportNull$$$0(3);
        }
        char ch = str.charAt(idx);
        char c2 = previous = idx > 0 ? str.charAt(idx - 1) : (char)'\u0000';
        if (escapeSlash && ch == '\\') {
            char afterNext;
            char next = idx < str.length() - 1 ? str.charAt(idx + 1) : (char)'\u0000';
            char c3 = afterNext = idx < str.length() - 2 ? str.charAt(idx + 2) : (char)'\u0000';
            if ((next == 'u' || next == 'x') && StringUtil.isHexDigit((char)afterNext)) {
                buffer.append('\\');
            } else {
                buffer.append("\\\\");
            }
        } else if (ch == quote) {
            if (previous != '\\') {
                buffer.append("\\");
            }
            buffer.append(ch);
        } else if (escapeTemplateStringArg && ch == '{') {
            if (previous == '$') {
                buffer.append("\\").append(ch);
            } else {
                buffer.append(ch);
            }
        } else {
            if (escapeWhitespace) {
                if (ch == '\b') {
                    buffer.append("\\b");
                    return;
                }
                if (ch == '\t') {
                    buffer.append("\\t");
                    return;
                }
                if (ch == '\f') {
                    buffer.append("\\f");
                    return;
                }
                if (ch == '\r') {
                    buffer.append("\\r");
                    return;
                }
            }
            if (escapeNewlines && ch == '\n') {
                buffer.append("\\n");
                return;
            }
            buffer.append(ch);
        }
    }

    private static int findTemplateArgumentEnd(@NotNull String source, int startIndex, @NotNull PsiElement context) {
        if (source == null) {
            MongoJSStringUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            MongoJSStringUtil.$$$reportNull$$$0(5);
        }
        JSFlexAdapter lexer = new JSFlexAdapter(new _MongoJSLexer(null, false));
        lexer.start(source, startIndex, source.length());
        int depth = 0;
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() == JSElementTypes.DOLLAR) {
                lexer.advance();
                if (lexer.getTokenType() == JSElementTypes.LBRACE) {
                    ++depth;
                }
            } else if (lexer.getTokenType() == JSElementTypes.LBRACE) {
                ++depth;
            } else if (lexer.getTokenType() == JSElementTypes.RBRACE && --depth == -1) {
                return lexer.getTokenEnd();
            }
            lexer.advance();
        }
        return source.length();
    }

    @NotNull
    public static String unescapeSimpleStringChars(@NotNull String chars) {
        if (chars == null) {
            MongoJSStringUtil.$$$reportNull$$$0(6);
        }
        int index = 0;
        StringBuilder outChars = new StringBuilder();
        block12: while (index < chars.length()) {
            char c2 = chars.charAt(index);
            ++index;
            if (c2 != '\\') {
                outChars.append(c2);
                continue;
            }
            if (index >= chars.length()) break;
            c2 = chars.charAt(index);
            ++index;
            if (c2 == 'u' || c2 == 'x') {
                outChars.append('\\').append(c2);
                continue;
            }
            switch (c2) {
                case 'b': {
                    outChars.append('\b');
                    continue block12;
                }
                case 't': {
                    outChars.append('\t');
                    continue block12;
                }
                case 'n': {
                    outChars.append('\n');
                    continue block12;
                }
                case 'f': {
                    outChars.append('\f');
                    continue block12;
                }
                case 'r': {
                    outChars.append('\r');
                    continue block12;
                }
                case '\"': {
                    outChars.append('\"');
                    continue block12;
                }
                case '/': {
                    outChars.append('/');
                    continue block12;
                }
                case '\n': {
                    outChars.append('\n');
                    continue block12;
                }
                case '\'': {
                    outChars.append('\'');
                    continue block12;
                }
                case '\\': {
                    outChars.append('\\');
                    continue block12;
                }
            }
            outChars.append(c2);
        }
        String string = outChars.toString();
        if (string == null) {
            MongoJSStringUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static void escapeSimpleStringChars(@NotNull String str, char quote, boolean escapeNewlines, boolean escapeWhitespace, boolean escapeTemplateStringArg, @NotNull StringBuilder buffer) {
        if (str == null) {
            MongoJSStringUtil.$$$reportNull$$$0(8);
        }
        if (buffer == null) {
            MongoJSStringUtil.$$$reportNull$$$0(9);
        }
        for (int idx = 0; idx < str.length(); ++idx) {
            MongoJSStringUtil.escapeSingleChar(str, quote, true, escapeNewlines, escapeWhitespace, escapeTemplateStringArg, buffer, idx);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mongo/js/MongoJSStringUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mongo/js/MongoJSStringUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSimpleStringChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escapeTemplateStringChars";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "escapeSingleChar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateArgumentEnd";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSimpleStringChars";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "escapeSimpleStringChars";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

