/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.snowflake.SFlakeDialect;
import com.intellij.sql.dialects.snowflake._SFlakeLexer;
import com.intellij.sql.psi.SqlTokens;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SFlakeLexer
extends SqlLexer {
    private static final Pattern URL_PATTERN = Pattern.compile("(?:\\w+://|@)(?:/?~)?[a-z0-9_*?.=\\[\\]\"\\\\!@%^+:/-]*", 2);

    public SFlakeLexer() {
        super(SFlakeDialect.INSTANCE, (FlexLexer)new _SFlakeLexer());
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            SFlakeLexer.$$$reportNull$$$0(0);
        }
        if (!this.lookAheadCustomQuotation(baseLexer) && !this.lookAheadURL(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadURL(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        if (type != SqlTokens.SQL_IDENT && type != SqlTokens.SQL_AT_SIGN) {
            return false;
        }
        Matcher matcher = URL_PATTERN.matcher(lexer.getBufferSequence());
        matcher.region(lexer.getTokenStart(), lexer.getBufferEnd());
        if (!matcher.lookingAt()) {
            return false;
        }
        this.addToken(matcher.end(), (IElementType)SqlTokens.SQL_RAW_INPUT);
        lexer.start(lexer.getBufferSequence(), matcher.end(), lexer.getBufferEnd(), 0);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/sql/dialects/snowflake/SFlakeLexer", "lookAhead"));
    }
}

