/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.Dbms;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.formatter.Change;
import com.intellij.sql.formatter.SqlCasePreFormatter;
import com.intellij.sql.formatter.SqlPreFormatHelper;
import com.intellij.sql.formatter.SqlQueryPreFormatter;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018J,\u0010\u001f\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/sql/formatter/SqlPreFormatter;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "element", "Lcom/intellij/psi/PsiElement;", "dbms", "Lcom/intellij/database/Dbms;", "settings", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "allowResolving", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/psi/PsiElement;Lcom/intellij/database/Dbms;Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;Z)V", "documentManager", "Lcom/intellij/psi/PsiDocumentManager;", "changes", "Ljava/util/ArrayList;", "Lcom/intellij/sql/formatter/Change;", "Lkotlin/collections/ArrayList;", "readOnlyFragments", "", "Lcom/intellij/openapi/util/TextRange;", "queryPreFormatter", "Lcom/intellij/sql/formatter/SqlQueryPreFormatter;", "casePreFormatter", "Lcom/intellij/sql/formatter/SqlCasePreFormatter;", "process", "range", "processRecursively", "", "pa", "grandpa", "fixRange", "calculateDelta", "", "intellij.database.sql.core.impl"})
public final class SqlPreFormatter {
    @NotNull
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final PsiElement element;
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final PsiDocumentManager documentManager;
    @NotNull
    private final ArrayList<Change> changes;
    @Nullable
    private final List<TextRange> readOnlyFragments;
    @NotNull
    private final SqlQueryPreFormatter queryPreFormatter;
    @NotNull
    private final SqlCasePreFormatter casePreFormatter;

    public SqlPreFormatter(@NotNull Project project, @NotNull Document document, @NotNull PsiElement element, @NotNull Dbms dbms, @NotNull SqlCodeStyleSettings settings, boolean allowResolving) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.project = project;
        this.document = document;
        this.element = element;
        this.dbms = dbms;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiDocumentManager, (String)"getInstance(...)");
        this.documentManager = psiDocumentManager;
        this.changes = new ArrayList();
        this.readOnlyFragments = this.document instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)this.project).getNonEditableFragments((DocumentWindow)this.document) : null;
        this.queryPreFormatter = new SqlQueryPreFormatter(settings, (Collection<Change>)this.changes);
        this.casePreFormatter = new SqlCasePreFormatter(this.dbms, settings, this.document, allowResolving, this.readOnlyFragments, (Collection<Change>)this.changes);
    }

    @NotNull
    public final TextRange process(@NotNull TextRange range) {
        PsiElement pa;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (PostprocessReformattingAspect.getInstance((Project)this.project).isDisabled()) {
            return range;
        }
        PsiElement psiElement = pa = this.element.getParent();
        this.processRecursively(this.element, pa, (PsiElement)(psiElement != null ? psiElement.getParent() : null), range);
        if (this.changes.size() >= 2) {
            CollectionsKt.sort((List)this.changes);
        }
        TextRange fixedRange = this.fixRange(range);
        SqlPreFormatHelper.performModificationInBulk(this.documentManager, this.document, (Collection<Change>)this.changes);
        int delta = this.calculateDelta();
        TextRange textRange = fixedRange.grown(delta);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
        return textRange;
    }

    private final void processRecursively(PsiElement element, PsiElement pa, PsiElement grandpa, TextRange range) {
        TextRange elementTextRange = element.getTextRange();
        if (elementTextRange.isEmpty() || !elementTextRange.intersectsStrict(range)) {
            return;
        }
        if (element instanceof IsExternal && this.dbms.isPostgres()) {
            return;
        }
        IElementType elementType = PsiTreeUtilKt.getElementType((PsiElement)element);
        boolean isIdentifier = elementType == SqlCompositeElementTypes.SQL_IDENTIFIER;
        PsiElement child = element.getFirstChild();
        if (child == null || isIdentifier) {
            this.casePreFormatter.processElement(element, pa, grandpa);
        } else if (elementType == SqlCompositeElementTypes.SQL_SELECT_CLAUSE) {
            this.queryPreFormatter.processQuery(element);
        }
        while (child != null && !isIdentifier) {
            this.processRecursively(child, element, pa, range);
            child = child.getNextSibling();
        }
    }

    private final TextRange fixRange(TextRange range) {
        int start2 = range.getStartOffset();
        int end = range.getEndOffset();
        int n = this.changes.size();
        if (n > 0) {
            start2 = Math.min(start2, this.changes.get((int)0).from);
            end = Math.max(end, this.changes.get((int)(n - 1)).till);
        }
        return new TextRange(start2, end);
    }

    private final int calculateDelta() {
        int delta = 0;
        Iterator<Change> iterator = this.changes.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Change> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Change change;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            delta += change.delta();
        }
        return delta;
    }
}

