/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.implementations;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.reactivestreams.implementations.info.DefaultBlockingContextProvider;
import com.intellij.reactivestreams.implementations.info.SchedulingMethodCallInfo;
import com.intellij.reactivestreams.implementations.info.SchedulingType;
import com.intellij.reactivestreams.implementations.info.ThrowReplacementInfo;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.analysis.Dependency;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\bf\u0018\u00002\u00020\u0001:\u0001)J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H&J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0019H&J#\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010$\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006*\u00c0\u0006\u0001"}, d2={"Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation;", "", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailableFor", "file", "Lcom/intellij/psi/PsiFile;", "implementationPackage", "", "getImplementationPackage", "()Ljava/lang/String;", "shouldCheckUsageOfReturnValue", "method", "Lcom/intellij/psi/PsiMethod;", "isCollapsableMethodDefinedInPublisher", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "createThrowReplacementInfo", "Lcom/intellij/reactivestreams/implementations/info/ThrowReplacementInfo;", "methodCall", "functionalObject", "Lorg/jetbrains/uast/UElement;", "getBlockingNonBlockingAnalysisManager", "Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation$NonBlockingAnalysisManager;", "canMethodLambdaReturnNull", "functionalParameter", "Lcom/intellij/psi/PsiParameter;", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiParameter;)Ljava/lang/Boolean;", "provideQuickFixForLambdaReturningNull", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "publisherImplementationsTypes", "", "getPublisherImplementationsTypes", "()Ljava/lang/Iterable;", "publisherInterfacesTypes", "getPublisherInterfacesTypes", "builderClassesToCheck", "getBuilderClassesToCheck", "NonBlockingAnalysisManager", "intellij.reactivestreams"})
public interface ReactiveStreamsImplementation {
    public boolean isAvailable(@NotNull Project var1);

    public boolean isAvailableFor(@NotNull PsiFile var1);

    @NotNull
    public String getImplementationPackage();

    default public boolean shouldCheckUsageOfReturnValue(@NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return ReactiveStreamsUtils.isPublisher(method.getReturnType());
    }

    public boolean isCollapsableMethodDefinedInPublisher(@NotNull UCallExpression var1);

    @Nullable
    public ThrowReplacementInfo createThrowReplacementInfo(@NotNull UCallExpression var1, @NotNull UElement var2);

    @NotNull
    public NonBlockingAnalysisManager getBlockingNonBlockingAnalysisManager();

    @Nullable
    public Boolean canMethodLambdaReturnNull(@NotNull PsiMethod var1, @Nullable PsiParameter var2);

    public static /* synthetic */ Boolean canMethodLambdaReturnNull$default(ReactiveStreamsImplementation reactiveStreamsImplementation, PsiMethod psiMethod, PsiParameter psiParameter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canMethodLambdaReturnNull");
        }
        if ((n & 2) != 0) {
            psiParameter = null;
        }
        return reactiveStreamsImplementation.canMethodLambdaReturnNull(psiMethod, psiParameter);
    }

    @NotNull
    public List<LocalQuickFix> provideQuickFixForLambdaReturningNull(@NotNull PsiMethod var1, @Nullable PsiParameter var2);

    @NotNull
    public Iterable<String> getPublisherImplementationsTypes();

    @NotNull
    public Iterable<String> getPublisherInterfacesTypes();

    @NotNull
    default public Iterable<String> getBuilderClassesToCheck() {
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH&J\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/reactivestreams/implementations/ReactiveStreamsImplementation$NonBlockingAnalysisManager;", "", "getAnalysableArgument", "Lorg/jetbrains/uast/UElement;", "argumentDependency", "Lorg/jetbrains/uast/analysis/Dependency$ArgumentDependency;", "getSchedulingMethodInfo", "Lcom/intellij/reactivestreams/implementations/info/SchedulingMethodCallInfo;", "expression", "Lorg/jetbrains/uast/UCallExpression;", "schedulingType", "Lcom/intellij/reactivestreams/implementations/info/SchedulingType;", "getDefaultBlockingContextProvider", "Lcom/intellij/reactivestreams/implementations/info/DefaultBlockingContextProvider;", "operatorToAddBefore", "succeedingOperatorIfSchedulingOnNextAffectsContextFor", "", "currentOperator", "(Lorg/jetbrains/uast/UCallExpression;)Ljava/lang/Boolean;", "intellij.reactivestreams"})
    public static interface NonBlockingAnalysisManager {
        @Nullable
        public UElement getAnalysableArgument(@NotNull Dependency.ArgumentDependency var1);

        @Nullable
        public SchedulingMethodCallInfo getSchedulingMethodInfo(@NotNull UCallExpression var1, @NotNull SchedulingType var2);

        @Nullable
        public DefaultBlockingContextProvider getDefaultBlockingContextProvider(@NotNull UCallExpression var1);

        @Nullable
        default public Boolean succeedingOperatorIfSchedulingOnNextAffectsContextFor(@NotNull UCallExpression currentOperator) {
            Intrinsics.checkNotNullParameter((Object)currentOperator, (String)"currentOperator");
            return null;
        }
    }
}

