/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.inspections.ReactiveStreamsUastInspectionBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastUtils;

public abstract class ReactiveStreamsInterfaceImplementationInspectionBase
extends ReactiveStreamsUastInspectionBase {
    protected ReactiveStreamsInterfaceImplementationInspectionBase() {
        super(UClass.class);
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ReactiveStreamsInspectionsManager inspectionsManager;
        if (aClass == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(1);
        }
        if ((inspectionsManager = ReactiveStreamsInspectionsManager.getInstance(manager.getProject())).isImplementationClass(aClass.getQualifiedName()) || ReactiveStreamsInterfaceImplementationInspectionBase.isAnonymousClassInsideImplementation(inspectionsManager, aClass)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!this.isClassImplementingTargetInterface(aClass)) {
            return null;
        }
        return new ProblemDescriptor[]{manager.createProblemDescriptor(ReactiveStreamsInterfaceImplementationInspectionBase.getProblemElement(aClass), this.getProblemDescription(), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
    }

    private static boolean isAnonymousClassInsideImplementation(@NotNull ReactiveStreamsInspectionsManager inspectionsManager, @NotNull UClass aClass) {
        if (inspectionsManager == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(2);
        }
        if (aClass == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(3);
        }
        if (aClass.getQualifiedName() != null) {
            return false;
        }
        return ReactiveStreamsInterfaceImplementationInspectionBase.isInsideImplementation(inspectionsManager, (UElement)aClass);
    }

    protected static boolean isInsideImplementation(@NotNull ReactiveStreamsInspectionsManager inspectionsManager, @NotNull UElement aClass) {
        UClass parentClass;
        if (inspectionsManager == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(4);
        }
        if (aClass == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(5);
        }
        return (parentClass = (UClass)UastUtils.getParentOfType((UElement)aClass, UClass.class, (boolean)true)) != null && inspectionsManager.isImplementationClass(parentClass.getQualifiedName());
    }

    private boolean isClassImplementingTargetInterface(@NotNull UClass aClass) {
        if (aClass == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(6);
        }
        if (aClass.getSourcePsi() instanceof PsiTypeParameter) {
            return false;
        }
        return ContainerUtil.exists((Iterable)aClass.getUastSuperTypes(), e -> this.getInterfaceQualifiedName().equals(e.getQualifiedName()));
    }

    @NotNull
    private static PsiElement getProblemElement(UClass aClass) {
        UElement anchor = aClass.getUastAnchor();
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)anchor);
        PsiElement psiElement = Objects.requireNonNullElseGet(identifier, () -> ((UClass)aClass).getPsi());
        if (psiElement == null) {
            ReactiveStreamsInterfaceImplementationInspectionBase.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @NotNull
    protected abstract String getInterfaceQualifiedName();

    @NotNull
    @InspectionMessage
    protected abstract String getProblemDescription();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/reactivestreams/inspections/ReactiveStreamsInterfaceImplementationInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/reactivestreams/inspections/ReactiveStreamsInterfaceImplementationInspectionBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousClassInsideImplementation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInsideImplementation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClassImplementingTargetInterface";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

