/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B-\b\u0005\u0012\"\u0010\u0002\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\"\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsUastInspectionBase;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "uElementHints", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "<init>", "([Ljava/lang/Class;)V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "doBuildVisitor", "onTheFly", "intellij.reactivestreams"})
public abstract class ReactiveStreamsUastInspectionBase
extends AbstractBaseUastLocalInspectionTool {
    @SafeVarargs
    protected ReactiveStreamsUastInspectionBase(Class<? extends UElement> ... uElementHints) {
        Intrinsics.checkNotNullParameter(uElementHints, (String)"uElementHints");
        super((Class[])Arrays.copyOf(uElementHints, uElementHints.length));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (ReactiveStreamsUtils.hasReactiveStreamsFor(psiFile)) {
            Project project = holder.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ReactiveStreamsInspectionsManager reactiveStreamsInspectionsManager = ReactiveStreamsInspectionsManager.Companion.getInstance(project);
            PsiFile psiFile2 = holder.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
            if (reactiveStreamsInspectionsManager.anyImplementationAvailableFor(psiFile2)) {
                psiElementVisitor = this.doBuildVisitor(holder, isOnTheFly);
                return psiElementVisitor;
            }
        }
        PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
        Intrinsics.checkNotNull((Object)psiElementVisitor2);
        psiElementVisitor = psiElementVisitor2;
        return psiElementVisitor;
    }

    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, onTheFly);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }
}

