/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.debugger;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.MethodEntryRequest;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DebugInitializationRequestor
implements FilteredRequestor {
    private static final String REACTOR_DEBUG_AGENT = "reactor.tools.agent.ReactorDebugAgent";
    private static final String AGENT_INIT_METHOD = "init";
    private static final String AGENT_PROCESS_EXISTING_CLASSES_METHOD = "processExistingClasses";
    private static final String HOOKS = "reactor.core.publisher.Hooks";
    private static final String HOOKS_ON_OPERATOR_DEBUG_METHOD = "onOperatorDebug";
    private static final String CLASS_LOADER_CLASS = "java.lang.ClassLoader";
    private static final String GET_SYSTEM_CLASS_LOADER_METHOD = "getSystemClassLoader";
    private static final ClassFilter[] CLASS_EXCLUSION_FILTERS = new ClassFilter[]{new ClassFilter("java.*"), new ClassFilter("jdk.*"), new ClassFilter("sun.*"), new ClassFilter("reactor.tools.*")};
    private final DebugProcessImpl myProcess;
    private final boolean myUseAgent;

    DebugInitializationRequestor(@NotNull DebugProcessImpl process, boolean useAgent) {
        if (process == null) {
            DebugInitializationRequestor.$$$reportNull$$$0(0);
        }
        this.myProcess = process;
        this.myUseAgent = useAgent;
    }

    static void enableRequest(DebugProcessImpl process, boolean useAgent) {
        DebugInitializationRequestor requestor = new DebugInitializationRequestor(process, useAgent);
        MethodEntryRequest request = process.getRequestsManager().createMethodEntryRequest((FilteredRequestor)requestor);
        request.setSuspendPolicy(2);
        request.setEnabled(true);
    }

    public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, LocatableEvent event) {
        if (action == null) {
            DebugInitializationRequestor.$$$reportNull$$$0(1);
        }
        this.myProcess.getRequestsManager().deleteRequest((Requestor)this);
        SuspendContextImpl suspendContext = action.getSuspendContext();
        if (suspendContext == null) {
            return false;
        }
        EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
        try {
            ClassLoaderReference classLoader = this.getSystemClassLoader(evaluationContext);
            return this.myUseAgent ? this.callAgent(evaluationContext, classLoader) : this.callHooks(evaluationContext, classLoader);
        }
        catch (EvaluateException e) {
            return true;
        }
    }

    private ClassLoaderReference getSystemClassLoader(EvaluationContextImpl evaluationContext) throws EvaluateException {
        ClassType classLoaderType = (ClassType)this.myProcess.findClass((EvaluationContext)evaluationContext, CLASS_LOADER_CLASS, null);
        Method getClassLoaderMethod = DebuggerUtils.findMethod((ReferenceType)classLoaderType, (String)GET_SYSTEM_CLASS_LOADER_METHOD, null);
        Value classLoaderValue = this.myProcess.invokeMethod((EvaluationContext)evaluationContext, classLoaderType, getClassLoaderMethod, Collections.emptyList());
        return (ClassLoaderReference)classLoaderValue;
    }

    private boolean callAgent(EvaluationContextImpl evaluationContext, ClassLoaderReference classLoader) throws EvaluateException {
        return this.callStaticMethods(evaluationContext, classLoader, REACTOR_DEBUG_AGENT, AGENT_INIT_METHOD, AGENT_PROCESS_EXISTING_CLASSES_METHOD);
    }

    private boolean callHooks(EvaluationContextImpl evaluationContext, ClassLoaderReference classLoader) throws EvaluateException {
        return this.callStaticMethods(evaluationContext, classLoader, HOOKS, HOOKS_ON_OPERATOR_DEBUG_METHOD);
    }

    private boolean callStaticMethods(EvaluationContextImpl evaluationContext, @Nullable ClassLoaderReference classLoaderReference, String className, String ... methodsNames) throws EvaluateException {
        ClassType classInstance;
        ReferenceType type = this.myProcess.findClass((EvaluationContext)evaluationContext, className, classLoaderReference);
        ClassType classType = classInstance = type instanceof ClassType ? (ClassType)type : null;
        if (classInstance == null) {
            return false;
        }
        for (String methodName : methodsNames) {
            Method method = DebuggerUtils.findMethod((ReferenceType)classInstance, (String)methodName, null);
            this.myProcess.invokeMethod((EvaluationContext)evaluationContext, classInstance, method, Collections.emptyList());
        }
        return true;
    }

    public String getSuspendPolicy() {
        return "SuspendNone";
    }

    public boolean isClassFiltersEnabled() {
        return true;
    }

    public ClassFilter[] getClassExclusionFilters() {
        return CLASS_EXCLUSION_FILTERS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/reactivestreams/reactor/debugger/DebugInitializationRequestor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processLocatableEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

