/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.debugger.streams;

import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.debugger.streams.ReactorExpressionRendererKt;
import com.intellij.reactivestreams.settings.ReactiveStreamsSettings;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.sun.jdi.Type;
import icons.ReactorIcons;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/reactivestreams/reactor/debugger/streams/CalculationLabelRenderer;", "Lcom/intellij/debugger/ui/tree/render/LabelRenderer;", "<init>", "()V", "isOnDemand", "", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "valueDescriptor", "Lcom/intellij/debugger/ui/tree/ValueDescriptor;", "getFullValueEvaluator", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "ReactorStreamEvaluator", "intellij.reactivestreams.reactor"})
public final class CalculationLabelRenderer
extends LabelRenderer {
    public boolean isOnDemand(@Nullable EvaluationContext evaluationContext, @Nullable ValueDescriptor valueDescriptor) {
        return true;
    }

    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(@NotNull EvaluationContextImpl evaluationContext, @NotNull ValueDescriptorImpl valueDescriptor) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        Intrinsics.checkNotNullParameter((Object)valueDescriptor, (String)"valueDescriptor");
        Type type = valueDescriptor.getType();
        if (type == null) {
            return null;
        }
        Type type2 = type;
        if (ReactorExpressionRendererKt.isFluxSubclass(type2)) {
            String string = ReactorCoreBundle.message("debug.message.expression.flux.result.get", new Object[0]);
            Object[] objectArray = new Object[1];
            Project project = valueDescriptor.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            objectArray[0] = ReactiveStreamsSettings.Companion.getInstance(project).getStreamChunkSize();
            pair = TuplesKt.to((Object)string, (Object)ReactorCoreBundle.message("debug.message.flux.tooltip", objectArray));
        } else if (ReactorExpressionRendererKt.isMonoSubclass(type2)) {
            pair = TuplesKt.to((Object)ReactorCoreBundle.message("debug.message.expression.mono.result.get", new Object[0]), (Object)ReactorCoreBundle.message("debug.message.mono.tooltip", new Object[0]));
        } else {
            return null;
        }
        Pair pair2 = pair;
        String linkText = (String)pair2.component1();
        String toolTipText = (String)pair2.component2();
        Intrinsics.checkNotNull((Object)linkText);
        Intrinsics.checkNotNull((Object)toolTipText);
        return new ReactorStreamEvaluator(linkText, toolTipText);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/reactivestreams/reactor/debugger/streams/CalculationLabelRenderer$ReactorStreamEvaluator;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "linkText", "", "tooltip", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "startEvaluation", "", "callback", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator$XFullValueEvaluationCallback;", "intellij.reactivestreams.reactor"})
    @SourceDebugExtension(value={"SMAP\nReactorExpressionRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactorExpressionRenderer.kt\ncom/intellij/reactivestreams/reactor/debugger/streams/CalculationLabelRenderer$ReactorStreamEvaluator\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,177:1\n19#2:178\n*S KotlinDebug\n*F\n+ 1 ReactorExpressionRenderer.kt\ncom/intellij/reactivestreams/reactor/debugger/streams/CalculationLabelRenderer$ReactorStreamEvaluator\n*L\n107#1:178\n*E\n"})
    private static final class ReactorStreamEvaluator
    extends XFullValueEvaluator {
        public ReactorStreamEvaluator(@Nls @NotNull String linkText, @Nls @NotNull String tooltip) {
            Intrinsics.checkNotNullParameter((Object)linkText, (String)"linkText");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            super(linkText, new XFullValueEvaluator.LinkAttributes(tooltip, ReactorStreamEvaluator::_init_$lambda$0, ReactorIcons.ProjectReactor));
            this.setShowValuePopup(false);
        }

        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            HeadlessValueEvaluationCallback headlessValueEvaluationCallback;
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            XFullValueEvaluator.XFullValueEvaluationCallback $this$asSafely$iv = callback;
            boolean $i$f$asSafely = false;
            XFullValueEvaluator.XFullValueEvaluationCallback xFullValueEvaluationCallback = $this$asSafely$iv;
            if (!(xFullValueEvaluationCallback instanceof HeadlessValueEvaluationCallback)) {
                xFullValueEvaluationCallback = null;
            }
            if ((headlessValueEvaluationCallback = (HeadlessValueEvaluationCallback)xFullValueEvaluationCallback) == null || (headlessValueEvaluationCallback = headlessValueEvaluationCallback.getNode()) == null) {
                return;
            }
            HeadlessValueEvaluationCallback node = headlessValueEvaluationCallback;
            XDebuggerTree tree = node.getTree();
            if (!tree.isExpanded(node.getPath())) {
                XValuePresentation xValuePresentation = node.getValuePresentation();
                if (xValuePresentation == null) {
                    return;
                }
                XValuePresentation presentation = xValuePresentation;
                node.setPresentation(node.getIcon(), presentation, true);
                tree.expandPath(node.getPath());
                this.setIsEnabled(false);
                callback.evaluated("");
            }
        }

        private static final String _init_$lambda$0() {
            return KeymapUtil.getKeyText((int)32);
        }
    }
}

