/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.debugger.streams;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.debugger.streams.FluxChildEvaluator;
import com.intellij.reactivestreams.reactor.debugger.streams.MonoChildEvaluator;
import com.intellij.reactivestreams.reactor.debugger.streams.ReactorChildEvaluator;
import com.intellij.reactivestreams.reactor.debugger.streams.ReactorExpressionRendererKt;
import com.intellij.reactivestreams.util.ReactiveStreamsUsageCollector;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J&\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u0012\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010\u001c\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001e\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/reactivestreams/reactor/debugger/streams/ReactorGetterRenderer;", "Lcom/intellij/debugger/ui/tree/render/ReferenceRenderer;", "Lcom/intellij/debugger/ui/tree/render/NodeRenderer;", "<init>", "()V", "isEnabled", "", "setEnabled", "", "enabled", "getUniqueId", "", "isExpandableAsync", "Ljava/util/concurrent/CompletableFuture;", "value", "Lcom/sun/jdi/Value;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "parentDescriptor", "Lcom/intellij/debugger/ui/tree/NodeDescriptor;", "calcLabel", "descriptor", "Lcom/intellij/debugger/ui/tree/ValueDescriptor;", "listener", "Lcom/intellij/debugger/ui/tree/render/DescriptorLabelListener;", "getName", "setName", "text", "buildChildren", "builder", "Lcom/intellij/debugger/ui/tree/render/ChildrenBuilder;", "getChildValueExpression", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/debugger/ui/tree/DebuggerTreeNode;", "context", "Lcom/intellij/debugger/DebuggerContext;", "intellij.reactivestreams.reactor"})
public final class ReactorGetterRenderer
extends ReferenceRenderer
implements NodeRenderer {
    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.myProperties.setEnabled(enabled);
    }

    @NotNull
    public String getUniqueId() {
        return "ReactorGetterRenderer";
    }

    @NotNull
    public CompletableFuture<Boolean> isExpandableAsync(@Nullable Value value, @Nullable EvaluationContext evaluationContext, @Nullable NodeDescriptor parentDescriptor) {
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @NotNull
    public String calcLabel(@Nullable ValueDescriptor descriptor, @Nullable EvaluationContext evaluationContext, @Nullable DescriptorLabelListener listener) {
        return "labelData";
    }

    @NotNull
    public String getName() {
        String string = ReactorCoreBundle.message("debug.expression.getter.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void setName(@Nullable String text) {
    }

    public void buildChildren(@Nullable Value value, @Nullable ChildrenBuilder builder, @Nullable EvaluationContext evaluationContext) {
        block7: {
            ReactorChildEvaluator evaluator;
            ReactorChildEvaluator reactorChildEvaluator;
            if (builder == null) {
                return;
            }
            if (!(value instanceof ObjectReference)) {
                builder.setChildren(CollectionsKt.emptyList());
                return;
            }
            ValueDescriptor valueDescriptor = builder.getParentDescriptor();
            ValueDescriptorImpl valueDescriptorImpl = valueDescriptor instanceof ValueDescriptorImpl ? (ValueDescriptorImpl)valueDescriptor : null;
            if (valueDescriptorImpl == null) {
                return;
            }
            ValueDescriptorImpl descriptor = valueDescriptorImpl;
            Project project = descriptor.getProject();
            Type valueType = ((ObjectReference)value).type();
            Intrinsics.checkNotNull((Object)valueType);
            if (ReactorExpressionRendererKt.isFluxSubclass(valueType)) {
                Intrinsics.checkNotNull((Object)project);
                reactorChildEvaluator = new FluxChildEvaluator(project);
            } else if (ReactorExpressionRendererKt.isMonoSubclass(valueType)) {
                Intrinsics.checkNotNull((Object)project);
                reactorChildEvaluator = new MonoChildEvaluator(project);
            } else {
                reactorChildEvaluator = null;
            }
            ReactorChildEvaluator reactorChildEvaluator2 = evaluator = reactorChildEvaluator;
            if (reactorChildEvaluator2 == null) break block7;
            ReactorChildEvaluator childEvaluator = reactorChildEvaluator2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)project);
            ReactiveStreamsUsageCollector.logDebugUsed(project);
            childEvaluator.buildChildren((ObjectReference)value, builder, evaluationContext);
        }
    }

    @Nullable
    public PsiElement getChildValueExpression(@Nullable DebuggerTreeNode node, @Nullable DebuggerContext context) {
        return null;
    }
}

