/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.inspections.quickfix.MapLambdaVisitor;
import com.intellij.reactivestreams.uast.ex.FunctionalObjectsUtil;
import com.intellij.reactivestreams.uast.ex.UCallExpressionContext;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UParameterInfo;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/reactivestreams/reactor/inspections/quickfix/ReactorThrowInMapQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "firstArgument", "Lorg/jetbrains/uast/UExpression;", "methodCall", "Lorg/jetbrains/uast/UCallExpression;", "intellij.reactivestreams.reactor"})
@SourceDebugExtension(value={"SMAP\nReactorThrowInMapQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactorThrowInMapQuickFix.kt\ncom/intellij/reactivestreams/reactor/inspections/quickfix/ReactorThrowInMapQuickFix\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n207#2:112\n808#3,11:113\n229#4,6:124\n236#4:131\n229#4,6:132\n236#4:139\n14#5:130\n14#5:138\n*S KotlinDebug\n*F\n+ 1 ReactorThrowInMapQuickFix.kt\ncom/intellij/reactivestreams/reactor/inspections/quickfix/ReactorThrowInMapQuickFix\n*L\n26#1:112\n55#1:113,11\n61#1:124,6\n61#1:131\n62#1:132,6\n62#1:139\n61#1:130\n62#1:138\n*E\n"})
public final class ReactorThrowInMapQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = ReactorCoreBundle.message("intention.replace.map.with.trow.to.handle.quickfix.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        UElement $this$replace$iv;
        UElement $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PsiElement $this$getUastParentOfType_u24default$iv = element;
        boolean strict$iv22 = false;
        boolean $i$f$getUastParentOfType = false;
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UQualifiedReferenceExpression.class, (boolean)strict$iv22);
        if (uQualifiedReferenceExpression == null) {
            return;
        }
        UQualifiedReferenceExpression receiverSelectorUCall = uQualifiedReferenceExpression;
        UExpression strict$iv22 = receiverSelectorUCall.getSelector();
        UCallExpression uCallExpression = strict$iv22 instanceof UCallExpression ? (UCallExpression)strict$iv22 : null;
        if (uCallExpression == null) {
            return;
        }
        UCallExpression methodCall = uCallExpression;
        if (!Intrinsics.areEqual((Object)methodCall.getMethodName(), (Object)"map")) {
            return;
        }
        UExpression uExpression = this.firstArgument(methodCall);
        if (uExpression == null) {
            return;
        }
        UExpression callBody = uExpression;
        UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPluginKt.getGenerationPlugin((UElement)((UElement)receiverSelectorUCall));
        if (uastCodeGenerationPlugin == null) {
            return;
        }
        UastCodeGenerationPlugin generationPlugin = uastCodeGenerationPlugin;
        UastElementFactory factory = generationPlugin.getElementFactory(project);
        UFunctionalObject uFunctionalObject = UFunctionalObject.Companion.from((UElement)callBody, arg_0 -> ReactorThrowInMapQuickFix.applyFix$lambda$0(methodCall, arg_0));
        if (uFunctionalObject == null) {
            return;
        }
        UFunctionalObject mapLambda = uFunctionalObject;
        UExpression uExpression2 = mapLambda.getBody();
        if (uExpression2 == null) {
            return;
        }
        UExpression mapBody = uExpression2;
        UParameter uParameter = (UParameter)CollectionsKt.firstOrNull(mapLambda.getValueParameters());
        if (uParameter == null) {
            return;
        }
        UParameter mapParam = uParameter;
        Object[] objectArray = new UParameterInfo[]{UastCodeGenerationPluginKt.ofType((String)mapParam.getName(), (PsiType)mapParam.getType()), UastCodeGenerationPluginKt.ofType((String)"sink", null)};
        UIdentifier uIdentifier = methodCall.getMethodIdentifier();
        ULambdaExpression uLambdaExpression = factory.createLambdaExpression(CollectionsKt.listOf((Object[])objectArray), mapBody, (PsiElement)(uIdentifier != null ? uIdentifier.getSourcePsi() : null));
        UExpression uExpression3 = uLambdaExpression instanceof UExpression ? (UExpression)uLambdaExpression : null;
        if (uExpression3 == null) {
            return;
        }
        UExpression lambdaWithHandleArgsAndMapBody = uExpression3;
        UExpression uExpression4 = methodCall.getReceiver();
        UCallExpression uCallExpression2 = factory.createCallExpression(methodCall.getReceiver(), "handle", CollectionsKt.listOf((Object)lambdaWithHandleArgsAndMapBody), methodCall.getReturnType(), UastCallKind.METHOD_CALL, (PsiElement)(uExpression4 != null ? uExpression4.getSourcePsi() : null));
        if (uCallExpression2 == null) {
            return;
        }
        UCallExpression handleCall = uCallExpression2;
        Iterable $this$filterIsInstance$iv = handleCall.getValueArguments();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ULambdaExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ULambdaExpression uLambdaExpression2 = (ULambdaExpression)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (uLambdaExpression2 == null) {
            return;
        }
        ULambdaExpression handleLambda = uLambdaExpression2;
        PsiElement psiElement = handleLambda.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement handleContext = psiElement;
        mapLambda.accept((UastVisitor)new MapLambdaVisitor(factory, generationPlugin, mapLambda, handleContext));
        PsiElement psiElement2 = mapLambda.getSourcePsi();
        if (psiElement2 == null) {
            return;
        }
        PsiElement mapLambdaPsi = psiElement2;
        UExpression refreshedObject = UFunctionalObject.Companion.from(mapLambdaPsi, arg_0 -> ReactorThrowInMapQuickFix.applyFix$lambda$1(mapLambda, arg_0));
        $this$filterIsInstanceTo$iv$iv = (UElement)handleLambda.getBody();
        UExpression uExpression5 = refreshedObject;
        if (uExpression5 == null || (uExpression5 = uExpression5.getBody()) == null) {
            return;
        }
        UElement newElement$iv = (UElement)uExpression5;
        boolean $i$f$replace = false;
        if (!Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
            UastCodeGenerationPlugin uastCodeGenerationPlugin2 = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
            UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin2 = uastCodeGenerationPlugin2 != null ? uastCodeGenerationPlugin2.replace($this$replace$iv, newElement$iv, UExpression.class) : null;
            boolean bl = false;
            if (it$iv == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("failed replacing the " + $this$replace$iv + " with " + newElement$iv);
            }
        }
        $this$replace$iv = (UElement)receiverSelectorUCall;
        boolean $i$f$replace2 = false;
        if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)((UElement)handleCall))) {
            UElement cfr_ignored_0 = (UElement)handleCall;
        } else {
            UastCodeGenerationPlugin uastCodeGenerationPlugin3 = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
            UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin3 = uastCodeGenerationPlugin3 != null ? uastCodeGenerationPlugin3.replace($this$replace$iv, (UElement)handleCall, UCallExpression.class) : null;
            boolean bl = false;
            if (it$iv == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("failed replacing the " + $this$replace$iv + " with " + (UElement)handleCall);
            }
        }
    }

    private final UExpression firstArgument(UCallExpression methodCall) {
        return (UExpression)CollectionsKt.firstOrNull((List)methodCall.getValueArguments());
    }

    private static final UCallExpressionContext applyFix$lambda$0(UCallExpression $methodCall, UElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FunctionalObjectsUtil.asContext($methodCall);
    }

    private static final UCallExpressionContext applyFix$lambda$1(UFunctionalObject $mapLambda, UElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $mapLambda.getContext();
    }
}

