/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.util;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reactivestreams.reactor.util.ReactorConstants;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\"\u0017\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0005\u00a8\u0006\u0015"}, d2={"isReactorPublisher", "", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/psi/PsiType;)Z", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiClass;)Z", "hasReactorLibrary", "project", "Lcom/intellij/openapi/project/Project;", "hasReactorLibraryFor", "file", "Lcom/intellij/psi/PsiFile;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "hasReactorLibraryAtLeast330", "hasClassInScope", "fqName", "", "hasReactorTestLibraryInScope", "element", "Lcom/intellij/psi/PsiElement;", "intellij.reactivestreams.reactor"})
@JvmName(name="ReactorLibraryUtil")
@SourceDebugExtension(value={"SMAP\nReactorLibraryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactorLibraryUtil.kt\ncom/intellij/reactivestreams/reactor/util/ReactorLibraryUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class ReactorLibraryUtil {
    public static final boolean isReactorPublisher(@Nullable PsiType $this$isReactorPublisher) {
        PsiType type = GenericsUtil.eliminateWildcards((PsiType)$this$isReactorPublisher);
        boolean bl = false;
        PsiClassType psiClassType = type instanceof PsiClassType ? (PsiClassType)type : null;
        return ReactorLibraryUtil.isReactorPublisher((PsiClass)(psiClassType != null ? psiClassType.resolve() : null));
    }

    public static final boolean isReactorPublisher(@Nullable PsiClass $this$isReactorPublisher) {
        PsiClass psiClass = $this$isReactorPublisher;
        String qualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
        return qualifiedName != null && ReactorConstants.ALL_REACTIVE_ROOT_TYPES.contains(qualifiedName);
    }

    public static final boolean hasReactorLibrary(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"reactor.core.publisher.Flux");
    }

    public static final boolean hasReactorLibraryFor(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JavaLibraryUtil.hasLibraryClass((Module)ModuleUtilCore.findModuleForFile((PsiFile)file.getOriginalFile()), (String)"reactor.core.publisher.Flux");
    }

    public static final boolean hasReactorLibrary(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return ReactorLibraryUtil.hasClassInScope(scope, "reactor.core.publisher.Flux");
    }

    public static final boolean hasReactorLibraryAtLeast330(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return ReactorLibraryUtil.hasClassInScope(scope, "reactor.core.CorePublisher");
    }

    public static final boolean hasClassInScope(@NotNull GlobalSearchScope scope, @NotNull String fqName) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Project project = scope.getProject();
        return project == null || DumbService.Companion.getInstance(project).isDumb() ? false : JavaPsiFacade.getInstance((Project)project).findClass(fqName, scope) != null;
    }

    public static final boolean hasReactorTestLibraryInScope(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return DumbService.Companion.getInstance(project).isDumb() ? false : JavaPsiFacade.getInstance((Project)element.getProject()).findClass("reactor.test.StepVerifier", element.getResolveScope()) != null;
    }
}

