/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc;

import com.intellij.microservices.url.parameters.PathVariablePsiElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spring.model.utils.light.SpringImplicitVariable;
import com.intellij.spring.mvc.AsyncCache;
import com.intellij.spring.mvc.CommonFakePsiVariablePomTarget;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.model.jam.SpringMVCModelAttribute;
import com.intellij.spring.mvc.pathVariables.SpringMvcPathVariableDeclarationSearcher;
import com.intellij.spring.mvc.views.SpringMVCViewUastReferenceProvider;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

final class SpringControllerModelVariablesCollector {
    @NonNls
    private static final String MODEL = "org.springframework.ui.Model";
    @NonNls
    private static final String MODEL_MAP = "org.springframework.ui.ModelMap";
    private static final UExpressionPattern<UExpression, ?> IMPLICIT_ATTRIBUTE_PATTERN = (UExpressionPattern)UastPatterns.uExpression().andOr(new ElementPattern[]{UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addObject")).withParameterCount(1).inClass("org.springframework.web.servlet.ModelAndView"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addAttribute")).withParameterCount(1).inClass("org.springframework.ui.Model"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"addAttribute", "addObject"})).withParameterCount(1).inClass("org.springframework.ui.ModelMap"), false)});
    @NonNls
    private static final String REDIRECT_ATTRIBUTES = "org.springframework.web.servlet.mvc.support.RedirectAttributes";
    private static final UExpressionPattern<UExpression, ?> ATTRIBUTE_PATTERN = (UExpressionPattern)((UExpressionPattern.Capture)UastPatterns.injectionHostOrReferenceExpression().withSourcePsiCondition(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).andOr(new ElementPattern[]{UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addObject")).inClass("org.springframework.web.servlet.ModelAndView"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addAttribute")).inClass("org.springframework.ui.Model"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"addAttribute", "addObject"})).inClass("org.springframework.ui.ModelMap"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("addFlashAttribute")).inClass("org.springframework.web.servlet.mvc.support.RedirectAttributes"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("modelAttribute")).inClass("org.springframework.web.reactive.result.view.Rendering.Builder"), false), UastPatterns.uExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("put")).definedInClass("java.util.Map"), false), UastPatterns.uExpression().annotationParams("org.springframework.web.bind.annotation.ModelAttribute", (ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"value", "name"})), UastPatterns.uExpression().constructorParameter(1, "org.springframework.web.servlet.ModelAndView"), UastPatterns.uExpression().constructorParameter(0, "org.springframework.ui.ModelMap"), UastPatterns.uExpression().arrayAccessParameterOf((ElementPattern)PsiJavaPatterns.psiClass().inheritorOf(false, PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"org.springframework.ui.Model", "org.springframework.ui.ModelMap"}))))});
    private static final UExpressionPattern<UExpression, ?> SESSION_ATTRIBUTES_PATTERN = UastPatterns.injectionHostUExpression().annotationParams("org.springframework.web.bind.annotation.SessionAttributes", (ElementPattern)StandardPatterns.string().oneOf(new String[]{"value", "names"}));
    private static final AsyncCache<PsiClass, MultiMap<String, PsiVariable>> ourVariablesCache = new AsyncCache<PsiClass, MultiMap>(psiClass -> UastModificationTracker.getInstance((Project)psiClass.getProject()), psiClass -> SpringControllerModelVariablesCollector.getVariableMap(psiClass));

    SpringControllerModelVariablesCollector() {
    }

    static Promise<MultiMap<String, PsiVariable>> getVariables(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(0);
        }
        return ourVariablesCache.computeOrGet(psiClass);
    }

    @NotNull
    private static MultiMap<String, PsiVariable> getVariableMap(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(1);
        }
        MultiMap result = new MultiMap();
        HashSet<PsiVariable> modelAttributeVariables = new HashSet<PsiVariable>();
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            UMethod uMethod;
            boolean modelAttributeMethod;
            boolean bl = modelAttributeMethod = !SpringControllerUtils.isInheritedController(psiClass) && SpringControllerUtils.isModelAttributeProvider(psiMethod);
            if (!modelAttributeMethod && !SpringControllerUtils.isRequestHandler(psiClass, psiMethod) || (uMethod = (UMethod)UastContextKt.toUElement((PsiElement)psiMethod, UMethod.class)) == null) continue;
            ViewsAndVariablesCollector visitor = new ViewsAndVariablesCollector(psiClass);
            visitor.collectFrom(uMethod);
            if (modelAttributeMethod) {
                modelAttributeVariables.addAll(visitor.getVisitorVariables());
                continue;
            }
            List<PsiVariable> pathVariables = SpringControllerModelVariablesCollector.collectPathVariables(psiClass, uMethod);
            for (String view : visitor.getVisitorViews()) {
                result.putValues((Object)view, visitor.getVisitorVariables());
                result.putValues((Object)view, pathVariables);
            }
        }
        for (String string : ArrayUtil.toStringArray((Collection)result.keySet())) {
            result.putValues((Object)string, modelAttributeVariables);
        }
        if (!SpringControllerUtils.isInheritedController(psiClass)) {
            SpringControllerModelVariablesCollector.processGlobalModelAttributes(psiClass, (MultiMap<String, PsiVariable>)result);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    private static List<PsiVariable> collectPathVariables(@NotNull PsiClass psiClass, UMethod uMethod) {
        if (psiClass == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(3);
        }
        return SpringMvcPathVariableDeclarationSearcher.collectDeclarations(uMethod).map(mvcPathVariableRef -> {
            PathVariablePsiElement variablePsiElement = mvcPathVariableRef.resolve();
            return new CommonFakePsiVariablePomTarget(psiClass.getProject(), (PomRenameableTarget<? extends Object>)variablePsiElement.getVariablePomTarget(), (PsiType)PsiType.getJavaLangString((PsiManager)variablePsiElement.getManager(), (GlobalSearchScope)variablePsiElement.getResolveScope()));
        }).toList();
    }

    private static void processGlobalModelAttributes(@NotNull PsiClass psiClass, MultiMap<String, PsiVariable> result) {
        if (psiClass == null) {
            SpringControllerModelVariablesCollector.$$$reportNull$$$0(4);
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            SpringMVCModelAttribute modelAttribute;
            if (method.isConstructor() || (modelAttribute = (SpringMVCModelAttribute)SpringMVCModelAttribute.METHOD_META.getJamElement((PsiModifierListOwner)method)) == null) continue;
            if (PsiTypes.voidType().equals((Object)method.getReturnType())) {
                UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class);
                if (uMethod == null) continue;
                ViewsAndVariablesCollector visitor = new ViewsAndVariablesCollector(psiClass);
                visitor.collectFrom(uMethod);
                for (Map.Entry entry : result.entrySet()) {
                    ((Collection)entry.getValue()).addAll(visitor.getVisitorVariables());
                }
                continue;
            }
            String name = modelAttribute.getName();
            if (name == null) continue;
            SpringImplicitVariable var = new SpringImplicitVariable(name, modelAttribute.getType(), PomService.convertToPsi((PsiTarget)modelAttribute.getPsiTarget()));
            for (Map.Entry entry : result.entrySet()) {
                ((Collection)entry.getValue()).add(var);
            }
        }
    }

    @Nullable
    private static SpringImplicitVariable createVariable(PsiElement scope, UExpression declaration) {
        UElement assigment;
        String name = UastUtils.evaluateString((UExpression)declaration);
        if (name == null) {
            return null;
        }
        PsiElement sourcePsi = declaration.getSourcePsi();
        if (declaration instanceof UInjectionHost) {
            UInjectionHost uInjectionHost = (UInjectionHost)declaration;
            sourcePsi = uInjectionHost.getPsiLanguageInjectionHost();
        }
        if (sourcePsi == null) {
            return null;
        }
        PsiClassType type = null;
        UElement parent = declaration.getUastParent();
        if (parent instanceof UCallExpression) {
            UCallExpression callExpression = (UCallExpression)parent;
            List arguments = callExpression.getValueArguments();
            int i = arguments.indexOf(declaration);
            if (i != -1 && arguments.size() > i + 1) {
                type = ((UExpression)arguments.get(i + 1)).getExpressionType();
            }
        } else if (parent instanceof UArrayAccessExpression && (assigment = parent.getUastParent()) instanceof UBinaryExpression) {
            type = ((UBinaryExpression)assigment).getRightOperand().getExpressionType();
        }
        if (type == null) {
            UParameter psiParameter = (UParameter)UastUtils.getParentOfType((UElement)declaration, UParameter.class);
            if (psiParameter != null) {
                type = psiParameter.getType();
            } else {
                UMethod psiMethod = (UMethod)UastUtils.getParentOfType((UElement)declaration, UMethod.class);
                PsiType psiType = type = psiMethod == null ? null : psiMethod.getReturnType();
            }
        }
        if (type instanceof PsiPrimitiveType) {
            type = ((PsiPrimitiveType)type).getBoxedType(scope);
        }
        return new SpringImplicitVariable(name, (PsiType)type, sourcePsi);
    }

    static void registerModelVariablesReferenceProvider(PsiReferenceRegistrar registrar) {
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, ATTRIBUTE_PATTERN, (UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((expression, host) -> {
            PsiReference[] psiReferenceArray;
            UClass psiClass = UastUtils.getContainingUClass((UElement)expression);
            if (psiClass == null) {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            } else {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = PsiReferenceBase.createSelfReference((PsiElement)host, (PsiElement)SpringControllerModelVariablesCollector.createVariable((PsiElement)psiClass.getJavaPsi(), expression));
            }
            return psiReferenceArray;
        }), (double)0.0);
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, SESSION_ATTRIBUTES_PATTERN, (UastReferenceProvider)UastReferenceRegistrar.uastReferenceProvider(UInjectionHost.class, (uhost, __) -> {
            final String name = uhost.evaluateToString();
            return new PsiReference[]{new PsiPolyVariantReferenceBase<PsiLanguageInjectionHost>(uhost.getPsiLanguageInjectionHost(), false){

                @NotNull
                public ResolveResult[] multiResolve(boolean incompleteCode) {
                    ResolveResult[] resolveResultArray = (ResolveResult[])this.getVariables().stream().filter(v -> Objects.equals(v.getName(), name)).map(var -> new PsiElementResolveResult((PsiElement)var)).collect(MoreCollectors.toArray(ResolveResult[]::new));
                    if (resolveResultArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return resolveResultArray;
                }

                @NotNull
                public Collection<? extends PsiVariable> getVariables() {
                    UClass uClass = (UClass)UastUtils.findContaining((PsiElement)this.getElement(), UClass.class);
                    if (uClass == null) {
                        List list = Collections.emptyList();
                        if (list == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return list;
                    }
                    Collection collection = ((MultiMap)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)Promises.asCompletableFuture(SpringControllerModelVariablesCollector.getVariables(uClass.getJavaPsi())))).values();
                    if (collection == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return collection;
                }

                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = this.getVariables().toArray();
                    if (objectArray == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return objectArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/spring/mvc/SpringControllerModelVariablesCollector$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "multiResolve";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getVariables";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getVariants";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }};
        }), (double)0.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/SpringControllerModelVariablesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/SpringControllerModelVariablesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariables";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVariableMap";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectPathVariables";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalModelAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class ViewsAndVariablesCollector {
        private final Set<PsiMethod> visited;
        @NotNull
        private final PsiClass myPsiClass;
        private final Set<String> myVisitorViews;
        private final List<PsiVariable> myVisitorVariables;

        private ViewsAndVariablesCollector(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                ViewsAndVariablesCollector.$$$reportNull$$$0(0);
            }
            this.visited = new HashSet<PsiMethod>();
            this.myVisitorViews = new HashSet<String>();
            this.myVisitorVariables = new SmartList();
            this.myPsiClass = psiClass;
        }

        public void collectFrom(@NotNull UMethod handlerMethod) {
            if (handlerMethod == null) {
                ViewsAndVariablesCollector.$$$reportNull$$$0(1);
            }
            ArrayDeque psiElementQueue = new ArrayDeque();
            ContainerUtil.addIfNotNull(psiElementQueue, (Object)handlerMethod.getSourcePsi());
            while (!psiElementQueue.isEmpty()) {
                UMethod uMethod;
                PsiMethod method;
                PsiType type;
                String variableName;
                ProgressManager.checkCanceled();
                PsiElement psiElement = (PsiElement)psiElementQueue.removeLast();
                psiElementQueue.addAll(ContainerUtil.reverse(Arrays.asList(psiElement.getChildren())));
                UExpression element = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)psiElement, (Class[])new Class[]{UReferenceExpression.class, UCallExpression.class, UInjectionHost.class});
                if (element == null || !Objects.equals(element.getSourcePsi(), psiElement)) continue;
                ProcessingContext ctx = new ProcessingContext();
                if (element instanceof UReferenceExpression || UastLiteralUtils.isInjectionHost((UElement)element)) {
                    if (ViewsAndVariablesCollector.isViewPattern(element, ctx)) {
                        String literalName = UastUtils.evaluateString((UExpression)element);
                        ContainerUtil.addIfNotNull(this.myVisitorViews, (Object)literalName);
                    } else if (ATTRIBUTE_PATTERN.accepts((Object)element, ctx)) {
                        SpringImplicitVariable variable = SpringControllerModelVariablesCollector.createVariable((PsiElement)this.myPsiClass.getContainingFile(), element);
                        ContainerUtil.addIfNotNull(this.myVisitorVariables, (Object)variable);
                    }
                }
                if (IMPLICIT_ATTRIBUTE_PATTERN.accepts((Object)element, ctx) && (variableName = SpringControllerUtils.getVariableName(type = element.getExpressionType())) != null) {
                    SpringImplicitVariable variable = new SpringImplicitVariable(variableName, type, element.getSourcePsi());
                    this.myVisitorVariables.add((PsiVariable)variable);
                }
                if (!(element instanceof UCallExpression) || (method = ((UCallExpression)element).resolve()) == null || ViewsAndVariablesCollector.isLibraryCode(method) || !this.visited.add(method) || !InheritanceUtil.isInheritorOrSelf((PsiClass)this.myPsiClass, (PsiClass)method.getContainingClass(), (boolean)true) || (uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class)) == null) continue;
                ContainerUtil.addIfNotNull(psiElementQueue, (Object)uMethod.getSourcePsi());
            }
        }

        private static boolean isViewPattern(UExpression element, ProcessingContext ctx) {
            if (SpringMVCViewUastReferenceProvider.VIEW_PATTERN.accepts((Object)element, ctx)) {
                return true;
            }
            return ((StreamEx)((StreamEx)StreamEx.iterate((Object)element, Objects::nonNull, e -> e.getUastParent()).limit(5L)).takeWhile(e -> !(e instanceof UCallExpression) || SpringMVCViewUastReferenceProvider.isReactiveCall((UCallExpression)e))).select(UReturnExpression.class).findFirst().orElse(null) != null;
        }

        private static boolean isLibraryCode(@NotNull PsiMethod method) {
            if (method == null) {
                ViewsAndVariablesCollector.$$$reportNull$$$0(2);
            }
            if (method instanceof PsiCompiledElement) {
                return true;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method);
            return virtualFile != null && FileIndexFacade.getInstance((Project)method.getProject()).isInLibrarySource(virtualFile);
        }

        private Set<String> getVisitorViews() {
            return this.myVisitorViews;
        }

        private List<PsiVariable> getVisitorVariables() {
            return this.myVisitorVariables;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handlerMethod";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spring/mvc/SpringControllerModelVariablesCollector$ViewsAndVariablesCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectFrom";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLibraryCode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

