/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public final class SpringMvcLibraryUtil {
    public static final String SPRING_WEBMVC_MAVEN = "org.springframework:spring-webmvc";
    public static final String SPRING_WEBFLUX_MAVEN = "org.springframework:spring-webflux";
    public static final PatternCondition<PsiElement> IS_SPRING_MVC_PROJECT = new PatternCondition<PsiElement>("isSpringMVCEnabledProject"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return SpringMvcLibraryUtil.isSpringMVCEnabled(element.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/mvc/SpringMvcLibraryUtil$1", "accepts"));
        }
    };

    public static boolean hasSpringMvcLibrary(@NotNull Project project) {
        if (project == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(0);
        }
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)SPRING_WEBMVC_MAVEN);
    }

    public static boolean hasSpringMvcLibrary(@NotNull Module module) {
        if (module == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(1);
        }
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_WEBMVC_MAVEN);
    }

    public static boolean hasSpringMvcFunctionalRoutingLibrary(@NotNull Project project) {
        if (project == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(2);
        }
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)"org.springframework.web.servlet.function.RequestPredicates");
    }

    public static boolean hasSpringMvcFunctionalRoutingLibrary(@NotNull Module module) {
        if (module == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(3);
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.function.RequestPredicates") != null;
    }

    public static boolean hasWebfluxLibrary(@NotNull Project project) {
        if (project == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(4);
        }
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)SPRING_WEBFLUX_MAVEN);
    }

    public static boolean hasWebfluxLibrary(@NotNull Module module) {
        if (module == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(5);
        }
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_WEBFLUX_MAVEN);
    }

    public static boolean isWebfluxEnabled(@NotNull Project project) {
        if (project == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(6);
        }
        return SpringMvcLibraryUtil.hasWebfluxLibrary(project);
    }

    public static boolean isSpringMvcFunctionalRoutingEnabled(@NotNull Project project) {
        if (project == null) {
            SpringMvcLibraryUtil.$$$reportNull$$$0(7);
        }
        return SpringMvcLibraryUtil.hasWebfluxLibrary(project);
    }

    public static boolean isSpringMVCEnabled(Project project) {
        return SpringMvcLibraryUtil.hasSpringMvcLibrary(project) || SpringMvcLibraryUtil.hasWebfluxLibrary(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/mvc/SpringMvcLibraryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSpringMvcLibrary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSpringMvcFunctionalRoutingLibrary";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWebfluxLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isWebfluxEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringMvcFunctionalRoutingEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

