/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.model.CodeConfigurationParserBase;
import com.intellij.spring.mvc.views.BeanNameViewResolverFactory;
import com.intellij.spring.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.ViewResolverFactory;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CodeConfigurationViewResolverParser
extends CodeConfigurationParserBase {
    private final List<? super ViewResolver> myViewResolvers;

    public CodeConfigurationViewResolverParser(CommonSpringModel servletModel, SpringBeanPointer<?> configBeanPointer, List<? super ViewResolver> resolvers) {
        super(servletModel, configBeanPointer);
        this.myViewResolvers = resolvers;
    }

    @Override
    protected boolean parseConfigurationClass(@NotNull PsiClass configClass) {
        LightMethodBuilder configureViewResolversMethodTemplate;
        UMethod configureViewResolvers;
        if (configClass == null) {
            CodeConfigurationViewResolverParser.$$$reportNull$$$0(0);
        }
        if ((configureViewResolvers = (UMethod)UastContextKt.toUElement((PsiElement)configClass.findMethodBySignature((PsiMethod)(configureViewResolversMethodTemplate = new LightMethodBuilder(configClass.getManager(), "configureViewResolvers").setModifiers(new String[]{"protected"}).setMethodReturnType((PsiType)PsiTypes.voidType()).addParameter("registry", "org.springframework.web.servlet.config.annotation.ViewResolverRegistry")), false), UMethod.class)) == null) {
            return false;
        }
        final List viewResolverFactoryEPs = ViewResolverFactory.EP_NAME.getExtensionList();
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)configClass);
        configureViewResolvers.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitCallExpression(@NotNull UCallExpression expression) {
                UExpression qualifierExpression;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((qualifierExpression = expression.getReceiver()) == null) {
                    return super.visitCallExpression(expression);
                }
                PsiType qualifierType = qualifierExpression.getExpressionType();
                PsiClass qualifierClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
                if (qualifierClass == null || !"org.springframework.web.servlet.config.annotation.ViewResolverRegistry".equals(qualifierClass.getQualifiedName())) {
                    return super.visitCallExpression(expression);
                }
                String methodName = expression.getMethodName();
                if ("jsp".equals(methodName)) {
                    CodeConfigurationViewResolverParser.this.handleJsp(module, expression);
                } else if ("beanName".equals(methodName)) {
                    CodeConfigurationViewResolverParser.this.handleBeanName(module);
                } else {
                    for (ViewResolverFactory viewResolver : viewResolverFactoryEPs) {
                        Set<ViewResolver> viewResolvers = viewResolver.handleResolversRegistry(methodName, expression, CodeConfigurationViewResolverParser.this.myServletModel);
                        if (viewResolvers.isEmpty()) continue;
                        CodeConfigurationViewResolverParser.this.myViewResolvers.addAll(viewResolvers);
                        break;
                    }
                }
                return super.visitCallExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/mvc/model/CodeConfigurationViewResolverParser$1", "visitCallExpression"));
            }
        });
        return true;
    }

    private static StreamEx<UCallExpression> getChainCalls(UCallExpression callExpression) {
        return StreamEx.iterate((Object)callExpression.getUastParent(), it -> it instanceof UQualifiedReferenceExpression, it -> it.getUastParent()).select(UQualifiedReferenceExpression.class).map(it -> it.getSelector()).select(UCallExpression.class);
    }

    private void handleJsp(@Nullable Module module, UCallExpression expression) {
        if (module == null) {
            return;
        }
        List arguments = expression.getValueArguments();
        if (arguments.size() == 0) {
            String prefix = "";
            String suffix = ".jsp";
            for (UCallExpression callExpression : CodeConfigurationViewResolverParser.getChainCalls(expression)) {
                String value;
                String methodName = callExpression.getMethodName();
                if ("prefix".equals(methodName) && (value = (String)ObjectUtils.doIfNotNull((Object)callExpression.getArgumentForParameter(0), UastUtils::evaluateString)) != null) {
                    prefix = value;
                }
                if (!"suffix".equals(methodName) || (value = (String)ObjectUtils.doIfNotNull((Object)callExpression.getArgumentForParameter(0), UastUtils::evaluateString)) == null) continue;
                suffix = value;
            }
            this.myViewResolvers.add(new UrlBasedViewResolver(module, "CodeConfigurationViewResolverParser.jsp()", prefix.isEmpty() ? "/WEB-INF/" : "", prefix, suffix));
            return;
        }
        if (arguments.size() == 2) {
            String prefixExpr = UastUtils.evaluateString((UExpression)((UExpression)arguments.get(0)));
            String suffixExpr = UastUtils.evaluateString((UExpression)((UExpression)arguments.get(1)));
            if (prefixExpr != null && suffixExpr != null) {
                this.myViewResolvers.add(new UrlBasedViewResolver(module, "CodeConfigurationViewResolverParser.jsp()", "", prefixExpr, suffixExpr));
            }
        }
    }

    private void handleBeanName(@Nullable Module module) {
        if (module == null) {
            return;
        }
        this.myViewResolvers.add(new BeanNameViewResolverFactory.BeanNameViewResolver(module, "CodeConfigurationViewResolverParser.beanName()"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configClass", "com/intellij/spring/mvc/model/CodeConfigurationViewResolverParser", "parseConfigurationClass"));
    }
}

