/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B\u0017\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0096\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eJ \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001b0 2\u0006\u0010#\u001a\u00020\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lcom/intellij/spring/mvc/model/ModulesSorter;", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/module/Module;", "modules", "", "<init>", "([Lcom/intellij/openapi/module/Module;)V", "getModules", "()[Lcom/intellij/openapi/module/Module;", "[Lcom/intellij/openapi/module/Module;", "modulesHolders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/spring/mvc/model/ModulesSorter$ModuleHolder;", "maxSortTime", "Ljava/util/concurrent/atomic/AtomicLong;", "enabled", "", "getEnabled", "()Z", "measureComputationTime", "T", "fn", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "iterator", "", "dump", "", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "listener", "Lkotlin/Function2;", "", "", "module", "ModuleHolder", "Companion", "intellij.spring.mvc.impl"})
@ApiStatus.Internal
public final class ModulesSorter
implements Sequence<Module> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module[] modules;
    @NotNull
    private final ConcurrentHashMap<Module, ModuleHolder> modulesHolders;
    @NotNull
    private final AtomicLong maxSortTime;

    /*
     * WARNING - void declaration
     */
    private ModulesSorter(Module[] modules) {
        ConcurrentHashMap concurrentHashMap;
        this.modules = modules;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap = new ConcurrentHashMap();
        ModulesSorter modulesSorter = this;
        boolean bl = false;
        for (Module module : this.modules) {
            void $this$modulesHolders_u24lambda_u240;
            ((Map)$this$modulesHolders_u24lambda_u240).put(module, new ModuleHolder(module, Double.MIN_VALUE, 0, 0L, Long.MAX_VALUE));
        }
        modulesSorter.modulesHolders = concurrentHashMap;
        this.maxSortTime = new AtomicLong(0L);
    }

    @NotNull
    public final Module[] getModules() {
        return this.modules;
    }

    private final boolean getEnabled() {
        return Registry.Companion.is("spring.urlpath.completion.smart");
    }

    private final <T> T measureComputationTime(Function0<? extends T> fn) {
        long startTime = System.currentTimeMillis();
        Object sorted = fn.invoke();
        long spentTime = System.currentTimeMillis() - startTime;
        long prev = 0L;
        while ((prev = this.maxSortTime.get()) < spentTime && !this.maxSortTime.compareAndSet(prev, spentTime)) {
        }
        return (T)sorted;
    }

    @NotNull
    public Iterator<Module> iterator() {
        return this.getEnabled() ? SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)this.measureComputationTime(() -> ModulesSorter.iterator$lambda$1(this)))), ModulesSorter::iterator$lambda$2).iterator() : ArrayIteratorKt.iterator((Object[])this.modules);
    }

    public final void dump(@NotNull Appendable out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Appendable appendable = out.append("enabled: " + this.getEnabled());
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        Appendable appendable2 = out.append("max time sorting: " + this.maxSortTime.get() + " ms");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)out.append('\n'), (String)"append(...)");
        Appendable appendable3 = out.append("Modules sorted:");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append(...)");
        Collection<ModuleHolder> collection = this.modulesHolders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        for (ModuleHolder moduleHolder : CollectionsKt.sorted((Iterable)collection)) {
            Appendable appendable4 = out.append("  " + moduleHolder.getModule().getName() + " " + moduleHolder.getCount() + " " + moduleHolder.getMinTime() + "-" + moduleHolder.getMaxTime() + " " + moduleHolder.getRate());
            Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable4.append('\n'), (String)"append(...)");
        }
    }

    @NotNull
    public final Function2<Long, Integer, Unit> listener(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return (arg_0, arg_1) -> ModulesSorter.listener$lambda$3(this, module, arg_0, arg_1);
    }

    private static final List iterator$lambda$1(ModulesSorter this$0) {
        Collection<ModuleHolder> collection = this$0.modulesHolders.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.sorted((Iterable)collection);
    }

    private static final Module iterator$lambda$2(ModuleHolder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModule();
    }

    private static final Unit listener$lambda$3(ModulesSorter this$0, Module $module, long time, int count) {
        ModuleHolder moduleHolder = this$0.modulesHolders.get($module);
        if (moduleHolder == null) {
            throw new IllegalStateException("cant find module " + $module);
        }
        ModuleHolder holder = moduleHolder;
        if (count > 0 && count >= holder.getCount()) {
            double newRate = (double)time / (double)count;
            if (count > holder.getCount() || newRate < holder.getRate()) {
                ModuleHolder moduleHolder2 = ModuleHolder.copy$default(holder, null, newRate, count, Long.max(holder.getMaxTime(), time), Long.min(holder.getMinTime(), time), 1, null);
                ((Map)this$0.modulesHolders).put($module, moduleHolder2);
            }
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ ModulesSorter(Module[] modules, DefaultConstructorMarker $constructor_marker) {
        this(modules);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/spring/mvc/model/ModulesSorter$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/spring/mvc/model/ModulesSorter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.mvc.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModulesSorter getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> Companion.getInstance$lambda$0(project));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (ModulesSorter)object;
        }

        private static final CachedValueProvider.Result getInstance$lambda$0(Project $project) {
            ModuleManager moduleManager = ModuleManager.Companion.getInstance($project);
            Object[] objectArray = new Object[]{moduleManager};
            return CachedValueProvider.Result.create((Object)new ModulesSorter(moduleManager.getModules(), null), (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J;\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/spring/mvc/model/ModulesSorter$ModuleHolder;", "", "module", "Lcom/intellij/openapi/module/Module;", "rate", "", "count", "", "maxTime", "", "minTime", "<init>", "(Lcom/intellij/openapi/module/Module;DIJJ)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getRate", "()D", "getCount", "()I", "getMaxTime", "()J", "getMinTime", "compareTo", "other", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "", "hashCode", "toString", "", "intellij.spring.mvc.impl"})
    private static final class ModuleHolder
    implements Comparable<ModuleHolder> {
        @NotNull
        private final Module module;
        private final double rate;
        private final int count;
        private final long maxTime;
        private final long minTime;

        public ModuleHolder(@NotNull Module module, double rate, int count, long maxTime, long minTime) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.module = module;
            this.rate = rate;
            this.count = count;
            this.maxTime = maxTime;
            this.minTime = minTime;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        public final double getRate() {
            return this.rate;
        }

        public final int getCount() {
            return this.count;
        }

        public final long getMaxTime() {
            return this.maxTime;
        }

        public final long getMinTime() {
            return this.minTime;
        }

        @Override
        public int compareTo(@NotNull ModuleHolder other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Double.compare(this.rate, other.rate);
        }

        @NotNull
        public final Module component1() {
            return this.module;
        }

        public final double component2() {
            return this.rate;
        }

        public final int component3() {
            return this.count;
        }

        public final long component4() {
            return this.maxTime;
        }

        public final long component5() {
            return this.minTime;
        }

        @NotNull
        public final ModuleHolder copy(@NotNull Module module, double rate, int count, long maxTime, long minTime) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return new ModuleHolder(module, rate, count, maxTime, minTime);
        }

        public static /* synthetic */ ModuleHolder copy$default(ModuleHolder moduleHolder, Module module, double d, int n, long l, long l2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                module = moduleHolder.module;
            }
            if ((n2 & 2) != 0) {
                d = moduleHolder.rate;
            }
            if ((n2 & 4) != 0) {
                n = moduleHolder.count;
            }
            if ((n2 & 8) != 0) {
                l = moduleHolder.maxTime;
            }
            if ((n2 & 0x10) != 0) {
                l2 = moduleHolder.minTime;
            }
            return moduleHolder.copy(module, d, n, l, l2);
        }

        @NotNull
        public String toString() {
            return "ModuleHolder(module=" + this.module + ", rate=" + this.rate + ", count=" + this.count + ", maxTime=" + this.maxTime + ", minTime=" + this.minTime + ")";
        }

        public int hashCode() {
            int result = this.module.hashCode();
            result = result * 31 + Double.hashCode(this.rate);
            result = result * 31 + Integer.hashCode(this.count);
            result = result * 31 + Long.hashCode(this.maxTime);
            result = result * 31 + Long.hashCode(this.minTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleHolder)) {
                return false;
            }
            ModuleHolder moduleHolder = (ModuleHolder)other;
            if (!Intrinsics.areEqual((Object)this.module, (Object)moduleHolder.module)) {
                return false;
            }
            if (Double.compare(this.rate, moduleHolder.rate) != 0) {
                return false;
            }
            if (this.count != moduleHolder.count) {
                return false;
            }
            if (this.maxTime != moduleHolder.maxTime) {
                return false;
            }
            return this.minTime == moduleHolder.minTime;
        }
    }
}

