/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model.mappings;

import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.utils.PomTargetUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.jam.SpringMvcUrlPathSpecification;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class UrlMappingPsiBasedElement
implements UrlMappingElement {
    @Nullable
    private final PomTarget predefinedPomTarget;
    private final SmartPsiElementPointer<PsiElement> myDefinition;
    private final UrlPath myUrlPath;
    private final String presentation;
    private final RequestMethod[] method;
    @Nullable
    private final SpringBeanPointer<? extends CommonSpringBean> myProvidingBean;

    public UrlMappingPsiBasedElement(@NotNull String url, @NotNull PsiElement navigationElement, @Nullable PomTarget predefinedPomTarget, @Nullable String presentation, RequestMethod[] method) {
        if (url == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(0);
        }
        if (navigationElement == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(1);
        }
        this(url, navigationElement, predefinedPomTarget, presentation, method, null);
    }

    public UrlMappingPsiBasedElement(@NotNull String url, @NotNull PsiElement navigationElement, @Nullable PomTarget predefinedPomTarget, @Nullable String presentation, RequestMethod[] method, @Nullable SpringBeanPointer<? extends CommonSpringBean> providingBean) {
        if (url == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(2);
        }
        if (navigationElement == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(3);
        }
        this.predefinedPomTarget = predefinedPomTarget;
        Logger.getInstance(UrlMappingPsiBasedElement.class).assertTrue(navigationElement.isPhysical() || navigationElement instanceof PsiModifierListOwner, (Object)navigationElement);
        this.myDefinition = SmartPointerManager.createPointer((PsiElement)navigationElement);
        this.myUrlPath = SpringMvcUrlPathSpecification.INSTANCE.parsePath(url);
        this.presentation = presentation == null || presentation.equals(url) ? this.myUrlPath.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION) : presentation;
        this.method = method;
        this.myProvidingBean = providingBean;
    }

    public String toString() {
        return this.myUrlPath + " (" + this.presentation + ")";
    }

    @Override
    public PsiElement getNavigationTarget() {
        return this.myDefinition.getElement();
    }

    @Override
    @Nullable
    public PsiElement getDocumentationPsiElement() {
        UElement uElement = UastContextKt.toUElement((PsiElement)this.myDefinition.getElement());
        if (uElement == null) {
            return UrlMappingElement.super.getDocumentationPsiElement();
        }
        UDeclaration uDeclaration = (UDeclaration)UastUtils.getParentOfType((UElement)uElement, UDeclaration.class, (boolean)false);
        if (uDeclaration == null) {
            return UrlMappingElement.super.getDocumentationPsiElement();
        }
        return uDeclaration.getSourcePsi();
    }

    @Override
    @Deprecated
    public String getURL() {
        return this.myUrlPath.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION);
    }

    @Override
    @NotNull
    public UrlPath getUrlPath() {
        UrlPath urlPath = this.myUrlPath;
        if (urlPath == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(4);
        }
        return urlPath;
    }

    @Override
    public String getPresentation() {
        return this.presentation;
    }

    @Override
    public RequestMethod[] getMethod() {
        return this.method;
    }

    @Override
    @Nullable
    public PomNamedTarget getPomTarget() {
        if (this.predefinedPomTarget != null) {
            return PomTargetUtils.toPomRenameableTarget((PomTarget)this.predefinedPomTarget, (String)this.getPresentation(), (Icon)SpringApiIcons.RequestMapping, (String)this.getTypeName());
        }
        PsiElement navigationTarget = this.getNavigationTarget();
        if (navigationTarget == null) {
            return null;
        }
        return this.toPomTarget(navigationTarget);
    }

    @NotNull
    protected PomRenameableTarget<?> toPomTarget(PsiElement psiElement) {
        PomRenameableTarget pomRenameableTarget = PomTargetUtils.toPomRenameableTarget((PsiElement)psiElement, (String)this.getPresentation(), (Icon)SpringApiIcons.RequestMapping, (String)this.getTypeName());
        if (pomRenameableTarget == null) {
            UrlMappingPsiBasedElement.$$$reportNull$$$0(5);
        }
        return pomRenameableTarget;
    }

    @Nls
    protected String getTypeName() {
        return MicroservicesBundle.message((String)"microservices.url.path.segment", (Object[])new Object[0]);
    }

    @Override
    public boolean isDefinedInBean(SpringBeanPointer<? extends CommonSpringBean> controllerSpringBeanPointer) {
        PsiElement psiElement = this.myDefinition.getElement();
        if (psiElement == null) {
            return false;
        }
        PsiClass variantPsiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        if (variantPsiClass != null && controllerSpringBeanPointer instanceof JamSpringBeanPointer) {
            PsiManager psiManager = variantPsiClass.getManager();
            if (psiManager.areElementsEquivalent((PsiElement)variantPsiClass, (PsiElement)controllerSpringBeanPointer.getBeanClass())) {
                return true;
            }
            if (this.myProvidingBean != null) {
                return psiManager.areElementsEquivalent((PsiElement)controllerSpringBeanPointer.getBeanClass(), (PsiElement)this.myProvidingBean.getBeanClass());
            }
            PsiClass controllerClass = controllerSpringBeanPointer.getBeanClass();
            if (controllerClass != null && controllerClass.isValid()) {
                for (PsiClass controllerSuperClass : controllerClass.getSupers()) {
                    if (!psiManager.areElementsEquivalent((PsiElement)variantPsiClass, (PsiElement)controllerSuperClass)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlMappingPsiBasedElement element = (UrlMappingPsiBasedElement)o;
        return Objects.equals(this.predefinedPomTarget, element.predefinedPomTarget) && Objects.equals(this.myDefinition.getElement(), element.myDefinition.getElement()) && this.myUrlPath.equals((Object)element.myUrlPath);
    }

    public int hashCode() {
        return Objects.hash(this.predefinedPomTarget, this.myDefinition.getElement(), this.myUrlPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/model/mappings/UrlMappingPsiBasedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/model/mappings/UrlMappingPsiBasedElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toPomTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

