/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.navigation.requests.rest;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.model.jam.SpringMvcUrlPathSpecification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"findUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "project", "Lcom/intellij/openapi/project/Project;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "getUrlPathContextSuperMethods", "anno", "", "intellij.spring.mvc.impl"})
public final class UrlPathContextUtilsKt {
    @Nullable
    public static final UrlPathContext findUrlPathContext(@NotNull Project project, @NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        RequestMapping.Method requestMethodInfo = (RequestMapping.Method)JamService.getJamService((Project)project).getJamElement(RequestMapping.METHOD_JAM_KEY, (PsiElement)psiMethod);
        if (requestMethodInfo == null || !SpringControllerUtils.isRequestHandler(psiMethod)) {
            return null;
        }
        Object t = requestMethodInfo.getPsiElement();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getPsiElement(...)");
        UrlPathContext urlPathContext = SpringMvcUrlPathSpecification.INSTANCE.getUrlPathContext((PsiElement)t);
        if (urlPathContext.isEmpty()) {
            String string = requestMethodInfo.getIdentifyingAnnotationFQN();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifyingAnnotationFQN(...)");
            urlPathContext = UrlPathContextUtilsKt.getUrlPathContextSuperMethods(psiMethod, string);
        }
        return urlPathContext;
    }

    private static final UrlPathContext getUrlPathContextSuperMethods(PsiMethod psiMethod, String anno) {
        for (PsiMethod superMethod : psiMethod.findSuperMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)superMethod), (String)anno, (int)0)) continue;
            Intrinsics.checkNotNull((Object)superMethod);
            return SpringMvcUrlPathSpecification.INSTANCE.getUrlPathContext((PsiElement)superMethod);
        }
        return UrlPathContext.Companion.emptyRoot();
    }
}

