/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.mvc.views.WithPrefixSuffix;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class UrlBasedViewResolver
extends WithPrefixSuffix {
    @NotNull
    private final Module myModule;
    @NotNull
    private final String myPath;
    @NotNull
    private final String myPrefix;
    @NotNull
    private final String mySuffix;
    @NotNull
    private final String myID;
    @NotNull
    private final String myPathAndPrefix;

    public UrlBasedViewResolver(@NotNull Module module, @NotNull String ID, @Nullable String path, @Nullable String prefix, @Nullable String suffix) {
        if (module == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(0);
        }
        if (ID == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(1);
        }
        this.myModule = module;
        this.myID = ID;
        this.myPath = StringUtil.notNullize((String)path);
        this.myPrefix = StringUtil.notNullize((String)prefix);
        this.mySuffix = StringUtil.notNullize((String)suffix);
        this.myPathAndPrefix = this.myPath + this.myPrefix;
    }

    private boolean isClasspathPrefix() {
        return StringUtil.startsWith((CharSequence)this.myPathAndPrefix, (CharSequence)"classpath:");
    }

    @Override
    @NotNull
    @TestOnly
    public String getID() {
        String string = this.myID;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public Set<PsiElement> resolveView(String viewName) {
        if (this.isClasspathPrefix()) {
            PsiElement viewForClasspath = this.resolveViewForClasspath(viewName);
            Set<Object> set = viewForClasspath == null ? Collections.emptySet() : Collections.singleton(viewForClasspath);
            if (set == null) {
                UrlBasedViewResolver.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set<PsiElement> set = this.getWebDirectoryElements(this.calculatePath(viewName)).stream().map(element -> element.getOriginalFile()).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(5);
        }
        return module;
    }

    @NotNull
    private Set<WebDirectoryElement> getWebDirectoryElements(String path) {
        HashSet<WebDirectoryElement> elements = new HashSet<WebDirectoryElement>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)this.getModule())) {
            ContainerUtil.addIfNotNull(elements, (Object)WebUtil.getWebUtil().findWebDirectoryElement(path, webFacet));
        }
        HashSet<WebDirectoryElement> hashSet = elements;
        if (hashSet == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private String calculatePath(String viewName) {
        return UrlBasedViewResolver.joinPaths(this.myPath, UrlBasedViewResolver.joinPaths(this.myPrefix, viewName + this.mySuffix, false), true);
    }

    private static String joinPaths(@NotNull String path, String fileName, boolean forceSlash) {
        if (path == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(7);
        }
        if (path.isEmpty()) {
            return fileName;
        }
        if (path.endsWith("/") && fileName.startsWith("/")) {
            return path + fileName.substring(1);
        }
        if (forceSlash && !path.endsWith("/") && !fileName.startsWith("/")) {
            return path + "/" + fileName;
        }
        return path + fileName;
    }

    @Nullable
    private PsiElement resolveViewForClasspath(String viewName) {
        SpringResourcesBuilder builder = SpringResourcesBuilder.create((Module)this.getModule(), (String)this.calculatePath(viewName), (int)1);
        PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(builder);
        Collection items = SpringResourcesUtil.getInstance().getResourceItems(references, Conditions.alwaysTrue());
        return (PsiElement)ContainerUtil.getFirstItem((Collection)items);
    }

    @Override
    @NotNull
    public List<LookupElement> getAllResolverViews() {
        List<LookupElement> list = this.getAllResolverViews(Collections.emptyList());
        if (list == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(8);
        }
        return list;
    }

    public List<LookupElement> getAllResolverViews(List<String> pathSegments) {
        if (this.isClasspathPrefix()) {
            return this.getAllViewsForClasspath(pathSegments);
        }
        Set<WebDirectoryElement> webDirectoryElements = this.getWebDirectoryElements(this.myPathAndPrefix);
        ArrayList<LookupElement> lookupElements = new ArrayList<LookupElement>();
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor(lookupElements);
        for (WebDirectoryElement webDirectoryElement : webDirectoryElements) {
            VirtualFile file = webDirectoryElement.getOriginalVirtualFile();
            if (file == null) continue;
            for (VirtualFile child : file.getChildren()) {
                if (this.myPathAndPrefix.isEmpty()) {
                    new MyDirectoryLookupWalker(pathSegments, (Processor<? super LookupElement>)collectProcessor).visitFile(child);
                    continue;
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)child, (VirtualFileVisitor)new MyDirectoryLookupWalker(pathSegments, (Processor<? super LookupElement>)collectProcessor));
            }
        }
        return lookupElements;
    }

    @NotNull
    private List<LookupElement> getAllViewsForClasspath(List<String> pathSegments) {
        SpringResourcesBuilder builder = SpringResourcesBuilder.create((Module)this.getModule(), (String)this.myPathAndPrefix, (int)1).endingSlashNotAllowed(false);
        PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(builder);
        Collection directories = SpringResourcesUtil.getInstance().getResourceItems(references, PsiFileSystemItem::isDirectory);
        SmartList variants = new SmartList();
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor((Collection)variants);
        for (PsiFileSystemItem directory : directories) {
            for (VirtualFile file : directory.getVirtualFile().getChildren()) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new MyDirectoryLookupWalker(pathSegments, (Processor<? super LookupElement>)collectProcessor));
            }
        }
        SmartList smartList = variants;
        if (smartList == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @Override
    public String bindToElement(PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        WebDirectoryElement webDirectoryElement = WebUtil.findWebDirectoryByFile((PsiFileSystemItem)((PsiFile)element));
        if (webDirectoryElement == null) {
            return null;
        }
        String path = webDirectoryElement.getPath();
        if (path.startsWith(this.myPathAndPrefix) && path.endsWith(this.mySuffix)) {
            return path.substring(this.myPathAndPrefix.length(), path.length() - this.mySuffix.length());
        }
        return path;
    }

    @Override
    @NotNull
    public String handleElementRename(String path) {
        String string = path = StringUtil.trimEnd((String)path, (String)this.mySuffix);
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(10);
        }
        return string;
    }

    public Collection<PsiFileSystemItem> getRoots() {
        HashSet<PsiFileSystemItem> elements = new HashSet<PsiFileSystemItem>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)this.myModule)) {
            ContainerUtil.addIfNotNull(elements, (Object)WebUtil.getWebUtil().findWebDirectoryElement(this.myPathAndPrefix, webFacet));
        }
        return elements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("UrlBasedViewResolver{");
        if (!this.myPath.isEmpty()) {
            builder.append("myPath='").append(this.myPath).append("', ");
        }
        return builder.append("myPrefix='").append(this.myPrefix).append('\'').append(", mySuffix='").append(this.mySuffix).append('\'').append('}').toString();
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuffix() {
        String string = this.mySuffix;
        if (string == null) {
            UrlBasedViewResolver.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlBasedViewResolver)) {
            return false;
        }
        UrlBasedViewResolver resolver = (UrlBasedViewResolver)o;
        if (!this.getModule().equals(resolver.getModule())) {
            return false;
        }
        if (!this.getPath().equals(resolver.getPath())) {
            return false;
        }
        if (!this.getPrefix().equals(resolver.getPrefix())) {
            return false;
        }
        return this.getSuffix().equals(resolver.getSuffix());
    }

    public int hashCode() {
        int result = this.getModule().hashCode();
        result = 31 * result + this.getPath().hashCode();
        result = 31 * result + this.getPrefix().hashCode();
        result = 31 * result + this.getSuffix().hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/UrlBasedViewResolver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/UrlBasedViewResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebDirectoryElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResolverViews";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViewsForClasspath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "joinPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    private class MyDirectoryLookupWalker
    extends VirtualFileVisitor<Object> {
        private final Stack<String> nameStack;
        private final List<String> myPathSegments;
        private final Processor<? super LookupElement> myVariants;

        private MyDirectoryLookupWalker(List<String> pathSegments, Processor<? super LookupElement> variants) {
            super(new VirtualFileVisitor.Option[]{VirtualFileVisitor.limit((int)5)});
            this.myPathSegments = !pathSegments.isEmpty() && pathSegments.get(0).isEmpty() ? UtilKt.tail(pathSegments) : pathSegments;
            this.myVariants = variants;
            this.nameStack = new Stack();
        }

        public boolean visitFile(@NotNull VirtualFile file) {
            String fileName;
            List currentPath;
            if (file == null) {
                MyDirectoryLookupWalker.$$$reportNull$$$0(0);
            }
            if (!ContainerUtil.startsWith((List)(currentPath = ContainerUtil.append(this.nameStack, (Object[])new String[]{fileName = file.getName()})), this.myPathSegments) && !ContainerUtil.startsWith(this.myPathSegments, (List)currentPath)) {
                return false;
            }
            if (file.isDirectory()) {
                this.nameStack.push((Object)fileName);
                return true;
            }
            if (!fileName.endsWith(UrlBasedViewResolver.this.mySuffix)) {
                return super.visitFile(file);
            }
            PsiFile psiFile = PsiManager.getInstance((Project)UrlBasedViewResolver.this.getModule().getProject()).findFile(file);
            if (psiFile == null) {
                return super.visitFile(file);
            }
            String viewName = StringUtil.join((Collection)ContainerUtil.append(this.nameStack, (Object[])new String[]{fileName.substring(0, fileName.length() - UrlBasedViewResolver.this.mySuffix.length())}), (String)"/");
            return this.myVariants.process((Object)LookupElementBuilder.create((String)viewName).withPsiElement((PsiElement)psiFile).withIcon(psiFile.getIcon(0)).withTailText(" (" + fileName + ")", true));
        }

        public void afterChildrenVisited(@NotNull VirtualFile file) {
            if (file == null) {
                MyDirectoryLookupWalker.$$$reportNull$$$0(1);
            }
            if (file.isDirectory()) {
                this.nameStack.pop();
            }
            super.afterChildrenVisited(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/intellij/spring/mvc/views/UrlBasedViewResolver$MyDirectoryLookupWalker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterChildrenVisited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

