/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.views.resolvers;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.mvc.views.ViewResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class ResourceBundleViewResolver
extends ViewResolver {
    private final Set<String> myBasenames;
    private final CommonSpringBean myBean;

    public ResourceBundleViewResolver(@NotNull CommonSpringBean commonSpringBean) {
        if (commonSpringBean == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(0);
        }
        this.myBasenames = new LinkedHashSet<String>();
        this.myBean = commonSpringBean;
        if (commonSpringBean instanceof SpringBean) {
            SpringBean bean = (SpringBean)commonSpringBean;
            String basename = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"basename");
            if (basename != null) {
                this.myBasenames.add(basename);
            } else {
                Set basenames = SpringPropertyUtils.getArrayPropertyStringValues((CommonSpringBean)bean, (String)"basenames");
                if (basenames.size() > 0) {
                    this.myBasenames.addAll(basenames);
                } else {
                    this.myBasenames.add("views");
                }
            }
        }
    }

    @Override
    @NotNull
    @TestOnly
    public String getID() {
        String string = "ResourceBundleViewResolver[" + this.myBean.getBeanName() + "]";
        if (string == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public Set<PsiElement> resolveView(String viewName) {
        List<PropertiesFile> bundles = this.getBundles();
        for (PropertiesFile bundle : bundles) {
            IProperty property = bundle.findPropertyByKey(viewName);
            if (property == null) continue;
            Set<PsiElement> set = Collections.singleton(property.getPsiElement());
            if (set == null) {
                ResourceBundleViewResolver.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public List<LookupElement> getAllResolverViews() {
        ArrayList<LookupElement> list = new ArrayList<LookupElement>();
        List<PropertiesFile> bundles = this.getBundles();
        for (PropertiesFile bundle : bundles) {
            for (IProperty property : bundle.getProperties()) {
                String key = property.getKey();
                if (key == null) continue;
                list.add((LookupElement)LookupElementBuilder.create((String)key).withTailText(" (" + property.getValue() + ")", true));
            }
        }
        ArrayList<LookupElement> arrayList = list;
        if (arrayList == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    public String bindToElement(PsiElement element) {
        return ((IProperty)element).getKey();
    }

    @Override
    @NotNull
    public String handleElementRename(String newElementName) {
        String string = newElementName;
        if (string == null) {
            ResourceBundleViewResolver.$$$reportNull$$$0(5);
        }
        return string;
    }

    private List<PropertiesFile> getBundles() {
        PsiFile containingFile = this.myBean.getContainingFile();
        ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>();
        for (String basename : this.myBasenames) {
            PsiFileSystemItem item;
            String fileName = StringUtil.replace((String)basename, (String)".", (String)"/") + ".properties";
            PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)containingFile.getProject()).createExpressionFromText("\"" + fileName + "\"", (PsiElement)containingFile);
            if (!(psiExpression instanceof PsiLiteral)) continue;
            SpringResourcesBuilder resourcesBuilder = SpringResourcesBuilder.create((PsiElement)psiExpression, (String)fileName).fromRoot(fileName.startsWith("/")).soft(false);
            PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(resourcesBuilder);
            if (!(references[0] instanceof FileReference) || !((item = ((FileReference)references[0]).getFileReferenceSet().resolve()) instanceof PropertiesFile)) continue;
            files.add((PropertiesFile)item);
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSpringBean";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/views/resolvers/ResourceBundleViewResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/views/resolvers/ResourceBundleViewResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResolverViews";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

