/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.restOperations;

import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import com.intellij.spring.mvc.webClient.restOperations.RestOperationsUtils;
import com.intellij.spring.mvc.webClient.restOperations.RestTemplatesModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/mvc/webClient/restOperations/RestOperationsModel;", "Lcom/intellij/spring/mvc/webClient/restOperations/RestTemplatesModel;", "<init>", "()V", "getUrlApiMethods", "", "Lcom/intellij/psi/PsiMethod;", "module", "Lcom/intellij/openapi/module/Module;", "getApiClasses", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/jvm/cache/ScopedCacheValueHolder;", "getWebClientPackage", "", "getEndpoints", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "group", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "findRestOperationEndpoints", "holderPsi", "Lcom/intellij/psi/PsiElement;", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nRestOperationsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestOperationsModel.kt\ncom/intellij/spring/mvc/webClient/restOperations/RestOperationsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1368#2:41\n1454#2,5:42\n*S KotlinDebug\n*F\n+ 1 RestOperationsModel.kt\ncom/intellij/spring/mvc/webClient/restOperations/RestOperationsModel\n*L\n37#1:41\n37#1:42,5\n*E\n"})
public final class RestOperationsModel
extends RestTemplatesModel {
    @NotNull
    public static final RestOperationsModel INSTANCE = new RestOperationsModel();

    private RestOperationsModel() {
    }

    @Override
    @NotNull
    protected List<PsiMethod> getUrlApiMethods(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return RestOperationsUtils.INSTANCE.getRestOperationsMethods(project);
    }

    @Override
    @NotNull
    public List<PsiClass> getApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return RestOperationsUtils.INSTANCE.getRestOperationsApiClasses(query);
    }

    @Override
    @NotNull
    protected String getWebClientPackage() {
        return "org.springframework.web.client";
    }

    @NotNull
    public final List<WebClientUrl> getEndpoints(@NotNull WebClientHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PsiElement holderPsi = group.getPsiElement();
        if (UastContextKt.toUElement((PsiElement)holderPsi) == null) {
            return CollectionsKt.emptyList();
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)holderPsi.getProject());
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)holderPsi, () -> RestOperationsModel.getEndpoints$lambda$0(holderPsi));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebClientUrl> findRestOperationEndpoints(PsiElement holderPsi) {
        List list;
        HashSet methodCalls = new HashSet();
        Project project = holderPsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        for (PsiMethod apiMethod : RestOperationsUtils.INSTANCE.getRestOperationsMethods(project)) {
            methodCalls.addAll(SpringFunctionalSearchersUtils.findMethodCalls((PsiMethod)apiMethod, (SearchScope)((SearchScope)new LocalSearchScope(holderPsi))));
        }
        if (methodCalls.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = methodCalls;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                UCallExpression it = (UCallExpression)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.findUrl(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        return list;
    }

    private static final CachedValueProvider.Result getEndpoints$lambda$0(PsiElement $holderPsi) {
        return CachedValueProvider.Result.createSingleDependency(INSTANCE.findRestOperationEndpoints($holderPsi), (Object)$holderPsi.getContainingFile());
    }
}

