/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.GroupNodeDescription;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class DuplocatorHashCallback
implements FragmentsCollector {
    private static final Logger LOG = Logger.getInstance(DuplocatorHashCallback.class);
    private Int2ObjectMap<List<List<PsiFragment>>> myDuplicates = new Int2ObjectOpenHashMap();
    private final int myBound;
    private boolean myReadOnly = false;
    private final int myDiscardCost;

    public DuplocatorHashCallback(int bound, int discardCost) {
        this.myBound = bound;
        this.myDiscardCost = discardCost;
    }

    public DuplocatorHashCallback(int bound, int discardCost, boolean readOnly) {
        this(bound, discardCost);
        this.myReadOnly = readOnly;
    }

    public DuplocatorHashCallback(int lowerBound) {
        this(lowerBound, 0);
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public void add(int hash2, int cost, PsiFragment frag, NodeSpecificHasher visitor2) {
        this.forceAdd(hash2, cost, frag);
    }

    private void forceAdd(int hash2, int cost, PsiFragment frag) {
        if (frag == null) {
            this.myDuplicates.put(hash2, new ArrayList());
            return;
        }
        frag.setCost(cost);
        List fragments = (List)this.myDuplicates.get(hash2);
        if (fragments == null) {
            if (!this.myReadOnly) {
                ArrayList list2 = new ArrayList();
                ArrayList<PsiFragment> listF = new ArrayList<PsiFragment>();
                listF.add(frag);
                list2.add(listF);
                this.myDuplicates.put(hash2, list2);
            }
            return;
        }
        boolean found = false;
        PsiElement[] elements = frag.getElements();
        int discardCost = 0;
        if (this.myDiscardCost >= 0) {
            discardCost = this.myDiscardCost;
        } else {
            DuplocatorState state = DuplocatorUtil.getDuplocatorState(frag);
            if (state != null) {
                discardCost = state.getDiscardCost();
            }
        }
        Iterator i = fragments.iterator();
        while (i.hasNext() && !found) {
            List fi = (List)i.next();
            PsiFragment aFrag = (PsiFragment)fi.get(0);
            if (!aFrag.isEqual(elements, discardCost)) continue;
            boolean skipNew = false;
            Iterator frags = fi.iterator();
            while (frags.hasNext() && !skipNew) {
                PsiFragment old = (PsiFragment)frags.next();
                if (!frag.intersectsWith(old)) continue;
                if (old.getCost() < frag.getCost() || frag.contains(old)) {
                    frags.remove();
                    continue;
                }
                skipNew = true;
            }
            if (!skipNew) {
                fi.add(frag);
            }
            found = true;
        }
        if (!found) {
            ArrayList<PsiFragment> newFrags = new ArrayList<PsiFragment>();
            newFrags.add(frag);
            fragments.add(newFrags);
        }
    }

    @Override
    public void add(int hash2, int cost, PsiFragment frag) {
        int bound;
        if (this.myBound >= 0) {
            bound = this.myBound;
        } else {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            bound = duplocatorState.getLowerBound();
        }
        if (cost >= bound) {
            this.forceAdd(hash2, cost, frag);
        }
    }

    public DupInfo getInfo() {
        Object2IntOpenHashMap duplicateList = new Object2IntOpenHashMap();
        for (Int2ObjectMap.Entry entry2 : this.myDuplicates.int2ObjectEntrySet()) {
            for (List list2 : (List)entry2.getValue()) {
                int len = list2.size();
                if (len <= 1) continue;
                PsiFragment[] filtered = new PsiFragment[len];
                int idx = 0;
                for (PsiFragment fragment : list2) {
                    fragment.markDuplicate();
                    filtered[idx++] = fragment;
                }
                duplicateList.put((Object)filtered, entry2.getIntKey());
            }
        }
        this.myDuplicates = null;
        ObjectIterator iterator = duplicateList.object2IntEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry2;
            entry2 = (Object2IntMap.Entry)iterator.next();
            PsiFragment[] fragments = (PsiFragment[])entry2.getKey();
            LOG.assertTrue(fragments.length > 1);
            boolean nested = false;
            for (PsiFragment fragment : fragments) {
                if (!fragment.isNested()) continue;
                nested = true;
                break;
            }
            if (!nested) continue;
            iterator.remove();
        }
        final PsiFragment[][] duplicates = (PsiFragment[][])duplicateList.keySet().toArray((Object[])new PsiFragment[0][]);
        Arrays.sort(duplicates, (x, y) -> y[0].getCost() - x[0].getCost());
        return new DupInfo(){
            private final Int2ObjectMap<GroupNodeDescription> myPattern2Description = new Int2ObjectOpenHashMap();
            final /* synthetic */ Object2IntMap val$duplicateList;
            {
                this.val$duplicateList = object2IntMap;
            }

            @Override
            public int getPatterns() {
                return duplicates.length;
            }

            @Override
            public int getPatternCost(int number) {
                return duplicates[number][0].getCost();
            }

            @Override
            public int getPatternDensity(int number) {
                return duplicates[number].length;
            }

            @Override
            public PsiFragment[] getFragmentOccurences(int pattern) {
                return duplicates[pattern];
            }

            @Override
            public UsageInfo[] getUsageOccurences(int pattern) {
                PsiFragment[] occurrences = this.getFragmentOccurences(pattern);
                UsageInfo[] infos = new UsageInfo[occurrences.length];
                for (int i = 0; i < infos.length; ++i) {
                    infos[i] = occurrences[i].getUsageInfo();
                }
                return infos;
            }

            @Override
            public int getFileCount(int pattern) {
                if (this.myPattern2Description.containsKey(pattern)) {
                    return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getFilesCount();
                }
                return this.cacheGroupNodeDescription(pattern).getFilesCount();
            }

            private GroupNodeDescription cacheGroupNodeDescription(int pattern) {
                PsiFragment[] occurrences;
                HashSet<PsiFile> files = new HashSet<PsiFile>();
                for (PsiFragment occurrence : occurrences = this.getFragmentOccurences(pattern)) {
                    PsiFile file = occurrence.getFile();
                    if (file == null) continue;
                    files.add(file);
                }
                int fileCount = files.size();
                PsiFile psiFile = occurrences[0].getFile();
                DuplicatesProfile profile = DuplicatesProfile.findProfileForDuplicate(this, pattern);
                String comment = profile != null ? profile.getComment(this, pattern) : "";
                String filename = psiFile != null ? psiFile.getName() : DupLocatorBundle.message("duplicates.unknown.file.node.title", new Object[0]);
                GroupNodeDescription description = new GroupNodeDescription(fileCount, filename, comment);
                this.myPattern2Description.put(pattern, (Object)description);
                return description;
            }

            @Override
            @Nullable
            @Nls
            public String getTitle(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.myPattern2Description.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getTitle();
                    }
                    return this.cacheGroupNodeDescription(pattern).getTitle();
                }
                return null;
            }

            @Override
            @Nullable
            @Nls
            public String getComment(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.myPattern2Description.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getComment();
                    }
                    return this.cacheGroupNodeDescription(pattern).getComment();
                }
                return null;
            }

            @Override
            public int getHash(int i) {
                return this.val$duplicateList.getInt((Object)duplicates[i]);
            }
        };
    }

    public void report(@NotNull Path dir, @NotNull Project project2) throws IOException, XMLStreamException {
        if (dir == null) {
            DuplocatorHashCallback.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            DuplocatorHashCallback.$$$reportNull$$$0(1);
        }
        int[] hashCodes = this.myDuplicates.keySet().toIntArray();
        try (BufferedWriter fileWriter = Files.newBufferedWriter(dir.resolve("fragments.xml"), new OpenOption[0]);){
            XMLStreamWriter writer = XMLOutputFactory.newDefaultFactory().createXMLStreamWriter(fileWriter);
            writer.writeStartElement("root");
            for (int hash2 : hashCodes) {
                List dupList = (List)this.myDuplicates.get(hash2);
                writer.writeStartElement("hash");
                writer.writeAttribute("val", String.valueOf(hash2));
                for (List psiFragments : dupList) {
                    DuplocatorHashCallback.writeFragments(psiFragments, writer, project2, false);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
        DuplocatorHashCallback.writeDuplicates(dir, project2, this.getInfo());
    }

    public static void writeDuplicates(@NotNull Path dir, @NotNull Project project2, DupInfo info) throws IOException, XMLStreamException {
        if (dir == null) {
            DuplocatorHashCallback.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            DuplocatorHashCallback.$$$reportNull$$$0(3);
        }
        try (BufferedWriter fileWriter = Files.newBufferedWriter(dir.resolve("duplicates.xml"), new OpenOption[0]);){
            XMLStreamWriter writer = XMLOutputFactory.newDefaultFactory().createXMLStreamWriter(fileWriter);
            writer.writeStartElement("root");
            int patterns = info.getPatterns();
            for (int i = 0; i < patterns; ++i) {
                writer.writeStartElement("duplicate");
                writer.writeAttribute("cost", String.valueOf(info.getPatternCost(i)));
                writer.writeAttribute("hash", String.valueOf(info.getHash(i)));
                DuplocatorHashCallback.writeFragments(Arrays.asList(info.getFragmentOccurences(i)), writer, project2, true);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
    }

    private static void writeFragments(List<? extends PsiFragment> psiFragments, XMLStreamWriter writer, @NotNull Project project2, boolean shouldWriteOffsets) throws XMLStreamException {
        if (project2 == null) {
            DuplocatorHashCallback.$$$reportNull$$$0(4);
        }
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project2);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        for (PsiFragment psiFragment : psiFragments) {
            PsiFile psiFile = psiFragment.getFile();
            VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
            if (virtualFile == null) continue;
            writer.writeStartElement("fragment");
            writer.writeAttribute("file", macroManager.collapsePath(virtualFile.getUrl()));
            if (shouldWriteOffsets) {
                Document document = documentManager.getDocument(psiFile);
                LOG.assertTrue(document != null);
                int startOffset = psiFragment.getStartOffset();
                int line = document.getLineNumber(startOffset);
                writer.writeAttribute("line", String.valueOf(line));
                int lineStartOffset = document.getLineStartOffset(line);
                if (Strings.isEmptyOrSpaces((CharSequence)document.getText().substring(lineStartOffset, startOffset))) {
                    startOffset = lineStartOffset;
                }
                writer.writeAttribute("start", String.valueOf(startOffset));
                writer.writeAttribute("end", String.valueOf(psiFragment.getEndOffset()));
                if (psiFragment.containsMultipleFragments()) {
                    int[][] offsets;
                    for (int[] offset : offsets = psiFragment.getOffsets()) {
                        writer.writeStartElement("offset");
                        writer.writeAttribute("start", String.valueOf(offset[0]));
                        writer.writeAttribute("end", String.valueOf(offset[1]));
                        writer.writeEndElement();
                    }
                }
            }
            writer.writeEndElement();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/treeHash/DuplocatorHashCallback";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeFragments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

