/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.utils;

import com.intellij.model.Pointer;
import com.intellij.navigation.EmptyNavigatable;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.SymbolNavigationService;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.Stack;
import com.intellij.webSymbols.CompositeWebSymbol;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.webSymbols.WebSymbolDelegate;
import com.intellij.webSymbols.WebSymbolNameSegment;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.WebSymbolQualifiedName;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.completion.WebSymbolCodeCompletionItem;
import com.intellij.webSymbols.html.WebSymbolHtmlAttributeValue;
import com.intellij.webSymbols.impl.WebSymbolNameSegmentImpl;
import com.intellij.webSymbols.impl.WebSymbolsImplUtilsKt;
import com.intellij.webSymbols.patterns.WebSymbolsPattern;
import com.intellij.webSymbols.patterns.impl.MatchResult;
import com.intellij.webSymbols.patterns.impl.PatternImplUtilsKt;
import com.intellij.webSymbols.query.WebSymbolMatch;
import com.intellij.webSymbols.query.WebSymbolNamesProvider;
import com.intellij.webSymbols.query.WebSymbolsCodeCompletionQueryParams;
import com.intellij.webSymbols.query.WebSymbolsListSymbolsQueryParams;
import com.intellij.webSymbols.query.WebSymbolsNameMatchQueryParams;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.query.impl.WebSymbolMatchImpl;
import com.intellij.webSymbols.references.WebSymbolReferenceProblem;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a_\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002\"\b\b\u0001\u0010\u0003*\u00020\u0002*\u0002H\u00012\b\u0010\u0004\u001a\u0004\u0018\u0001H\u00032\u001d\u0010\u0005\u001a\u0019\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00010\u0006\u00a2\u0006\u0002\b\u0007H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0001\u00a2\u0006\u0002\u0010\b\u001a\u0010\u0010\t\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u001c\u0010\r\u001a\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\n\u001a\u0012\u0010\u000f\u001a\u00020\f*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u00020\f*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016*\u00020\f\u001a\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b\u001a.\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"\u001a.\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000b*\u00020\f2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020'2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"\u001a\u001a\u0010(\u001a\u00020\n*\u00020\f2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*\u001a\f\u00103\u001a\u0004\u0018\u000104*\u00020\u0018\u001a\u001e\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b*\b\u0012\u0004\u0012\u00020\u00180\u000b2\u0006\u0010G\u001a\u00020H\u001a\u0016\u0010I\u001a\u00020J*\u0004\u0018\u00010J2\b\u0010K\u001a\u0004\u0018\u00010J\u001a6\u0010L\u001a\u00020J\"\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0010M\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010N2\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010J0P\u001a6\u0010L\u001a\u00020J\"\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0010Q\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00162\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010J0P\u001a\u0014\u0010R\u001a\u0004\u0018\u00010S*\n\u0012\u0006\u0012\u0004\u0018\u00010S0\u0016\u001a\u001a\u0010T\u001a\u00020U*\u00020V2\u0006\u0010W\u001a\u00020\u00142\u0006\u0010X\u001a\u00020H\u001a.\u0010Y\u001a\b\u0012\u0004\u0012\u00020%0\u000b*\u00020#2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020'2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020#0\"\u001a\u001e\u0010^\u001a\u00020_2\u0014\u0010`\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020_0a0\u000bH\u0000\"\u0015\u0010+\u001a\u00020,*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\"\u0015\u0010/\u001a\u000200*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\"\u0015\u00105\u001a\u00020\n*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\"\u001b\u00108\u001a\b\u0012\u0004\u0012\u00020\u00180\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\"\u001b\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\"\u0018\u0010>\u001a\u00020\u0011*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\"\u0015\u0010A\u001a\u00020\n*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\bB\u00107\"\u0017\u0010C\u001a\u00020\n*\u0004\u0018\u00010D8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010E\" \u0010[\u001a\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u00020#0\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006b"}, d2={"applyIfNotNull", "T", "", "P", "param", "block", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "hasOnlyExtensions", "", "", "Lcom/intellij/webSymbols/WebSymbol;", "asSingleSymbol", "force", "withMatchedName", "matchedName", "", "withNavigationTarget", "target", "Lcom/intellij/psi/PsiElement;", "unwrapMatchedSymbols", "Lkotlin/sequences/Sequence;", "withSymbols", "Lcom/intellij/webSymbols/WebSymbolNameSegment;", "symbols", "withSegments", "Lcom/intellij/webSymbols/query/WebSymbolMatch;", "segments", "match", "nameToMatch", "params", "Lcom/intellij/webSymbols/query/WebSymbolsNameMatchQueryParams;", "context", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "toCodeCompletionItems", "Lcom/intellij/webSymbols/completion/WebSymbolCodeCompletionItem;", "name", "Lcom/intellij/webSymbols/query/WebSymbolsCodeCompletionQueryParams;", "nameMatches", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "qualifiedName", "Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "getQualifiedName", "(Lcom/intellij/webSymbols/WebSymbol;)Lcom/intellij/webSymbols/WebSymbolQualifiedName;", "qualifiedKind", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "getQualifiedKind", "(Lcom/intellij/webSymbols/WebSymbol;)Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "getProblemKind", "Lcom/intellij/webSymbols/references/WebSymbolReferenceProblem$ProblemKind;", "completeMatch", "getCompleteMatch", "(Lcom/intellij/webSymbols/WebSymbol;)Z", "nameSegments", "getNameSegments", "(Lcom/intellij/webSymbols/WebSymbol;)Ljava/util/List;", "nameSegmentsWithProblems", "getNameSegmentsWithProblems", "(Lcom/intellij/webSymbols/WebSymbol;)Lkotlin/sequences/Sequence;", "matchedNameOrName", "getMatchedNameOrName", "(Lcom/intellij/webSymbols/WebSymbol;)Ljava/lang/String;", "hideFromCompletion", "getHideFromCompletion", "isCritical", "Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;", "(Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;)Z", "withOffset", "offset", "", "coalesceWith", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "other", "coalesceApiStatus", "collection", "", "mapper", "Lkotlin/Function1;", "sequence", "merge", "Lcom/intellij/webSymbols/html/WebSymbolHtmlAttributeValue;", "createPsiRangeNavigationItem", "Lcom/intellij/pom/Navigatable;", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "element", "offsetWithinElement", "getDefaultCodeCompletions", "scope", "lastWebSymbol", "getLastWebSymbol", "(Ljava/util/List;)Lcom/intellij/webSymbols/WebSymbol;", "createModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "trackersPointers", "Lcom/intellij/model/Pointer;", "intellij.platform.webSymbols"})
@JvmName(name="WebSymbolUtils")
@SourceDebugExtension(value={"SMAP\nWebSymbolUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolUtils.kt\ncom/intellij/webSymbols/utils/WebSymbolUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,391:1\n1734#2,3:392\n1755#2,3:395\n1611#2,9:398\n1863#2:407\n1864#2:409\n1620#2:410\n1557#2:411\n1628#2,3:412\n1755#2,3:415\n1734#2,3:418\n1557#2:422\n1628#2,3:423\n1368#2:433\n1454#2,5:434\n543#2,6:439\n1#3:408\n1#3:421\n2284#4,7:426\n*S KotlinDebug\n*F\n+ 1 WebSymbolUtils.kt\ncom/intellij/webSymbols/utils/WebSymbolUtils\n*L\n48#1:392,3\n57#1:395,3\n137#1:398,9\n137#1:407\n137#1:409\n137#1:410\n175#1:411\n175#1:412,3\n182#1:415,3\n205#1:418,3\n265#1:422\n265#1:423,3\n378#1:433\n378#1:434,5\n381#1:439,6\n137#1:408\n294#1:426,7\n*E\n"})
public final class WebSymbolUtils {
    @NotNull
    public static final <T, P> T applyIfNotNull(@NotNull T $this$applyIfNotNull, @Nullable P param, @NotNull Function2<? super T, ? super P, ? extends T> block) {
        Intrinsics.checkNotNullParameter($this$applyIfNotNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$applyIfNotNull = false;
        return (T)(param != null ? block.invoke($this$applyIfNotNull, param) : $this$applyIfNotNull);
    }

    public static final boolean hasOnlyExtensions(@NotNull List<? extends WebSymbol> $this$hasOnlyExtensions) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$hasOnlyExtensions, (String)"<this>");
            Iterable $this$all$iv = $this$hasOnlyExtensions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    WebSymbol it = (WebSymbol)element$iv;
                    boolean bl2 = false;
                    if (it.isExtension()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final WebSymbol asSingleSymbol(@NotNull List<? extends WebSymbol> $this$asSingleSymbol, boolean force) {
        block7: {
            block5: {
                block8: {
                    block6: {
                        Intrinsics.checkNotNullParameter($this$asSingleSymbol, (String)"<this>");
                        if (!$this$asSingleSymbol.isEmpty()) break block6;
                        v0 = null;
                        break block7;
                    }
                    if ($this$asSingleSymbol.size() != 1) break block8;
                    v0 = $this$asSingleSymbol.get(0);
                    break block7;
                }
                first = $this$asSingleSymbol.get(0);
                if (force) ** GOTO lbl-1000
                $this$any$iv = $this$asSingleSymbol;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (WebSymbol)element$iv;
                        $i$a$-any-WebSymbolUtils$asSingleSymbol$1 = false;
                        if (!(Intrinsics.areEqual((Object)it.getNamespace(), (Object)first.getNamespace()) == false || Intrinsics.areEqual((Object)it.getKind(), (Object)first.getKind()) == false)) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = false;
                }
            }
            if (v1) {
                v2 = null;
            } else lbl-1000:
            // 2 sources

            {
                v2 = WebSymbolMatch.Companion.create$default(WebSymbolMatch.Companion, first.getName(), CollectionsKt.listOf((Object)WebSymbolNameSegment.Companion.create$default(WebSymbolNameSegment.Companion, 0, first.getName().length(), WebSymbolsImplUtilsKt.sortSymbolsByPriority$default($this$asSingleSymbol, false, 1, null), null, null, 0, null, null, null, null, 1016, null)), first.getNamespace(), first.getKind(), first.getOrigin(), null, null, 96, null);
            }
            v0 = v2;
        }
        return v0;
    }

    public static /* synthetic */ WebSymbol asSingleSymbol$default(List list2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return WebSymbolUtils.asSingleSymbol(list2, bl);
    }

    @NotNull
    public static final WebSymbol withMatchedName(@NotNull WebSymbol $this$withMatchedName, @NotNull String matchedName) {
        WebSymbol webSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$withMatchedName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matchedName, (String)"matchedName");
        if (!Intrinsics.areEqual((Object)matchedName, (Object)$this$withMatchedName.getName())) {
            WebSymbolNameSegment nameSegment = $this$withMatchedName instanceof WebSymbolMatch && ((WebSymbolMatch)$this$withMatchedName).getNameSegments().size() == 1 ? (WebSymbolNameSegment)WebSymbolsImplUtilsKt.withRange(((WebSymbolMatch)$this$withMatchedName).getNameSegments().get(0), 0, matchedName.length()) : WebSymbolNameSegment.Companion.create(0, matchedName.length(), $this$withMatchedName);
            webSymbol = WebSymbolMatch.Companion.create$default(WebSymbolMatch.Companion, matchedName, CollectionsKt.listOf((Object)nameSegment), $this$withMatchedName.getNamespace(), $this$withMatchedName.getKind(), $this$withMatchedName.getOrigin(), null, null, 96, null);
        } else {
            webSymbol = $this$withMatchedName;
        }
        return webSymbol;
    }

    @NotNull
    public static final WebSymbol withNavigationTarget(@NotNull WebSymbol $this$withNavigationTarget, @NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)$this$withNavigationTarget, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new WebSymbolDelegate<WebSymbol>($this$withNavigationTarget, target){
            final /* synthetic */ PsiElement $target;
            {
                this.$target = $target;
                super($receiver);
            }

            public Collection<NavigationTarget> getNavigationTargets(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return CollectionsKt.listOf((Object)SymbolNavigationService.getInstance().psiElementNavigationTarget(this.$target));
            }

            public Pointer<? extends WebSymbol> createPointer() {
                Pointer<? extends WebSymbol> symbolPtr = this.getDelegate().createPointer();
                SmartPsiElementPointer targetPtr = SmartPointersKt.createSmartPointer((PsiElement)this.$target);
                return () -> withNavigationTarget.1.createPointer$lambda$1(targetPtr, symbolPtr);
            }

            private static final WebSymbol createPointer$lambda$1(SmartPsiElementPointer $targetPtr, Pointer $symbolPtr) {
                WebSymbol webSymbol;
                PsiElement psiElement = $targetPtr.dereference();
                if (psiElement != null) {
                    WebSymbol webSymbol2;
                    PsiElement it = psiElement;
                    boolean bl = false;
                    WebSymbol webSymbol3 = webSymbol2 = (WebSymbol)$symbolPtr.dereference();
                    if (webSymbol3 != null) {
                        Intrinsics.checkNotNull((Object)webSymbol3);
                        webSymbol = WebSymbolUtils.withNavigationTarget(webSymbol2, it);
                    } else {
                        webSymbol = null;
                    }
                } else {
                    webSymbol = null;
                }
                return webSymbol;
            }
        };
    }

    @NotNull
    public static final Sequence<WebSymbol> unwrapMatchedSymbols(@NotNull WebSymbol $this$unwrapMatchedSymbols) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrapMatchedSymbols, (String)"<this>");
        return (Sequence)new Sequence<WebSymbol>($this$unwrapMatchedSymbols){
            final /* synthetic */ WebSymbol $this_unwrapMatchedSymbols$inlined;
            {
                this.$this_unwrapMatchedSymbols$inlined = webSymbol;
            }

            public Iterator<WebSymbol> iterator() {
                boolean bl = false;
                return new Iterator<WebSymbol>(this.$this_unwrapMatchedSymbols$inlined){
                    private WebSymbol next;
                    private final LinkedList<WebSymbol> fifo;
                    {
                        this.fifo = new LinkedList<E>();
                        this.fifo.addLast($receiver);
                        this.advance();
                    }

                    public final LinkedList<WebSymbol> getFifo() {
                        return this.fifo;
                    }

                    private final void advance() {
                        while (!((Collection)this.fifo).isEmpty()) {
                            WebSymbol symbol = this.fifo.removeFirst();
                            if (symbol instanceof WebSymbolMatch) {
                                Iterable $this$forEach$iv = ((WebSymbolMatch)symbol).getNameSegments();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    WebSymbolNameSegment it = (WebSymbolNameSegment)element$iv;
                                    boolean bl = false;
                                    this.fifo.addAll((Collection<WebSymbol>)it.getSymbols());
                                }
                                continue;
                            }
                            this.next = symbol;
                            return;
                        }
                        this.next = null;
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public WebSymbol next() {
                        WebSymbol webSymbol;
                        WebSymbol webSymbol2 = this.next;
                        Intrinsics.checkNotNull((Object)webSymbol2);
                        WebSymbol it = webSymbol = webSymbol2;
                        boolean bl = false;
                        this.advance();
                        return webSymbol;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public static final WebSymbolNameSegment withSymbols(@NotNull WebSymbolNameSegment $this$withSymbols, @NotNull List<? extends WebSymbol> symbols) {
        Intrinsics.checkNotNullParameter((Object)$this$withSymbols, (String)"<this>");
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        return ((WebSymbolNameSegmentImpl)$this$withSymbols).withSymbols$intellij_platform_webSymbols(symbols);
    }

    @NotNull
    public static final WebSymbolMatch withSegments(@NotNull WebSymbolMatch $this$withSegments, @NotNull List<? extends WebSymbolNameSegment> segments) {
        Intrinsics.checkNotNullParameter((Object)$this$withSegments, (String)"<this>");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        return ((WebSymbolMatchImpl)$this$withSegments).withSegments$intellij_platform_webSymbols(segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final List<WebSymbol> match(@NotNull WebSymbol $this$match, @NotNull String nameToMatch, @NotNull WebSymbolsNameMatchQueryParams params, @NotNull Stack<WebSymbolsScope> context) {
        Intrinsics.checkNotNullParameter((Object)$this$match, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nameToMatch, (String)"nameToMatch");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        WebSymbolsPattern webSymbolsPattern = $this$match.getPattern();
        if (webSymbolsPattern != null) {
            WebSymbolsPattern pattern = webSymbolsPattern;
            boolean bl = false;
            context.push((Object)$this$match);
            try {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = pattern.match$intellij_platform_webSymbols($this$match, context, nameToMatch, params);
                boolean $i$f$mapNotNull = false;
                void var9_10 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    WebSymbolMatch it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    MatchResult matchResult = (MatchResult)element$iv$iv;
                    boolean bl3 = false;
                    WebSymbolNameSegment webSymbolNameSegment = (WebSymbolNameSegment)CollectionsKt.lastOrNull(matchResult.getSegments());
                    if (((webSymbolNameSegment != null ? webSymbolNameSegment.getEnd() : 0) < nameToMatch.length() ? null : WebSymbolMatch.Companion.create$default(WebSymbolMatch.Companion, nameToMatch, matchResult.getSegments(), $this$match.getNamespace(), $this$match.getKind(), $this$match.getOrigin(), null, null, 96, null)) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv;
                return iterable;
            }
            finally {
                context.pop();
            }
        }
        return WebSymbolUtils.nameMatches($this$match, nameToMatch, params.getQueryExecutor()) ? CollectionsKt.listOf((Object)WebSymbolUtils.withMatchedName($this$match, nameToMatch)) : CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final List<WebSymbolCodeCompletionItem> toCodeCompletionItems(@NotNull WebSymbol $this$toCodeCompletionItems, @NotNull String name, @NotNull WebSymbolsCodeCompletionQueryParams params, @NotNull Stack<WebSymbolsScope> context) {
        Object object;
        block8: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            block7: {
                List<WebSymbolCodeCompletionItem> list2;
                Intrinsics.checkNotNullParameter((Object)$this$toCodeCompletionItems, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Intrinsics.checkNotNullParameter(context, (String)"context");
                object = $this$toCodeCompletionItems.getPattern();
                if (object == null) break block7;
                WebSymbolsPattern pattern = object;
                boolean bl = false;
                context.push((Object)$this$toCodeCompletionItems);
                try {
                    list2 = PatternImplUtilsKt.applyIcons(pattern.complete$intellij_platform_webSymbols($this$toCodeCompletionItems, context, name, params), $this$toCodeCompletionItems);
                }
                finally {
                    context.pop();
                }
                List<WebSymbolCodeCompletionItem> list3 = list2;
                object = list3;
                if (list3 != null) break block8;
            }
            Iterable iterable = params.getQueryExecutor().getNamesProvider().getNames(new WebSymbolQualifiedName($this$toCodeCompletionItems.getNamespace(), $this$toCodeCompletionItems.getKind(), $this$toCodeCompletionItems.getName()), WebSymbolNamesProvider.Target.CODE_COMPLETION_VARIANTS);
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(WebSymbolCodeCompletionItem.Companion.create$default(WebSymbolCodeCompletionItem.Companion, (String)it, 0, $this$toCodeCompletionItems, null, 8, null));
            }
            object = (List)destination$iv$iv;
        }
        return object;
    }

    public static final boolean nameMatches(@NotNull WebSymbol $this$nameMatches, @NotNull String name, @NotNull WebSymbolsQueryExecutor queryExecutor) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$nameMatches, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            List<String> queryNames = queryExecutor.getNamesProvider().getNames(new WebSymbolQualifiedName($this$nameMatches.getNamespace(), $this$nameMatches.getKind(), name), WebSymbolNamesProvider.Target.NAMES_QUERY);
            Set symbolNames = CollectionsKt.toSet((Iterable)queryExecutor.getNamesProvider().getNames(new WebSymbolQualifiedName($this$nameMatches.getNamespace(), $this$nameMatches.getKind(), $this$nameMatches.getName()), WebSymbolNamesProvider.Target.NAMES_MAP_STORAGE));
            Iterable $this$any$iv = queryNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!symbolNames.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final WebSymbolQualifiedName getQualifiedName(@NotNull WebSymbol $this$qualifiedName) {
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedName, (String)"<this>");
        return new WebSymbolQualifiedName($this$qualifiedName.getNamespace(), $this$qualifiedName.getKind(), $this$qualifiedName.getName());
    }

    @NotNull
    public static final WebSymbolQualifiedKind getQualifiedKind(@NotNull WebSymbol $this$qualifiedKind) {
        Intrinsics.checkNotNullParameter((Object)$this$qualifiedKind, (String)"<this>");
        return new WebSymbolQualifiedKind($this$qualifiedKind.getNamespace(), $this$qualifiedKind.getKind());
    }

    @Nullable
    public static final WebSymbolReferenceProblem.ProblemKind getProblemKind(@NotNull WebSymbolNameSegment $this$getProblemKind) {
        Intrinsics.checkNotNullParameter((Object)$this$getProblemKind, (String)"<this>");
        WebSymbolNameSegment.MatchProblem matchProblem = $this$getProblemKind.getProblem();
        return switch (matchProblem == null ? -1 : WhenMappings.$EnumSwitchMapping$0[matchProblem.ordinal()]) {
            case 1 -> WebSymbolReferenceProblem.ProblemKind.MissingRequiredPart;
            case 2 -> {
                if ($this$getProblemKind.getStart() == $this$getProblemKind.getEnd()) {
                    yield WebSymbolReferenceProblem.ProblemKind.MissingRequiredPart;
                }
                yield WebSymbolReferenceProblem.ProblemKind.UnknownSymbol;
            }
            case 3 -> WebSymbolReferenceProblem.ProblemKind.DuplicatedPart;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getCompleteMatch(@NotNull WebSymbol $this$completeMatch) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$completeMatch, (String)"<this>");
        if (!($this$completeMatch instanceof WebSymbolMatch)) return true;
        Iterable $this$all$iv = ((WebSymbolMatch)$this$completeMatch).getNameSegments();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                boolean bl2;
                WebSymbolNameSegment segment = (WebSymbolNameSegment)element$iv;
                boolean bl3 = false;
                if (segment.getProblem() != null) return false;
                Iterable $this$all$iv2 = segment.getSymbols();
                boolean $i$f$all2 = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv2 : $this$all$iv2) {
                        WebSymbol it = (WebSymbol)element$iv2;
                        boolean bl4 = false;
                        if (WebSymbolUtils.getCompleteMatch(it)) continue;
                        return false;
                    }
                    bl2 = true;
                }
                if (!bl2) return false;
                boolean bl5 = true;
                if (bl5) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        WebSymbolNameSegment webSymbolNameSegment = (WebSymbolNameSegment)CollectionsKt.lastOrNull(((WebSymbolMatch)$this$completeMatch).getNameSegments());
        if ((webSymbolNameSegment != null ? webSymbolNameSegment.getEnd() : 0) != WebSymbolUtils.getMatchedNameOrName($this$completeMatch).length()) return false;
        return true;
    }

    @NotNull
    public static final List<WebSymbolNameSegment> getNameSegments(@NotNull WebSymbol $this$nameSegments) {
        Intrinsics.checkNotNullParameter((Object)$this$nameSegments, (String)"<this>");
        Object object = $this$nameSegments instanceof CompositeWebSymbol ? (CompositeWebSymbol)$this$nameSegments : null;
        if (object == null || (object = object.getNameSegments()) == null) {
            WebSymbolsPattern webSymbolsPattern = $this$nameSegments.getPattern();
            if (webSymbolsPattern != null) {
                WebSymbolsPattern it = webSymbolsPattern;
                boolean bl = false;
                object = CollectionsKt.listOf((Object)WebSymbolNameSegment.Companion.create(0, 0, $this$nameSegments));
            } else {
                object = CollectionsKt.listOf((Object)WebSymbolNameSegment.Companion.create($this$nameSegments));
            }
        }
        return object;
    }

    @NotNull
    public static final Sequence<WebSymbolNameSegment> getNameSegmentsWithProblems(@NotNull WebSymbol $this$nameSegmentsWithProblems) {
        Intrinsics.checkNotNullParameter((Object)$this$nameSegmentsWithProblems, (String)"<this>");
        return (Sequence)new Sequence<WebSymbolNameSegment>($this$nameSegmentsWithProblems){
            final /* synthetic */ WebSymbol $this_nameSegmentsWithProblems$inlined;
            {
                this.$this_nameSegmentsWithProblems$inlined = webSymbol;
            }

            public Iterator<WebSymbolNameSegment> iterator() {
                boolean bl = false;
                return new Iterator<WebSymbolNameSegment>(this.$this_nameSegmentsWithProblems$inlined){
                    private WebSymbolNameSegment next;
                    private final LinkedList<WebSymbolNameSegment> fifo;
                    private final Set<WebSymbol> visitedSymbols;
                    {
                        this.fifo = new LinkedList<E>();
                        this.visitedSymbols = new LinkedHashSet<E>();
                        this.addNameSegmentsToQueue($receiver);
                        this.advance();
                    }

                    public final LinkedList<WebSymbolNameSegment> getFifo() {
                        return this.fifo;
                    }

                    public final Set<WebSymbol> getVisitedSymbols() {
                        return this.visitedSymbols;
                    }

                    private final void addNameSegmentsToQueue(WebSymbol symbol) {
                        if (symbol instanceof CompositeWebSymbol && this.visitedSymbols.add(symbol)) {
                            this.fifo.addAll((Collection<WebSymbolNameSegment>)((CompositeWebSymbol)symbol).getNameSegments());
                        }
                    }

                    private final void advance() {
                        while (!((Collection)this.fifo).isEmpty()) {
                            WebSymbolNameSegment segment = this.fifo.removeFirst();
                            Iterable $this$forEach$iv = segment.getSymbols();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                WebSymbol it = (WebSymbol)element$iv;
                                boolean bl = false;
                                this.addNameSegmentsToQueue(it);
                            }
                            if (segment.getProblem() == null) continue;
                            this.next = segment;
                            return;
                        }
                        this.next = null;
                    }

                    public boolean hasNext() {
                        return this.next != null;
                    }

                    public WebSymbolNameSegment next() {
                        WebSymbolNameSegment webSymbolNameSegment;
                        WebSymbolNameSegment webSymbolNameSegment2 = this.next;
                        Intrinsics.checkNotNull((Object)webSymbolNameSegment2);
                        WebSymbolNameSegment it = webSymbolNameSegment = webSymbolNameSegment2;
                        boolean bl = false;
                        this.advance();
                        return webSymbolNameSegment;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public static final String getMatchedNameOrName(@NotNull WebSymbol $this$matchedNameOrName) {
        Intrinsics.checkNotNullParameter((Object)$this$matchedNameOrName, (String)"<this>");
        Object object = $this$matchedNameOrName instanceof WebSymbolMatch ? (WebSymbolMatch)$this$matchedNameOrName : null;
        if (object == null || (object = object.getMatchedName()) == null) {
            object = $this$matchedNameOrName.getName();
        }
        return object;
    }

    public static final boolean getHideFromCompletion(@NotNull WebSymbol $this$hideFromCompletion) {
        Intrinsics.checkNotNullParameter((Object)$this$hideFromCompletion, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$hideFromCompletion.getProperties().get("hide-from-completion"), (Object)true);
    }

    public static final boolean isCritical(@Nullable WebSymbolNameSegment.MatchProblem $this$isCritical) {
        return $this$isCritical == WebSymbolNameSegment.MatchProblem.MISSING_REQUIRED_PART || $this$isCritical == WebSymbolNameSegment.MatchProblem.UNKNOWN_SYMBOL;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<WebSymbolNameSegment> withOffset(@NotNull List<? extends WebSymbolNameSegment> $this$withOffset, int offset) {
        List list2;
        Intrinsics.checkNotNullParameter($this$withOffset, (String)"<this>");
        if (offset != 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$withOffset;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WebSymbolNameSegment webSymbolNameSegment = (WebSymbolNameSegment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(WebSymbolsImplUtilsKt.withOffset((WebSymbolNameSegment)it, offset));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = $this$withOffset;
        }
        return list2;
    }

    @NotNull
    public static final WebSymbolApiStatus coalesceWith(@Nullable WebSymbolApiStatus $this$coalesceWith, @Nullable WebSymbolApiStatus other) {
        WebSymbolApiStatus webSymbolApiStatus;
        WebSymbolApiStatus webSymbolApiStatus2 = $this$coalesceWith;
        if (webSymbolApiStatus2 == null) {
            webSymbolApiStatus = other;
            if (webSymbolApiStatus == null) {
                webSymbolApiStatus = WebSymbolApiStatus.Stable;
            }
        } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Obsolete) {
            webSymbolApiStatus = $this$coalesceWith;
        } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Deprecated) {
            webSymbolApiStatus = other instanceof WebSymbolApiStatus.Obsolete ? other : $this$coalesceWith;
        } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Experimental) {
            WebSymbolApiStatus webSymbolApiStatus3 = other;
            webSymbolApiStatus = webSymbolApiStatus3 instanceof WebSymbolApiStatus.Obsolete || webSymbolApiStatus3 instanceof WebSymbolApiStatus.Deprecated ? other : $this$coalesceWith;
        } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Stable) {
            WebSymbolApiStatus webSymbolApiStatus4 = other;
            webSymbolApiStatus = webSymbolApiStatus4 instanceof WebSymbolApiStatus.Obsolete || webSymbolApiStatus4 instanceof WebSymbolApiStatus.Deprecated || webSymbolApiStatus4 instanceof WebSymbolApiStatus.Experimental ? other : $this$coalesceWith;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return webSymbolApiStatus;
    }

    @NotNull
    public static final <T> WebSymbolApiStatus coalesceApiStatus(@Nullable Iterable<? extends T> collection, @NotNull Function1<? super T, ? extends WebSymbolApiStatus> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Iterable<? extends T> iterable = collection;
        return WebSymbolUtils.coalesceApiStatus(iterable != null ? CollectionsKt.asSequence(iterable) : null, mapper);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> WebSymbolApiStatus coalesceApiStatus(@Nullable Sequence<? extends T> sequence, @NotNull Function1<? super T, ? extends WebSymbolApiStatus> mapper) {
        Object object;
        block7: {
            block6: {
                Object v1;
                Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
                object = sequence;
                if (object == null || (object = SequencesKt.map(object, mapper)) == null) break block6;
                Object $this$reduceOrNull$iv = object;
                boolean $i$f$reduceOrNull = false;
                Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void b;
                        WebSymbolApiStatus webSymbolApiStatus = (WebSymbolApiStatus)iterator$iv.next();
                        WebSymbolApiStatus a = (WebSymbolApiStatus)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = WebSymbolUtils.coalesceWith(a, (WebSymbolApiStatus)b);
                    }
                    v1 = accumulator$iv;
                }
                if ((object = (WebSymbolApiStatus)v1) != null) break block7;
            }
            object = WebSymbolApiStatus.Stable;
        }
        return object;
    }

    @Nullable
    public static final WebSymbolHtmlAttributeValue merge(@NotNull Sequence<? extends WebSymbolHtmlAttributeValue> $this$merge) {
        Intrinsics.checkNotNullParameter($this$merge, (String)"<this>");
        WebSymbolHtmlAttributeValue.Kind kind = null;
        WebSymbolHtmlAttributeValue.Type type = null;
        Boolean required = null;
        String string2 = null;
        Object langType = null;
        for (WebSymbolHtmlAttributeValue value : $this$merge) {
            if (value == null) continue;
            if (kind == null || kind == WebSymbolHtmlAttributeValue.Kind.PLAIN) {
                kind = value.getKind();
            }
            if (type == null) {
                type = value.getType();
            }
            if (required == null) {
                required = value.isRequired();
            }
            if (string2 == null) {
                string2 = value.getDefault();
            }
            if (langType != null) continue;
            langType = value.getLangType();
        }
        return kind != null || type != null || required != null || langType != null || string2 != null ? WebSymbolHtmlAttributeValue.Companion.create(kind, type, required, string2, langType) : null;
    }

    @NotNull
    public static final Navigatable createPsiRangeNavigationItem(@NotNull NavigationTarget $this$createPsiRangeNavigationItem, @NotNull PsiElement element, int offsetWithinElement) {
        Intrinsics.checkNotNullParameter((Object)$this$createPsiRangeNavigationItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            Navigatable navigatable = EmptyNavigatable.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"INSTANCE");
            return navigatable;
        }
        VirtualFile vf = virtualFile;
        TargetPresentation targetPresentation = $this$createPsiRangeNavigationItem.computePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"computePresentation(...)");
        TargetPresentation targetPresentation2 = targetPresentation;
        OpenFileDescriptor descriptor = new OpenFileDescriptor(element.getProject(), vf, element.getTextRange().getStartOffset() + offsetWithinElement);
        return (Navigatable)new NavigationItem(descriptor, targetPresentation2){
            final /* synthetic */ OpenFileDescriptor $descriptor;
            final /* synthetic */ TargetPresentation $targetPresentation;
            {
                this.$descriptor = $descriptor;
                this.$targetPresentation = $targetPresentation;
            }

            public void navigate(boolean requestFocus) {
                this.$descriptor.navigate(requestFocus);
            }

            public boolean canNavigate() {
                return this.$descriptor.canNavigate();
            }

            public boolean canNavigateToSource() {
                return this.$descriptor.canNavigateToSource();
            }

            public String getName() {
                return this.$targetPresentation.getPresentableText();
            }

            public ItemPresentation getPresentation() {
                return this;
            }

            public String getPresentableText() {
                return this.$targetPresentation.getPresentableText();
            }

            public Icon getIcon(boolean unused) {
                return this.$targetPresentation.getIcon();
            }

            public String getLocationString() {
                String string2;
                String container = this.$targetPresentation.getContainerText();
                String location = this.$targetPresentation.getLocationText();
                if (container != null || location != null) {
                    Object[] objectArray = new String[]{container, location};
                    string2 = SequencesKt.joinToString$default((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null);
                } else {
                    string2 = null;
                }
                return string2;
            }

            public String toString() {
                return this.$descriptor.getFile().getName() + " [" + this.$descriptor.getOffset() + "]";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<WebSymbolCodeCompletionItem> getDefaultCodeCompletions(@NotNull WebSymbolsScope $this$getDefaultCodeCompletions, @NotNull WebSymbolQualifiedName qualifiedName, @NotNull WebSymbolsCodeCompletionQueryParams params, @NotNull Stack<WebSymbolsScope> scope) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultCodeCompletions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        Iterable iterable = $this$getDefaultCodeCompletions.getSymbols(qualifiedName.getQualifiedKind(), WebSymbolsListSymbolsQueryParams.Companion.create(params.getQueryExecutor(), false, params.getVirtualSymbols()), scope);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            WebSymbolsScope it = (WebSymbolsScope)element$iv$iv;
            boolean bl = false;
            Object object = it instanceof WebSymbol ? (WebSymbol)it : null;
            if (object == null || (object = WebSymbolUtils.toCodeCompletionItems((WebSymbol)object, qualifiedName.getName(), params, scope)) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final WebSymbol getLastWebSymbol(@NotNull List<? extends WebSymbolsScope> $this$lastWebSymbol) {
        WebSymbolsScope webSymbolsScope;
        block1: {
            Intrinsics.checkNotNullParameter($this$lastWebSymbol, (String)"<this>");
            List<? extends WebSymbolsScope> $this$lastOrNull$iv = $this$lastWebSymbol;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends WebSymbolsScope> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                WebSymbolsScope element$iv;
                WebSymbolsScope it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it instanceof WebSymbol)) continue;
                webSymbolsScope = element$iv;
                break block1;
            }
            webSymbolsScope = null;
        }
        WebSymbolsScope webSymbolsScope2 = webSymbolsScope;
        return webSymbolsScope2 instanceof WebSymbol ? (WebSymbol)webSymbolsScope2 : null;
    }

    @NotNull
    public static final ModificationTracker createModificationTracker(@NotNull List<? extends Pointer<? extends ModificationTracker>> trackersPointers) {
        Intrinsics.checkNotNullParameter(trackersPointers, (String)"trackersPointers");
        return () -> WebSymbolUtils.createModificationTracker$lambda$17(trackersPointers);
    }

    /*
     * WARNING - void declaration
     */
    private static final long createModificationTracker$lambda$17(List $trackersPointers) {
        long modCount = 0L;
        for (Pointer tracker : $trackersPointers) {
            void it;
            long l;
            ModificationTracker modificationTracker = (ModificationTracker)tracker.dereference();
            if (modificationTracker == null) {
                return -1L;
            }
            long l2 = l = modificationTracker.getModificationCount();
            long l3 = modCount;
            boolean bl = false;
            if (it < 0L) {
                return -1L;
            }
            Unit unit = Unit.INSTANCE;
            modCount = l3 + l;
        }
        return modCount;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WebSymbolNameSegment.MatchProblem.values().length];
            try {
                nArray[WebSymbolNameSegment.MatchProblem.MISSING_REQUIRED_PART.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSymbolNameSegment.MatchProblem.UNKNOWN_SYMBOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WebSymbolNameSegment.MatchProblem.DUPLICATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

