/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.languagescope.common;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.clones.DuplicateInspection;
import com.jetbrains.clones.configuration.DuplicateInspectionConfiguration;
import com.jetbrains.clones.configuration.DuplicatesBundle;
import com.jetbrains.clones.core.DuplicateAnalyzer;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.structures.TextClone;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J'\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/clones/languagescope/common/HideDuplicatesFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "duplicateScope", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "textClone", "Lcom/jetbrains/clones/structures/TextClone;", "<init>", "(Lcom/jetbrains/clones/languagescope/DuplicateScope;Lcom/jetbrains/clones/structures/TextClone;)V", "getDuplicateScope", "()Lcom/jetbrains/clones/languagescope/DuplicateScope;", "getTextClone", "()Lcom/jetbrains/clones/structures/TextClone;", "getFamilyName", "", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "setOption", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "newMinSize", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;I)Ljava/lang/Integer;", "intellij.platform.duplicatesDetector"})
public final class HideDuplicatesFix
implements LocalQuickFix,
LowPriorityAction {
    @NotNull
    private final DuplicateScope duplicateScope;
    @NotNull
    private final TextClone textClone;

    public HideDuplicatesFix(@NotNull DuplicateScope duplicateScope, @NotNull TextClone textClone) {
        Intrinsics.checkNotNullParameter((Object)duplicateScope, (String)"duplicateScope");
        Intrinsics.checkNotNullParameter((Object)textClone, (String)"textClone");
        this.duplicateScope = duplicateScope;
        this.textClone = textClone;
    }

    @NotNull
    public final DuplicateScope getDuplicateScope() {
        return this.duplicateScope;
    }

    @NotNull
    public final TextClone getTextClone() {
        return this.textClone;
    }

    @NotNull
    public String getFamilyName() {
        return DuplicatesBundle.INSTANCE.getMessage("duplicate.inspection.fix.hide.family", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        VirtualFile vFile = descriptor.getPsiElement().getContainingFile().getVirtualFile();
        DuplicateAnalyzer duplicateAnalyzer = new DuplicateAnalyzer(this.duplicateScope);
        PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        int newMinSize = duplicateAnalyzer.getFragmentWeight$intellij_platform_duplicatesDetector(psiFile, this.textClone.getMain().getRange()) + 1;
        Intrinsics.checkNotNull((Object)vFile);
        Integer n = this.setOption(project2, vFile, newMinSize);
        if (n == null) {
            return;
        }
        int oldMinSize = n;
        VirtualFile[] virtualFileArray = new VirtualFile[]{vFile};
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        UndoManager.getInstance((Project)project2).undoableActionPerformed((UndoableAction)new BasicUndoableAction(this, project2, vFile, oldMinSize, newMinSize, virtualFileArray2){
            final /* synthetic */ HideDuplicatesFix this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $vFile;
            final /* synthetic */ int $oldMinSize;
            final /* synthetic */ int $newMinSize;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$vFile = $vFile;
                this.$oldMinSize = $oldMinSize;
                this.$newMinSize = $newMinSize;
                super($super_call_param$1);
            }

            public void undo() {
                VirtualFile virtualFile = this.$vFile;
                Intrinsics.checkNotNull((Object)virtualFile);
                HideDuplicatesFix.access$setOption(this.this$0, this.$project, virtualFile, this.$oldMinSize);
            }

            public void redo() {
                VirtualFile virtualFile = this.$vFile;
                Intrinsics.checkNotNull((Object)virtualFile);
                HideDuplicatesFix.access$setOption(this.this$0, this.$project, virtualFile, this.$newMinSize);
            }
        });
    }

    private final Integer setOption(Project project2, VirtualFile file, int newMinSize) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Ref.ObjectRef oldMinSize = new Ref.ObjectRef();
        Key key2 = Key.create((String)"DuplicatedCode");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        Key inspectionKey = key2;
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)project2).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl profile = inspectionProfileImpl;
        profile.modifyToolSettings(inspectionKey, (PsiElement)psiFile2, arg_0 -> HideDuplicatesFix.setOption$lambda$1(arg_0 -> HideDuplicatesFix.setOption$lambda$0(this, oldMinSize, newMinSize, arg_0), arg_0));
        return (Integer)oldMinSize.element;
    }

    private static final Unit setOption$lambda$0(HideDuplicatesFix this$0, Ref.ObjectRef $oldMinSize, int $newMinSize, DuplicateInspection duplicateInspection) {
        block0: {
            DuplicateInspectionConfiguration languageSettings;
            DuplicateInspectionConfiguration duplicateInspectionConfiguration = languageSettings = duplicateInspection.getState().findConfiguration(this$0.duplicateScope);
            $oldMinSize.element = duplicateInspectionConfiguration != null ? Integer.valueOf(duplicateInspectionConfiguration.getMinSize()) : null;
            DuplicateInspectionConfiguration duplicateInspectionConfiguration2 = languageSettings;
            if (duplicateInspectionConfiguration2 == null) break block0;
            duplicateInspectionConfiguration2.setMinSize($newMinSize);
        }
        return Unit.INSTANCE;
    }

    private static final void setOption$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Integer access$setOption(HideDuplicatesFix $this, Project project2, VirtualFile file, int newMinSize) {
        return $this.setOption(project2, file, newMinSize);
    }
}

