/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.actions;

import com.intellij.analysis.pwa.settings.PwaSettings;
import com.intellij.analysis.pwa.utils.PwaBundle;
import com.intellij.analysis.pwa.view.PwaTooltipService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.idea.AppMode;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/analysis/pwa/actions/PwaToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "<init>", "()V", "ENABLED_KEY", "Lcom/intellij/openapi/util/Key;", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "setSelected", "state", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "updateCustomComponent", "component", "getButtonBackgroundColor", "Lcom/intellij/ui/JBColor;", "PwaActionButton", "intellij.pwa.core"})
public final class PwaToggleAction
extends ToggleAction
implements CustomComponentAction {
    @NotNull
    private final Key<Boolean> ENABLED_KEY = new Key("pwa.toggle.action.analysis.on");

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(!AppMode.isRemoteDevHost() && !PowerSaveMode.isEnabled() && Registry.Companion.is("pwa.enabled"));
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        PwaSettings settings = PwaSettings.Companion.getInstance(project2);
        boolean enabled = settings.isEnabled();
        e.getPresentation().putClientProperty(this.ENABLED_KEY, (Object)enabled);
        String text = enabled ? PwaBundle.Companion.message("action.disable.project.wide.analysis.text", new Object[0]) : PwaBundle.Companion.message("action.com.intellij.analysis.pwa.actions.PwaToggleAction.text", new Object[0]);
        e.getPresentation().setText(text);
        e.getPresentation().setIcon(enabled ? AllIcons.Actions.ProjectWideAnalysisOn : AllIcons.Actions.ProjectWideAnalysisOff);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        PwaSettings settings = PwaSettings.Companion.getInstance(project2);
        return settings.isEnabled();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        PwaSettings settings = PwaSettings.Companion.getInstance(project2);
        settings.setEnabled(project2, state);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return (JComponent)((Object)new PwaActionButton((AnAction)this, presentation, place));
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        PwaActionButton pwaActionButton;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        PwaActionButton $this$updateCustomComponent_u24lambda_u240 = pwaActionButton = (PwaActionButton)((Object)component);
        boolean bl = false;
        $this$updateCustomComponent_u24lambda_u240.setBackground(presentation.isEnabled() ? (Color)this.getButtonBackgroundColor() : null);
    }

    private final JBColor getButtonBackgroundColor() {
        JBColor jBColor = JBColor.namedColor((String)"ProblemsView.projectAnalysisButtonBackground", (int)861513833, (int)860462164);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        return jBColor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/analysis/pwa/actions/PwaToggleAction$PwaActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "<init>", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;)V", "intellij.pwa.core"})
    private static final class PwaActionButton
    extends ActionButton {
        public PwaActionButton(@NotNull AnAction action, @NotNull Presentation presentation, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            super(action, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Project project = (Project)ActionToolbar.getDataContextFor((Component)((Component)((Object)this))).getData(CommonDataKeys.PROJECT);
                    if (e.getButton() == 1 && project != null) {
                        ComponentManager $this$service$iv = (ComponentManager)project;
                        boolean $i$f$service = false;
                        Class<PwaTooltipService> serviceClass$iv = PwaTooltipService.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        PwaTooltipService tooltipService = (PwaTooltipService)object;
                        Component component = e.getComponent();
                        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                        tooltipService.showTooltip((JComponent)component);
                    }
                }
            });
        }
    }
}

