/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.actions.debug;

import com.intellij.analysis.pwa.actions.debug.AnalyseFileAndConvertProblems;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaErrorStorage;
import com.intellij.analysis.pwa.analyser.PwaFileWithProblems;
import com.intellij.analysis.pwa.analyser.PwaProblem;
import com.intellij.analysis.pwa.analyser.PwaProblemsProvider;
import com.intellij.analysis.pwa.analyser.core.PwaProjectScanner;
import com.intellij.analysis.pwa.analyser.core.PwaProviderInfo;
import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.analysis.pwa.support.PwaFileFilterKt;
import com.intellij.analysis.pwa.support.PwaSupportProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/pwa/actions/debug/PwaCheckErrorsConsistencyAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaCheckErrorsConsistencyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaCheckErrorsConsistencyAction.kt\ncom/intellij/analysis/pwa/actions/debug/PwaCheckErrorsConsistencyAction\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,139:1\n46#2,6:140\n*S KotlinDebug\n*F\n+ 1 PwaCheckErrorsConsistencyAction.kt\ncom/intellij/analysis/pwa/actions/debug/PwaCheckErrorsConsistencyAction\n*L\n109#1:140,6\n*E\n"})
public final class PwaCheckErrorsConsistencyAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int CHUNK_SIZE = 100;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        PwaErrorStorage storage = PwaErrorStorage.Companion.getInstance(project2);
        Map<VirtualFile, Set<PwaProblem>> storageFileToProblems = storage.getStorageCopy();
        String string = "Checking file problems consistency";
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, (String)title$iv, cancellable$iv, project2, storageFileToProblems){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Map $storageFileToProblems$inlined;
            {
                this.$project$inlined = project;
                this.$storageFileToProblems$inlined = map;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                indicator2.setText("Scanning files");
                List<VirtualFile> diffFiles = PwaCheckErrorsConsistencyAction.Companion.findErrorInconsistency(this.$project$inlined, indicator2, this.$storageFileToProblems$inlined);
                JBList fileList = new JBList((ListModel)new CollectionListModel(CollectionsKt.toMutableList((Collection)diffFiles)));
                JBScrollPane pane = new JBScrollPane((Component)fileList);
                fileList.setCellRenderer((ListCellRenderer)new FileListRenderer());
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(pane){
                    final /* synthetic */ JBScrollPane $pane;
                    {
                        this.$pane = $pane;
                    }

                    public final void invoke() {
                        ComponentsKt.dialog$default((String)"Inconsistent files", (JComponent)((JComponent)this.$pane), (boolean)false, null, (boolean)false, null, null, null, null, null, null, (int)2044, null).show();
                    }
                }), (int)1, null);
            }
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eJV\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00130\u0012j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0013`\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0007H\u0002JB\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/analysis/pwa/actions/debug/PwaCheckErrorsConsistencyAction$Companion;", "", "<init>", "()V", "CHUNK_SIZE", "", "findErrorInconsistency", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "storageFileToProblems", "", "", "Lcom/intellij/analysis/pwa/analyser/PwaProblem;", "analyseFromScratch", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "projectFiles", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "providers", "Lcom/intellij/analysis/pwa/analyser/core/PwaProviderInfo;", "findDiff", "actualFileToProblems", "intellij.pwa.core"})
    @SourceDebugExtension(value={"SMAP\nPwaCheckErrorsConsistencyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaCheckErrorsConsistencyAction.kt\ncom/intellij/analysis/pwa/actions/debug/PwaCheckErrorsConsistencyAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1557#2:140\n1628#2,3:141\n1557#2:144\n1628#2,3:145\n1755#2,3:148\n*S KotlinDebug\n*F\n+ 1 PwaCheckErrorsConsistencyAction.kt\ncom/intellij/analysis/pwa/actions/debug/PwaCheckErrorsConsistencyAction$Companion\n*L\n40#1:140\n40#1:141,3\n42#1:144\n42#1:145,3\n68#1:148,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> findErrorInconsistency(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Map<VirtualFile, ? extends Set<PwaProblem>> storageFileToProblems) {
            Collection<PwaFileFilter> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(storageFileToProblems, (String)"storageFileToProblems");
            Iterable iterable = PwaSupportProvider.Companion.getEP().getExtensionList();
            boolean $i$f$map22 = false;
            void var7_7 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                PwaSupportProvider pwaSupportProvider = (PwaSupportProvider)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(new PwaProviderInfo(it.createFilter(project), it.createStateExtractor(project), it.getId(), it.getVersion()));
            }
            List providers = (List)destination$iv$iv;
            Iterable $i$f$map22 = providers;
            boolean bl = false;
            Project project2 = project;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PwaProviderInfo bl2 = (PwaProviderInfo)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.getFilter());
            }
            collection = (List)destination$iv$iv2;
            List list = collection;
            boolean bl4 = bl;
            Project project3 = project2;
            PwaProjectScanner scanner = new PwaProjectScanner(project3, bl4, list);
            FileIdSet projectFiles = new FileIdSet(scanner.findFilesForAnalysis().getFilesForAnalysis());
            HashMap<VirtualFile, Set<PwaProblem>> actualFileToProblems = this.analyseFromScratch(indicator, project, projectFiles, providers);
            return this.findDiff(storageFileToProblems, (Map<VirtualFile, ? extends Set<PwaProblem>>)actualFileToProblems);
        }

        private final HashMap<VirtualFile, Set<PwaProblem>> analyseFromScratch(ProgressIndicator indicator, Project project, FileIdSet projectFiles, List<PwaProviderInfo> providers) {
            indicator.setText("Analysing files from scratch");
            ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
            ExecutorService executorService2 = executorService;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            PsiManager psiManager2 = psiManager;
            HashMap<VirtualFile, Set<PwaProblem>> actualFileToProblems = new HashMap<VirtualFile, Set<PwaProblem>>();
            PwaProblemsProvider problemsProvider = new PwaProblemsProvider(project);
            indicator.setIndeterminate(false);
            int processed = 0;
            for (List chunk : CollectionsKt.chunked((Iterable)((Iterable)projectFiles.getStorage()), (int)100)) {
                indicator.setFraction((double)processed / (double)projectFiles.getSize());
                indicator.setText2(processed + " / " + projectFiles.getSize());
                ArrayList filesWithProblemsFutures = new ArrayList(100);
                for (Integer fileId : chunk) {
                    VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                    Intrinsics.checkNotNull((Object)fileId);
                    VirtualFile file = virtualFileManager.findFileById(fileId.intValue());
                    ActionsKt.runReadAction(() -> Companion.analyseFromScratch$lambda$3(psiManager2, file, providers, filesWithProblemsFutures, executorService2, problemsProvider));
                }
                Iterator iterator = filesWithProblemsFutures.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    PwaFileWithProblems fileWithProblems;
                    Object e = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Future fileWithProblemsFuture = (Future)e;
                    if ((PwaFileWithProblems)fileWithProblemsFuture.get() == null) continue;
                    if (!((Collection)fileWithProblems.getProblems()).isEmpty()) {
                        actualFileToProblems.computeIfAbsent(fileWithProblems.getFile(), arg_0 -> Companion.analyseFromScratch$lambda$5(Companion::analyseFromScratch$lambda$4, arg_0)).addAll((Collection)fileWithProblems.getProblems());
                    }
                    ++processed;
                }
            }
            return actualFileToProblems;
        }

        private final List<VirtualFile> findDiff(Map<VirtualFile, ? extends Set<PwaProblem>> storageFileToProblems, Map<VirtualFile, ? extends Set<PwaProblem>> actualFileToProblems) {
            ArrayList<VirtualFile> diffFiles = new ArrayList<VirtualFile>();
            for (Map.Entry<VirtualFile, ? extends Set<PwaProblem>> storageFileToProblem : storageFileToProblems.entrySet()) {
                VirtualFile file = storageFileToProblem.getKey();
                Set<PwaProblem> actualProblems = actualFileToProblems.get(file);
                if (actualProblems == null) {
                    diffFiles.add(file);
                    continue;
                }
                if (Intrinsics.areEqual(storageFileToProblem.getValue(), actualProblems)) continue;
                diffFiles.add(file);
            }
            return diffFiles;
        }

        private static final Unit analyseFromScratch$lambda$3(PsiManager $psiManager, VirtualFile $file, List $providers, ArrayList $filesWithProblemsFutures, ExecutorService $executorService, PwaProblemsProvider $problemsProvider) {
            boolean bl;
            PsiFile psiFile;
            block5: {
                PsiFile psiFile2 = $psiManager.findFile($file);
                if (psiFile2 == null) {
                    return Unit.INSTANCE;
                }
                psiFile = psiFile2;
                Iterable $this$any$iv = $providers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PwaProviderInfo it = (PwaProviderInfo)element$iv;
                        boolean bl2 = false;
                        PwaFileFilter pwaFileFilter = it.getFilter();
                        Intrinsics.checkNotNull((Object)$file);
                        if (!PwaFileFilterKt.shouldAnalyseWithFastCheck(pwaFileFilter, $file, psiFile)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Intrinsics.checkNotNull((Object)$file);
                $filesWithProblemsFutures.add($executorService.submit(new AnalyseFileAndConvertProblems($file, psiFile, $providers, $problemsProvider)));
            }
            return Unit.INSTANCE;
        }

        private static final Set analyseFromScratch$lambda$4(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new HashSet();
        }

        private static final Set analyseFromScratch$lambda$5(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

