/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.actions.debug;

import com.intellij.analysis.pwa.analyser.PwaService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/analysis/pwa/actions/debug/PwaFindDependantFilesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "nameHash", "", "<init>", "(Lcom/intellij/openapi/project/Project;I)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.pwa.core"})
public final class PwaFindDependantFilesAction
extends AnAction {
    @NotNull
    private final Project project;
    private final int nameHash;

    public PwaFindDependantFilesAction(@NotNull Project project, int nameHash) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.nameHash = nameHash;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setText("Find files using this dependency");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Set dependantFiles = (Set)PwaService.Companion.getInstance(this.project).findDependantFiles(this.nameHash).blockingGet(5, TimeUnit.SECONDS);
        if (dependantFiles == null) {
            return;
        }
        JBList fileList = new JBList((ListModel)new CollectionListModel(CollectionsKt.toMutableList((Collection)dependantFiles)));
        JBScrollPane pane = new JBScrollPane((Component)fileList);
        fileList.setCellRenderer((ListCellRenderer)new FileListRenderer());
        ComponentsKt.dialog$default((String)"Dependant files", (JComponent)((JComponent)pane), (boolean)false, null, (boolean)false, null, null, null, null, null, null, (int)2044, null).show();
    }
}

