/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.storage.PwaPersistentProblem;
import com.intellij.analysis.pwa.utils.PwaHashUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0019J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003JA\u0010\u001f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\nH\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaFileOwnState;", "", "problems", "", "Lcom/intellij/analysis/pwa/storage/PwaPersistentProblem;", "declaredSymbols", "Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "modCountAtMomentOfAnalysis", "", "providersNameHash", "", "providerVersionFingerprint", "<init>", "(Ljava/util/List;Lcom/intellij/analysis/pwa/declared/SymbolHashesList;JII)V", "getProblems", "()Ljava/util/List;", "getDeclaredSymbols", "()Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "getModCountAtMomentOfAnalysis", "()J", "getProvidersNameHash", "()I", "getProviderVersionFingerprint", "merge", "other", "merge$intellij_pwa_core", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "hashCode", "toString", "", "intellij.pwa.core"})
public final class PwaFileOwnState {
    @NotNull
    private final List<PwaPersistentProblem> problems;
    @NotNull
    private final SymbolHashesList declaredSymbols;
    private final long modCountAtMomentOfAnalysis;
    private final int providersNameHash;
    private final int providerVersionFingerprint;

    public PwaFileOwnState(@NotNull List<PwaPersistentProblem> problems, @NotNull SymbolHashesList declaredSymbols, long modCountAtMomentOfAnalysis, int providersNameHash, int providerVersionFingerprint) {
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)declaredSymbols, (String)"declaredSymbols");
        this.problems = problems;
        this.declaredSymbols = declaredSymbols;
        this.modCountAtMomentOfAnalysis = modCountAtMomentOfAnalysis;
        this.providersNameHash = providersNameHash;
        this.providerVersionFingerprint = providerVersionFingerprint;
    }

    @NotNull
    public final List<PwaPersistentProblem> getProblems() {
        return this.problems;
    }

    @NotNull
    public final SymbolHashesList getDeclaredSymbols() {
        return this.declaredSymbols;
    }

    public final long getModCountAtMomentOfAnalysis() {
        return this.modCountAtMomentOfAnalysis;
    }

    public final int getProvidersNameHash() {
        return this.providersNameHash;
    }

    public final int getProviderVersionFingerprint() {
        return this.providerVersionFingerprint;
    }

    @NotNull
    public final PwaFileOwnState merge$intellij_pwa_core(@NotNull PwaFileOwnState other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int providersNameHash = PwaHashUtils.combineHash(this.providersNameHash, other.providersNameHash);
        int versionFingerprint = PwaHashUtils.combineHash(this.providerVersionFingerprint, other.providerVersionFingerprint);
        SymbolHashesList mergedDeclaredDependencies = this.declaredSymbols.merge$intellij_pwa_core(other.declaredSymbols);
        return new PwaFileOwnState(CollectionsKt.plus((Collection)this.problems, (Iterable)other.problems), mergedDeclaredDependencies, this.modCountAtMomentOfAnalysis, providersNameHash, versionFingerprint);
    }

    @NotNull
    public final List<PwaPersistentProblem> component1() {
        return this.problems;
    }

    @NotNull
    public final SymbolHashesList component2() {
        return this.declaredSymbols;
    }

    public final long component3() {
        return this.modCountAtMomentOfAnalysis;
    }

    public final int component4() {
        return this.providersNameHash;
    }

    public final int component5() {
        return this.providerVersionFingerprint;
    }

    @NotNull
    public final PwaFileOwnState copy(@NotNull List<PwaPersistentProblem> problems, @NotNull SymbolHashesList declaredSymbols, long modCountAtMomentOfAnalysis, int providersNameHash, int providerVersionFingerprint) {
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)declaredSymbols, (String)"declaredSymbols");
        return new PwaFileOwnState(problems, declaredSymbols, modCountAtMomentOfAnalysis, providersNameHash, providerVersionFingerprint);
    }

    public static /* synthetic */ PwaFileOwnState copy$default(PwaFileOwnState pwaFileOwnState, List list, SymbolHashesList symbolHashesList, long l, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            list = pwaFileOwnState.problems;
        }
        if ((n3 & 2) != 0) {
            symbolHashesList = pwaFileOwnState.declaredSymbols;
        }
        if ((n3 & 4) != 0) {
            l = pwaFileOwnState.modCountAtMomentOfAnalysis;
        }
        if ((n3 & 8) != 0) {
            n = pwaFileOwnState.providersNameHash;
        }
        if ((n3 & 0x10) != 0) {
            n2 = pwaFileOwnState.providerVersionFingerprint;
        }
        return pwaFileOwnState.copy(list, symbolHashesList, l, n, n2);
    }

    @NotNull
    public String toString() {
        return "PwaFileOwnState(problems=" + this.problems + ", declaredSymbols=" + this.declaredSymbols + ", modCountAtMomentOfAnalysis=" + this.modCountAtMomentOfAnalysis + ", providersNameHash=" + this.providersNameHash + ", providerVersionFingerprint=" + this.providerVersionFingerprint + ")";
    }

    public int hashCode() {
        int result = ((Object)this.problems).hashCode();
        result = result * 31 + this.declaredSymbols.hashCode();
        result = result * 31 + Long.hashCode(this.modCountAtMomentOfAnalysis);
        result = result * 31 + Integer.hashCode(this.providersNameHash);
        result = result * 31 + Integer.hashCode(this.providerVersionFingerprint);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PwaFileOwnState)) {
            return false;
        }
        PwaFileOwnState pwaFileOwnState = (PwaFileOwnState)other;
        if (!Intrinsics.areEqual(this.problems, pwaFileOwnState.problems)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.declaredSymbols, (Object)pwaFileOwnState.declaredSymbols)) {
            return false;
        }
        if (this.modCountAtMomentOfAnalysis != pwaFileOwnState.modCountAtMomentOfAnalysis) {
            return false;
        }
        if (this.providersNameHash != pwaFileOwnState.providersNameHash) {
            return false;
        }
        return this.providerVersionFingerprint == pwaFileOwnState.providerVersionFingerprint;
    }
}

