/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.analyser.PwaFileState;
import com.intellij.analysis.pwa.analyser.PwaFileWithProblems;
import com.intellij.analysis.pwa.analyser.PwaNotificationManager;
import com.intellij.analysis.pwa.analyser.PwaProblem;
import com.intellij.analysis.pwa.analyser.PwaProblemsProvider;
import com.intellij.analysis.pwa.analyser.core.PwaFileAnalysisResult;
import com.intellij.analysis.pwa.analyser.listeners.PwaResultsListener;
import com.intellij.analysis.pwa.storage.PwaPersistentFileWithProblems;
import com.intellij.analysis.pwa.storage.PwaPersistentProblem;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011H\u0002J\b\u0010\u0016\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaNotificationManagerImpl;", "Lcom/intellij/analysis/pwa/analyser/PwaNotificationManager;", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/ExecutorService;)V", "provider", "Lcom/intellij/analysis/pwa/analyser/PwaProblemsProvider;", "publisher", "Lcom/intellij/analysis/pwa/analyser/listeners/PwaResultsListener;", "notifyResultListeners", "", "result", "Lcom/intellij/analysis/pwa/analyser/core/PwaFileAnalysisResult;", "filesWithProblems", "", "Lcom/intellij/analysis/pwa/storage/PwaPersistentFileWithProblems;", "notifyListeners", "files", "Lcom/intellij/analysis/pwa/analyser/PwaFileWithProblems;", "flush", "Companion", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaNotificationManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaNotificationManagerImpl.kt\ncom/intellij/analysis/pwa/analyser/PwaNotificationManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n61#2,5:90\n14#2:108\n1611#3,9:95\n1863#3:104\n1864#3:106\n1620#3:107\n1#4:105\n*S KotlinDebug\n*F\n+ 1 PwaNotificationManagerImpl.kt\ncom/intellij/analysis/pwa/analyser/PwaNotificationManagerImpl\n*L\n83#1:90,5\n20#1:108\n72#1:95,9\n72#1:104\n72#1:106\n72#1:107\n72#1:105\n*E\n"})
public final class PwaNotificationManagerImpl
implements PwaNotificationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final PwaProblemsProvider provider;
    @NotNull
    private final PwaResultsListener publisher;
    @NotNull
    private static final Logger logger;

    public PwaNotificationManagerImpl(@NotNull Project project, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.project = project;
        this.executor = executor;
        this.provider = new PwaProblemsProvider(this.project);
        this.publisher = (PwaResultsListener)this.project.getMessageBus().syncPublisher(PwaResultsListener.Companion.getTOPIC());
    }

    @Override
    public void notifyResultListeners(@NotNull PwaFileAnalysisResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.executor.execute(() -> PwaNotificationManagerImpl.notifyResultListeners$lambda$1(this, result));
    }

    @Override
    public void notifyResultListeners(@NotNull List<PwaPersistentFileWithProblems> filesWithProblems) {
        Intrinsics.checkNotNullParameter(filesWithProblems, (String)"filesWithProblems");
        this.executor.execute(() -> PwaNotificationManagerImpl.notifyResultListeners$lambda$4(this, filesWithProblems));
    }

    private final void notifyListeners(List<PwaFileWithProblems> files) {
        this.publisher.filesUpdated(this.project, files);
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Notified about results: \n" + files, e$iv);
        }
    }

    @Override
    public void flush() {
    }

    private static final Unit notifyResultListeners$lambda$1$lambda$0(PwaNotificationManagerImpl this$0, PwaFileAnalysisResult $result) {
        Object object;
        if (this$0.project.isDisposed()) {
            return Unit.INSTANCE;
        }
        PwaFileWithProblems fileWithProblems = Companion.convertToNonPersistentProblems($result.getFile(), (object = $result.getState()) != null && (object = ((PwaFileState)object).getOwnState()) != null ? ((PwaFileOwnState)object).getProblems() : null, this$0.provider);
        List files = CollectionsKt.listOf((Object)fileWithProblems);
        this$0.notifyListeners(files);
        return Unit.INSTANCE;
    }

    private static final void notifyResultListeners$lambda$1(PwaNotificationManagerImpl this$0, PwaFileAnalysisResult $result) {
        ActionsKt.runReadAction(() -> PwaNotificationManagerImpl.notifyResultListeners$lambda$1$lambda$0(this$0, $result));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit notifyResultListeners$lambda$4$lambda$3(PwaNotificationManagerImpl this$0, List $filesWithProblems) {
        void $this$mapNotNullTo$iv$iv;
        if (this$0.project.isDisposed()) {
            return Unit.INSTANCE;
        }
        ManagingFS fs = ManagingFS.getInstance();
        Iterable $this$mapNotNull$iv = $filesWithProblems;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PwaFileWithProblems it$iv$iv;
            VirtualFile file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PwaPersistentFileWithProblems it = (PwaPersistentFileWithProblems)element$iv$iv;
            boolean bl2 = false;
            if ((fs.findFileById(it.getFileId()) == null ? null : Companion.convertToNonPersistentProblems(file, it.getProblems(), this$0.provider)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nonPersistent = (List)destination$iv$iv;
        this$0.notifyListeners(nonPersistent);
        return Unit.INSTANCE;
    }

    private static final void notifyResultListeners$lambda$4(PwaNotificationManagerImpl this$0, List $filesWithProblems) {
        ActionsKt.runReadAction(() -> PwaNotificationManagerImpl.notifyResultListeners$lambda$4$lambda$3(this$0, $filesWithProblems));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaNotificationManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PwaNotificationManagerImpl.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0010"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaNotificationManagerImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "convertToNonPersistentProblems", "Lcom/intellij/analysis/pwa/analyser/PwaFileWithProblems;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "persistentProblems", "", "Lcom/intellij/analysis/pwa/storage/PwaPersistentProblem;", "provider", "Lcom/intellij/analysis/pwa/analyser/PwaProblemsProvider;", "intellij.pwa.core"})
    @SourceDebugExtension(value={"SMAP\nPwaNotificationManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaNotificationManagerImpl.kt\ncom/intellij/analysis/pwa/analyser/PwaNotificationManagerImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1557#2:90\n1628#2,3:91\n*S KotlinDebug\n*F\n+ 1 PwaNotificationManagerImpl.kt\ncom/intellij/analysis/pwa/analyser/PwaNotificationManagerImpl$Companion\n*L\n33#1:90\n33#1:91,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @RequiresReadLock
        @NotNull
        public final PwaFileWithProblems convertToNonPersistentProblems(@NotNull VirtualFile file, @Nullable List<PwaPersistentProblem> persistentProblems, @NotNull PwaProblemsProvider provider) {
            List list;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Collection collection = persistentProblems;
            if (collection == null || collection.isEmpty()) {
                return new PwaFileWithProblems(file, CollectionsKt.emptyList());
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (!file.isValid() || document == null) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                int textLength = document.getTextLength();
                Iterable $this$map$iv = persistentProblems;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    boolean bl;
                    void it;
                    PwaPersistentProblem pwaPersistentProblem = (PwaPersistentProblem)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    int usedOffset = textLength <= it.getOffset() ? textLength - 1 : it.getOffset();
                    int line = document.getLineNumber(usedOffset);
                    int column = usedOffset - document.getLineStartOffset(line);
                    boolean bl3 = bl = column >= 0;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    collection2.add(new PwaProblem(provider, it.getMessage(), file, line, column));
                }
                list = (List)destination$iv$iv;
            }
            List problems = list;
            return new PwaFileWithProblems(file, problems);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

