/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaService;
import com.intellij.analysis.pwa.analyser.PwaWorkspaceAsyncChangeListener;
import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.analysis.pwa.utils.UtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ExtensionsKt;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J$\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaWorkspaceAsyncChangeListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "service", "Lcom/intellij/analysis/pwa/analyser/PwaService;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "filters", "", "Lcom/intellij/analysis/pwa/support/PwaFileFilter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/pwa/analyser/PwaService;Lkotlinx/coroutines/CoroutineScope;Ljava/util/List;)V", "subscribe", "", "subscribe$intellij_pwa_core", "addSourceRoots", "entity", "Lcom/intellij/platform/workspace/jps/entities/SourceRootEntity;", "changed", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "addModuleRoots", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "sourceRoots", "Lkotlin/sequences/Sequence;", "addLibraryRoots", "library", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "intellij.pwa.core"})
public final class PwaWorkspaceAsyncChangeListener {
    @NotNull
    private final Project project;
    @NotNull
    private final PwaService service;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final List<PwaFileFilter> filters;

    public PwaWorkspaceAsyncChangeListener(@NotNull Project project, @NotNull PwaService service, @NotNull CoroutineScope cs, @NotNull List<? extends PwaFileFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        this.project = project;
        this.service = service;
        this.cs = cs;
        this.filters = filters;
    }

    public final void subscribe$intellij_pwa_core() {
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PwaWorkspaceAsyncChangeListener this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = WorkspaceModel.Companion.getInstance(PwaWorkspaceAsyncChangeListener.access$getProject$p(this.this$0)).getEventLog().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ PwaWorkspaceAsyncChangeListener this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(VersionedStorageChange event, Continuation<? super Unit> $completion) {
                                PwaWorkspaceAsyncChangeListener pwaWorkspaceAsyncChangeListener;
                                PwaWorkspaceAsyncChangeListener pwaWorkspaceAsyncChangeListener2;
                                VirtualFileSet virtualFileSet = VfsUtilCore.createCompactVirtualFileSet();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFileSet, (String)"createCompactVirtualFileSet(...)");
                                VirtualFileSet roots = virtualFileSet;
                                List libraryChanges = event.getChanges(LibraryEntity.class);
                                for (Object change : libraryChanges) {
                                    LibraryEntity it;
                                    LibraryEntity libraryEntity;
                                    if ((LibraryEntity)change.getOldEntity() != null) {
                                        pwaWorkspaceAsyncChangeListener2 = this.this$0;
                                        it = libraryEntity;
                                        boolean bl = false;
                                        PwaWorkspaceAsyncChangeListener.access$addLibraryRoots(pwaWorkspaceAsyncChangeListener2, it, (Set)roots);
                                    }
                                    if ((LibraryEntity)change.getNewEntity() == null) continue;
                                    pwaWorkspaceAsyncChangeListener2 = this.this$0;
                                    it = libraryEntity;
                                    boolean bl = false;
                                    PwaWorkspaceAsyncChangeListener.access$addLibraryRoots(pwaWorkspaceAsyncChangeListener2, it, (Set)roots);
                                }
                                List moduleChanges = event.getChanges(ModuleEntity.class);
                                for (Object change : moduleChanges) {
                                    PwaWorkspaceAsyncChangeListener it;
                                    if ((ModuleEntity)change.getOldEntity() != null) {
                                        pwaWorkspaceAsyncChangeListener = this.this$0;
                                        it = pwaWorkspaceAsyncChangeListener2;
                                        boolean bl = false;
                                        PwaWorkspaceAsyncChangeListener.access$addModuleRoots(pwaWorkspaceAsyncChangeListener, (ModuleEntity)it, (Set)roots);
                                    }
                                    if ((ModuleEntity)change.getNewEntity() == null) continue;
                                    pwaWorkspaceAsyncChangeListener = this.this$0;
                                    it = pwaWorkspaceAsyncChangeListener2;
                                    boolean bl = false;
                                    PwaWorkspaceAsyncChangeListener.access$addModuleRoots(pwaWorkspaceAsyncChangeListener, (ModuleEntity)it, (Set)roots);
                                }
                                List sourceRootChanges = event.getChanges(SourceRootEntity.class);
                                for (EntityChange change : sourceRootChanges) {
                                    PwaWorkspaceAsyncChangeListener it;
                                    PwaWorkspaceAsyncChangeListener pwaWorkspaceAsyncChangeListener3;
                                    if ((SourceRootEntity)change.getOldEntity() != null) {
                                        pwaWorkspaceAsyncChangeListener3 = this.this$0;
                                        it = pwaWorkspaceAsyncChangeListener;
                                        boolean bl = false;
                                        PwaWorkspaceAsyncChangeListener.access$addSourceRoots(pwaWorkspaceAsyncChangeListener3, (SourceRootEntity)it, (Set)roots);
                                    }
                                    if ((SourceRootEntity)change.getNewEntity() == null) continue;
                                    pwaWorkspaceAsyncChangeListener3 = this.this$0;
                                    it = pwaWorkspaceAsyncChangeListener;
                                    boolean bl = false;
                                    PwaWorkspaceAsyncChangeListener.access$addSourceRoots(pwaWorkspaceAsyncChangeListener3, (SourceRootEntity)it, (Set)roots);
                                }
                                IntOpenHashSet changed = new IntOpenHashSet();
                                ActionsKt.runReadAction(() -> subscribe.1.emit$lambda$6(roots, changed, this.this$0));
                                PwaWorkspaceAsyncChangeListener.access$getService$p(this.this$0).notifyFilesChanged(new FileIdSet((IntSet)changed));
                                return Unit.INSTANCE;
                            }

                            private static final Unit emit$lambda$6(VirtualFileSet $roots, IntOpenHashSet $changed, PwaWorkspaceAsyncChangeListener this$0) {
                                for (VirtualFile root : $roots) {
                                    ProgressManager.checkCanceled();
                                    Intrinsics.checkNotNull((Object)root);
                                    UtilsKt.collectAnalyzableFileIdsUnderRoot(root, (IntSet)$changed, PwaWorkspaceAsyncChangeListener.access$getFilters$p(this$0));
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void addSourceRoots(SourceRootEntity entity, Set<VirtualFile> changed) {
        this.addSourceRoots((Sequence<? extends SourceRootEntity>)CollectionsKt.asSequence((Iterable)entity.getContentRoot().getSourceRoots()), changed);
    }

    private final void addModuleRoots(ModuleEntity entity, Set<VirtualFile> changed) {
        List sourceRoots = ExtensionsKt.getSourceRoots((ModuleEntity)entity);
        this.addSourceRoots((Sequence<? extends SourceRootEntity>)CollectionsKt.asSequence((Iterable)sourceRoots), changed);
    }

    private final void addSourceRoots(Sequence<? extends SourceRootEntity> sourceRoots, Set<VirtualFile> changed) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        for (SourceRootEntity sourceRoot : sourceRoots) {
            VirtualFile file;
            String url = sourceRoot.getUrl().getUrl();
            if (fileManager.findFileByUrl(url) == null) continue;
            changed.add(file);
        }
    }

    private final void addLibraryRoots(LibraryEntity library, Set<VirtualFile> changed) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        for (LibraryRoot root : library.getRoots()) {
            VirtualFile file;
            String url = root.getUrl().getUrl();
            if (fileManager.findFileByUrl(url) == null) continue;
            changed.add(file);
        }
    }

    public static final /* synthetic */ Project access$getProject$p(PwaWorkspaceAsyncChangeListener $this) {
        return $this.project;
    }

    public static final /* synthetic */ PwaService access$getService$p(PwaWorkspaceAsyncChangeListener $this) {
        return $this.service;
    }

    public static final /* synthetic */ void access$addLibraryRoots(PwaWorkspaceAsyncChangeListener $this, LibraryEntity library, Set changed) {
        $this.addLibraryRoots(library, changed);
    }

    public static final /* synthetic */ void access$addModuleRoots(PwaWorkspaceAsyncChangeListener $this, ModuleEntity entity, Set changed) {
        $this.addModuleRoots(entity, changed);
    }

    public static final /* synthetic */ void access$addSourceRoots(PwaWorkspaceAsyncChangeListener $this, SourceRootEntity entity, Set changed) {
        $this.addSourceRoots(entity, (Set<VirtualFile>)changed);
    }

    public static final /* synthetic */ List access$getFilters$p(PwaWorkspaceAsyncChangeListener $this) {
        return $this.filters;
    }
}

