/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser.core;

import com.intellij.analysis.pwa.PwaInternalSettings;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.openapi.application.ActionsKt;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaAnalysisBatch;", "", "filesToAnalyseOnly", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "filesToAnalyseInvalidatingDeps", "previousFileStates", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/analysis/pwa/analyser/PwaFileOwnState;", "<init>", "(Lcom/intellij/analysis/pwa/analyser/FileIdSet;Lcom/intellij/analysis/pwa/analyser/FileIdSet;Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;)V", "getFilesToAnalyseOnly", "()Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "getFilesToAnalyseInvalidatingDeps", "getPreviousFileStates", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "size", "", "getSize", "()I", "toString", "", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaAnalysisBatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaAnalysisBatch.kt\ncom/intellij/analysis/pwa/analyser/core/PwaAnalysisBatch\n+ 2 PwaInternalSettings.kt\ncom/intellij/analysis/pwa/PwaInternalSettingsKt\n*L\n1#1,40:1\n23#2,4:41\n*S KotlinDebug\n*F\n+ 1 PwaAnalysisBatch.kt\ncom/intellij/analysis/pwa/analyser/core/PwaAnalysisBatch\n*L\n24#1:41,4\n*E\n"})
public final class PwaAnalysisBatch {
    @NotNull
    private final FileIdSet filesToAnalyseOnly;
    @NotNull
    private final FileIdSet filesToAnalyseInvalidatingDeps;
    @NotNull
    private final Int2ObjectMap<PwaFileOwnState> previousFileStates;

    public PwaAnalysisBatch(@NotNull FileIdSet filesToAnalyseOnly, @NotNull FileIdSet filesToAnalyseInvalidatingDeps, @NotNull Int2ObjectMap<PwaFileOwnState> previousFileStates) {
        Intrinsics.checkNotNullParameter((Object)filesToAnalyseOnly, (String)"filesToAnalyseOnly");
        Intrinsics.checkNotNullParameter((Object)filesToAnalyseInvalidatingDeps, (String)"filesToAnalyseInvalidatingDeps");
        Intrinsics.checkNotNullParameter(previousFileStates, (String)"previousFileStates");
        this.filesToAnalyseOnly = filesToAnalyseOnly;
        this.filesToAnalyseInvalidatingDeps = filesToAnalyseInvalidatingDeps;
        this.previousFileStates = previousFileStates;
        boolean $i$f$ensure = false;
        if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
            boolean bl = false;
            if (!(!this.filesToAnalyseOnly.intersects(this.filesToAnalyseInvalidatingDeps))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @NotNull
    public final FileIdSet getFilesToAnalyseOnly() {
        return this.filesToAnalyseOnly;
    }

    @NotNull
    public final FileIdSet getFilesToAnalyseInvalidatingDeps() {
        return this.filesToAnalyseInvalidatingDeps;
    }

    @NotNull
    public final Int2ObjectMap<PwaFileOwnState> getPreviousFileStates() {
        return this.previousFileStates;
    }

    public final int getSize() {
        return this.filesToAnalyseInvalidatingDeps.getSize() + this.filesToAnalyseOnly.getSize();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u242.append("Analysis task: ");
        ActionsKt.runReadAction(() -> PwaAnalysisBatch.toString$lambda$2$lambda$1($this$toString_u24lambda_u242, this));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit toString$lambda$2$lambda$1(StringBuilder $this_buildString, PwaAnalysisBatch this$0) {
        $this_buildString.append("to analyze only: ");
        $this_buildString.append(this$0.filesToAnalyseOnly.toFileList());
        $this_buildString.append(", to analyze with dependencies: ");
        $this_buildString.append(this$0.filesToAnalyseInvalidatingDeps.toFileList());
        return Unit.INSTANCE;
    }
}

