/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser.core;

import com.intellij.analysis.pwa.PwaInternalSettings;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.HashesList;
import com.intellij.analysis.pwa.analyser.PwaFileData;
import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.analyser.PwaFileState;
import com.intellij.analysis.pwa.analyser.PwaNotificationManager;
import com.intellij.analysis.pwa.analyser.core.PwaAnalyserDaemon;
import com.intellij.analysis.pwa.analyser.core.PwaAnalysisBatch;
import com.intellij.analysis.pwa.analyser.core.PwaContext;
import com.intellij.analysis.pwa.analyser.core.PwaDeletedFileAnalysisResult;
import com.intellij.analysis.pwa.analyser.core.PwaFileAnalysisResult;
import com.intellij.analysis.pwa.analyser.core.PwaProviderInfo;
import com.intellij.analysis.pwa.analyser.core.PwaResultCache;
import com.intellij.analysis.pwa.analyser.core.PwaTask;
import com.intellij.analysis.pwa.analyser.core.PwaTaskResultStatus;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.settings.PwaSettings;
import com.intellij.analysis.pwa.statistics.PwaCounterCollector;
import com.intellij.analysis.pwa.storage.PwaFileStateWithId;
import com.intellij.analysis.pwa.support.PwaFileFilterKt;
import com.intellij.analysis.pwa.utils.IntArrayListAccessor;
import com.intellij.analysis.pwa.utils.ListAccessor;
import com.intellij.analysis.pwa.utils.PwaBundle;
import com.intellij.analysis.pwa.utils.PwaHashUtils;
import com.intellij.analysis.pwa.utils.PwaIntListUtils;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0003J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\rH\u0003J$\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaUpdateFilesTask;", "Lcom/intellij/analysis/pwa/analyser/core/PwaTask;", "project", "Lcom/intellij/openapi/project/Project;", "resultCache", "Lcom/intellij/analysis/pwa/analyser/core/PwaResultCache;", "notificationManager", "Lcom/intellij/analysis/pwa/analyser/PwaNotificationManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/pwa/analyser/core/PwaResultCache;Lcom/intellij/analysis/pwa/analyser/PwaNotificationManager;)V", "execute", "", "context", "Lcom/intellij/analysis/pwa/analyser/core/PwaContext;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "name", "", "getName", "()Ljava/lang/String;", "showProgress", "", "getShowProgress", "()Z", "analyse", "", "batch", "Lcom/intellij/analysis/pwa/analyser/core/PwaAnalysisBatch;", "analyseFiles", "", "Lcom/intellij/analysis/pwa/storage/PwaFileStateWithId;", "files", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "doAnalysis", "fileId", "analyseFile", "Lcom/intellij/analysis/pwa/analyser/core/PwaFileAnalysisResult;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "suggestDependenciesToAnalyze", "Lcom/intellij/analysis/pwa/analyser/HashesList;", "directlyChanged", "previousFileStates", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/analysis/pwa/analyser/PwaFileOwnState;", "Companion", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaUpdateFilesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaUpdateFilesTask.kt\ncom/intellij/analysis/pwa/analyser/core/PwaUpdateFilesTask\n+ 2 PwaAnalyserDaemon.kt\ncom/intellij/analysis/pwa/analyser/core/PwaAnalyserDaemon\n+ 3 PwaInternalSettings.kt\ncom/intellij/analysis/pwa/PwaInternalSettingsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 7 SymbolHashesList.kt\ncom/intellij/analysis/pwa/declared/SymbolHashesList\n+ 8 PwaIntListUtils.kt\ncom/intellij/analysis/pwa/utils/PwaIntListUtils\n*L\n1#1,275:1\n491#2:276\n23#3,2:277\n26#3:282\n23#3,2:283\n26#3:288\n23#3,4:318\n1734#4,3:279\n1734#4,3:285\n1611#4,9:289\n1863#4:298\n1864#4:300\n1620#4:301\n1#5:299\n61#6,5:302\n61#6,5:307\n14#6:378\n22#7,4:312\n27#7:340\n26#7:348\n29#7,4:356\n34#7:377\n35#8,2:316\n37#8,3:322\n58#8,7:325\n137#8,6:332\n66#8:338\n43#8:339\n67#8:341\n143#8,4:342\n70#8:346\n44#8:347\n71#8:349\n147#8,4:350\n74#8:354\n45#8:355\n75#8:360\n151#8,14:361\n78#8:375\n47#8:376\n*S KotlinDebug\n*F\n+ 1 PwaUpdateFilesTask.kt\ncom/intellij/analysis/pwa/analyser/core/PwaUpdateFilesTask\n*L\n91#1:276\n150#1:277,2\n150#1:282\n153#1:283,2\n153#1:288\n260#1:318,4\n151#1:279,3\n154#1:285,3\n181#1:289,9\n181#1:298\n181#1:300\n181#1:301\n181#1:299\n219#1:302,5\n225#1:307,5\n43#1:378\n260#1:312,4\n260#1:340\n260#1:348\n260#1:356,4\n260#1:377\n260#1:316,2\n260#1:322,3\n260#1:325,7\n260#1:332,6\n260#1:338\n260#1:339\n260#1:341\n260#1:342,4\n260#1:346\n260#1:347\n260#1:349\n260#1:350,4\n260#1:354\n260#1:355\n260#1:360\n260#1:361,14\n260#1:375\n260#1:376\n*E\n"})
public final class PwaUpdateFilesTask
implements PwaTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PwaResultCache resultCache;
    @NotNull
    private final PwaNotificationManager notificationManager;
    @NotNull
    private static final Logger logger;

    public PwaUpdateFilesTask(@NotNull Project project, @NotNull PwaResultCache resultCache, @NotNull PwaNotificationManager notificationManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resultCache, (String)"resultCache");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        this.project = project;
        this.resultCache = resultCache;
        this.notificationManager = notificationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull PwaContext context, @NotNull ProgressIndicator indicator) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        boolean bl2 = bl = ProgressManager.getInstance().getProgressIndicator() == indicator;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        logger.debug("PWA update started");
        Ref.ObjectRef status = new Ref.ObjectRef();
        status.element = PwaTaskResultStatus.Success;
        PwaAnalyserDaemon engine = context.getDaemon();
        int analysedSuccessfullyCount = 0;
        indicator.setIndeterminate(false);
        StructuredIdeActivity activity = PwaCounterCollector.INSTANCE.startUpdate(this.project);
        try {
            long lastTime = 0L;
            while (true) {
                Object object;
                Object[] objectArray;
                indicator.checkCanceled();
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastTime > 500L) {
                    int n;
                    PwaAnalyserDaemon this_$iv = context.getDaemon();
                    boolean $i$f$withPwaLock = false;
                    Lock lock = PwaAnalyserDaemon.access$getLock$p(this_$iv);
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        n = engine.getFilesToAnalyseCount();
                    }
                    finally {
                        lock.unlock();
                    }
                    int filesToAnalyseCount = n;
                    indicator.setFraction((double)analysedSuccessfullyCount / ((double)filesToAnalyseCount + (double)analysedSuccessfullyCount));
                    objectArray = new Object[]{analysedSuccessfullyCount, filesToAnalyseCount + analysedSuccessfullyCount};
                    indicator.setText2(PwaBundle.Companion.message("pwa.update.progress.details", objectArray));
                    lastTime = currentTime;
                }
                objectArray = (Object[])context.getLock();
                objectArray.lock();
                try {
                    boolean bl4 = false;
                    object = context.getDaemon().prepareBatch();
                }
                finally {
                    objectArray.unlock();
                }
                PwaAnalysisBatch batch = object;
                if (batch != null) {
                    if (!(batch.getSize() != 0)) {
                        object = "Failed requirement.";
                        throw new IllegalArgumentException(object.toString());
                    }
                    analysedSuccessfullyCount += this.analyse(batch, context);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            if (!(e instanceof ProcessCanceledException)) {
                logger.warn((Throwable)e);
                status.element = PwaTaskResultStatus.Exception;
            } else {
                status.element = PwaTaskResultStatus.InterruptedByUser;
            }
        }
        finally {
            Lock lock = context.getLock();
            lock.lock();
            try {
                boolean bl5 = false;
                context.getDaemon().setNeedToCreateUpdate(true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            if (status.element != PwaTaskResultStatus.Success) {
                PwaSettings.Companion.getInstance(this.project).setEnabled(this.project, false);
            }
            activity.finished(() -> PwaUpdateFilesTask.execute$lambda$3(status));
            logger.info("Update finished");
        }
    }

    @Override
    @NotNull
    public String getName() {
        return PwaBundle.Companion.message("analyse.changes.task.name", new Object[0]);
    }

    @Override
    public boolean getShowProgress() {
        return true;
    }

    private final int analyse(PwaAnalysisBatch batch, PwaContext context) {
        PwaFileStateWithId it;
        boolean $i$f$all;
        Iterable $this$all$iv;
        FileIdSet filesToAnalyseOnly = batch.getFilesToAnalyseOnly();
        FileIdSet filesToAnalyseInvalidatingDeps = batch.getFilesToAnalyseInvalidatingDeps();
        List<PwaFileStateWithId> analyzedOnlyFiles = this.analyseFiles(filesToAnalyseOnly, context);
        List<PwaFileStateWithId> directlyChangedFiles = this.analyseFiles(filesToAnalyseInvalidatingDeps, context);
        HashesList dependenciesToAnalyze = this.suggestDependenciesToAnalyze(directlyChangedFiles, batch.getPreviousFileStates());
        boolean $i$f$ensure = false;
        if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
            boolean bl;
            block10: {
                boolean bl2 = false;
                $this$all$iv = analyzedOnlyFiles;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (PwaFileStateWithId)element$iv;
                        boolean bl3 = false;
                        if (batch.getFilesToAnalyseOnly().getStorage().contains(it.getFileId())) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        $i$f$ensure = false;
        if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
            boolean bl;
            block11: {
                boolean bl4 = false;
                $this$all$iv = directlyChangedFiles;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (PwaFileStateWithId)element$iv;
                        boolean bl5 = false;
                        if (batch.getFilesToAnalyseInvalidatingDeps().getStorage().contains(it.getFileId())) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        int nonCancelledCount = this.resultCache.submitResult(analyzedOnlyFiles, directlyChangedFiles, dependenciesToAnalyze);
        this.resultCache.flush();
        return nonCancelledCount;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PwaFileStateWithId> analyseFiles(FileIdSet files, PwaContext context) {
        void $this$mapNotNullTo$iv$iv;
        if (files.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List statePromises = new ArrayList(files.getSize());
        files.forEach(arg_0 -> PwaUpdateFilesTask.analyseFiles$lambda$9(this, context, statePromises, arg_0));
        Iterable $this$mapNotNull$iv = statePromises;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PwaFileStateWithId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CancellablePromise it = (CancellablePromise)element$iv$iv;
            boolean bl2 = false;
            if ((PwaFileStateWithId)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List results = (List)destination$iv$iv;
        PsiManager.getInstance((Project)this.project).dropResolveCaches();
        return results;
    }

    @RequiresReadLock
    private final PwaFileStateWithId doAnalysis(int fileId, PwaContext context) {
        PwaFileStateWithId pwaFileStateWithId;
        Integer id;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager manager = virtualFileManager;
        VirtualFile file = manager.findFileById(fileId);
        VirtualFileWithId virtualFileWithId = file instanceof VirtualFileWithId ? (VirtualFileWithId)file : null;
        Integer n = id = virtualFileWithId != null ? Integer.valueOf(virtualFileWithId.getId()) : null;
        if (id != null) {
            int n2 = fileId;
            if (id != n2) {
                throw new IllegalStateException("File is unexpected: " + file + ", searched file id: " + fileId + ", file reports id: " + id);
            }
        }
        if (file == null) {
            pwaFileStateWithId = new PwaDeletedFileAnalysisResult(fileId);
        } else {
            PwaFileStateWithId pwaFileStateWithId2;
            try {
                pwaFileStateWithId2 = this.analyseFile(file, context);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                logger.warn("Exception while analysing file", (Throwable)e);
                pwaFileStateWithId2 = new PwaDeletedFileAnalysisResult(fileId);
            }
            pwaFileStateWithId = pwaFileStateWithId2;
        }
        return pwaFileStateWithId;
    }

    @RequiresReadLock
    private final PwaFileAnalysisResult analyseFile(VirtualFile file, PwaContext context) {
        Logger logger;
        PwaFileState pwaFileState;
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile == null) {
            pwaFileState = null;
        } else {
            Logger $this$debug_u24default$iv = PwaUpdateFilesTask.logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Analysing file: " + file, e$iv);
            }
            pwaFileState = Companion.analyseFile(file, psiFile, context.getDaemon().getSupportProviders());
        }
        PwaFileState state = pwaFileState;
        PwaFileAnalysisResult result = new PwaFileAnalysisResult(file, state);
        this.notificationManager.notifyResultListeners(result);
        Logger $this$debug_u24default$iv = PwaUpdateFilesTask.logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("File analysed: " + file, e$iv);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final HashesList suggestDependenciesToAnalyze(List<? extends PwaFileStateWithId> directlyChanged, Int2ObjectMap<PwaFileOwnState> previousFileStates) {
        IntOpenHashSet hashes = new IntOpenHashSet();
        block0: for (PwaFileStateWithId pwaFileStateWithId : directlyChanged) {
            int firstIndex$iv$iv$iv;
            int index$iv$iv$iv;
            boolean bl;
            int it;
            int it$iv;
            int value$iv$iv;
            int value$iv$iv$iv;
            void second$iv$iv$iv$iv;
            void first$iv$iv$iv$iv;
            Object object;
            void this_$iv$iv;
            void current$iv$iv;
            String string;
            void previous$iv$iv;
            int fileId = pwaFileStateWithId.getFileId();
            PwaFileOwnState previous = (PwaFileOwnState)previousFileStates.get(fileId);
            PwaFileState currentState = pwaFileStateWithId.getState();
            if (previous == null) {
                Object object2 = currentState;
                if (object2 != null && (object2 = ((PwaFileState)object2).getOwnState()) != null && (object2 = ((PwaFileOwnState)object2).getDeclaredSymbols()) != null && (object2 = ((SymbolHashesList)object2).getNameHashes()) != null) {
                    ((HashesList)object2).forEach(arg_0 -> PwaUpdateFilesTask.suggestDependenciesToAnalyze$lambda$13(hashes, arg_0));
                }
                continue;
            }
            if (currentState == null) {
                previous.getDeclaredSymbols().getNameHashes().forEach(arg_0 -> PwaUpdateFilesTask.suggestDependenciesToAnalyze$lambda$14(hashes, arg_0));
                continue;
            }
            SymbolHashesList newDeps = currentState.getOwnState().getDeclaredSymbols();
            SymbolHashesList this_$iv = previous.getDeclaredSymbols();
            boolean $i$f$diffWithNew = false;
            PwaIntListUtils pwaIntListUtils = PwaIntListUtils.INSTANCE;
            IntArrayList intArrayList = this_$iv.getNameHashes().getStorage();
            IntArrayList intArrayList2 = newDeps.getNameHashes().getStorage();
            boolean bl2 = true;
            boolean $i$f$diff = false;
            boolean $i$f$ensure = false;
            if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                boolean bl8 = false;
                if (!PwaIntListUtils.INSTANCE.isSortedDistinct((IntArrayList)previous$iv$iv)) {
                    string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            $i$f$ensure = false;
            if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                boolean bl9 = false;
                if (!PwaIntListUtils.INSTANCE.isSortedDistinct((IntArrayList)current$iv$iv)) {
                    string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            void this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$syncSortedBypass = false;
            boolean $i$f$ensure2 = false;
            if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                boolean bl10 = false;
                if (!(CollectionsKt.sorted((Iterable)((Iterable)previous$iv$iv)).size() == previous$iv$iv.size())) {
                    object = "Failed requirement.";
                    throw new IllegalArgumentException(object.toString());
                }
            }
            boolean $i$f$ensure232 = false;
            if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                boolean bl11 = false;
                if (!(CollectionsKt.sorted((Iterable)((Iterable)current$iv$iv)).size() == current$iv$iv.size())) {
                    object = "Failed requirement.";
                    throw new IllegalArgumentException(object.toString());
                }
            }
            void $i$f$ensure232 = this_$iv$iv$iv;
            ListAccessor bl11 = new IntArrayListAccessor((IntArrayList)previous$iv$iv);
            object = new IntArrayListAccessor((IntArrayList)current$iv$iv);
            boolean $i$f$syncSortedBypass2 = false;
            while (first$iv$iv$iv$iv.isValid() && second$iv$iv$iv$iv.isValid()) {
                void newIndex$iv;
                void oldIndex$iv;
                void previousIndex$iv$iv;
                void currentIndex$iv$iv;
                void secondIndex$iv$iv$iv;
                boolean bl3;
                boolean bl4;
                int n;
                int firstElem$iv$iv$iv$iv = first$iv$iv$iv$iv.current();
                int secondElem$iv$iv$iv$iv = second$iv$iv$iv$iv.current();
                if (firstElem$iv$iv$iv$iv < secondElem$iv$iv$iv$iv) {
                    int n2 = first$iv$iv$iv$iv.getIndex();
                    value$iv$iv$iv = firstElem$iv$iv$iv$iv;
                    boolean bl5 = false;
                    value$iv$iv = value$iv$iv$iv;
                    boolean bl6 = false;
                    it$iv = value$iv$iv;
                    boolean bl7 = false;
                    it = it$iv;
                    bl = false;
                    hashes.add(it);
                    if (!true) continue block0;
                    first$iv$iv$iv$iv.advance();
                    continue;
                }
                if (firstElem$iv$iv$iv$iv > secondElem$iv$iv$iv$iv) {
                    index$iv$iv$iv = second$iv$iv$iv$iv.getIndex();
                    value$iv$iv$iv = secondElem$iv$iv$iv$iv;
                    n = 0;
                    value$iv$iv = value$iv$iv$iv;
                    bl4 = false;
                    it$iv = value$iv$iv;
                    bl3 = false;
                    it = it$iv;
                    bl = false;
                    hashes.add(it);
                    if (!true) continue block0;
                    second$iv$iv$iv$iv.advance();
                    continue;
                }
                n = second$iv$iv$iv$iv.getIndex();
                index$iv$iv$iv = first$iv$iv$iv$iv.getIndex();
                value$iv$iv$iv = firstElem$iv$iv$iv$iv;
                boolean bl12 = false;
                bl4 = secondIndex$iv$iv$iv;
                int n3 = firstIndex$iv$iv$iv;
                value$iv$iv = value$iv$iv$iv;
                boolean bl13 = false;
                void var37_42 = currentIndex$iv$iv;
                bl3 = previousIndex$iv$iv;
                int nameHash$iv = value$iv$iv;
                boolean bl14 = false;
                if (this_$iv.getSignatureHashes().getStorage().getInt((int)oldIndex$iv) != newDeps.getSignatureHashes().getStorage().getInt((int)newIndex$iv)) {
                    it = nameHash$iv;
                    bl = false;
                    hashes.add(it);
                }
                if (!true) continue block0;
                first$iv$iv$iv$iv.advance();
                second$iv$iv$iv$iv.advance();
            }
            while (first$iv$iv$iv$iv.isValid()) {
                firstIndex$iv$iv$iv = first$iv$iv$iv$iv.getIndex();
                value$iv$iv$iv = first$iv$iv$iv$iv.current();
                boolean bl6 = false;
                value$iv$iv = value$iv$iv$iv;
                boolean bl5 = false;
                it$iv = value$iv$iv;
                boolean bl4 = false;
                it = it$iv;
                boolean bl3 = false;
                hashes.add(it);
                if (!true) continue block0;
                first$iv$iv$iv$iv.advance();
            }
            while (second$iv$iv$iv$iv.isValid()) {
                index$iv$iv$iv = second$iv$iv$iv$iv.getIndex();
                value$iv$iv$iv = second$iv$iv$iv$iv.current();
                boolean n = false;
                value$iv$iv = value$iv$iv$iv;
                boolean bl22 = false;
                it$iv = value$iv$iv;
                boolean bl8 = false;
                it = it$iv;
                bl = false;
                hashes.add(it);
                if (!true) continue block0;
                second$iv$iv$iv$iv.advance();
            }
        }
        for (PwaFileStateWithId pwaFileStateWithId : directlyChanged) {
            hashes.remove(pwaFileStateWithId.getFileId());
        }
        IntArrayList dependencies = new IntArrayList((IntCollection)hashes);
        dependencies.unstableSort(IntComparators.NATURAL_COMPARATOR);
        return new HashesList(dependencies, false, 2, null);
    }

    private static final List execute$lambda$3(Ref.ObjectRef $status) {
        return CollectionsKt.listOf((Object)new EventPair((EventField)PwaCounterCollector.INSTANCE.getRESULT_STATUS_EVENT_FIELD(), $status.element));
    }

    private static final PwaFileStateWithId analyseFiles$lambda$9$lambda$8(PwaUpdateFilesTask this$0, int $fileId, PwaContext $context) {
        return this$0.doAnalysis($fileId, $context);
    }

    private static final void analyseFiles$lambda$9(PwaUpdateFilesTask this$0, PwaContext $context, List $statePromises, int fileId) {
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking(() -> PwaUpdateFilesTask.analyseFiles$lambda$9$lambda$8(this$0, fileId, $context)).inSmartMode(this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"inSmartMode(...)");
        NonBlockingReadAction nonBlockingAnalysis = nonBlockingReadAction;
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            nonBlockingAnalysis = nonBlockingAnalysis.expireWith((Disposable)$context.getDaemon()).wrapProgress(indicator);
        }
        CancellablePromise cancellablePromise = nonBlockingAnalysis.submit((Executor)$context.getAnalysisExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"submit(...)");
        $statePromises.add(cancellablePromise);
    }

    private static final void suggestDependenciesToAnalyze$lambda$13(IntOpenHashSet $hashes, int hash) {
        $hashes.add(hash);
    }

    private static final void suggestDependenciesToAnalyze$lambda$14(IntOpenHashSet $hashes, int hash) {
        $hashes.add(hash);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaUpdateFilesTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PwaUpdateFilesTask.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaUpdateFilesTask$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "analyseFile", "Lcom/intellij/analysis/pwa/analyser/PwaFileState;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "supportProviders", "", "Lcom/intellij/analysis/pwa/analyser/core/PwaProviderInfo;", "intellij.pwa.core"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        @Nullable
        public final PwaFileState analyseFile(@NotNull VirtualFile file, @NotNull PsiFile psiFile, @NotNull List<PwaProviderInfo> supportProviders) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter(supportProviders, (String)"supportProviders");
            long modificationCount = file.getTimeStamp();
            PwaFileState state = null;
            for (PwaProviderInfo supportProvider : supportProviders) {
                try {
                    boolean shouldAnalyse = PwaFileFilterKt.shouldAnalyseWithFastCheck(supportProvider.getFilter(), file, psiFile);
                    if (!shouldAnalyse) continue;
                    PwaFileData providerState = supportProvider.getExtractor().extract(file, psiFile);
                    int providersIdHash = PwaHashUtils.hashText(supportProvider.getId());
                    int providerVersionFingerprint = supportProvider.getVersion();
                    if (state == null) {
                        state = PwaFileState.Companion.from(providerState, modificationCount, providersIdHash, providerVersionFingerprint);
                        continue;
                    }
                    state = state.merge$intellij_pwa_core(providerState, providersIdHash, providerVersionFingerprint);
                }
                catch (Exception e) {
                    if (e instanceof ControlFlowException) {
                        throw e;
                    }
                    logger.warn("Exception thrown while project wide analysis update", (Throwable)e);
                }
            }
            return state;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

