/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.statistics;

import com.intellij.analysis.pwa.statistics.PwaStateCollectorKt;
import com.intellij.analysis.pwa.storage.PwaPaths;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/analysis/pwa/statistics/PwaStateCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "PWA_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "metadataIndexSize", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "stateIndexSize", "tasksIndexSize", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaStateCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaStateCollector.kt\ncom/intellij/analysis/pwa/statistics/PwaStateCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1216#2,2:55\n1246#2,4:57\n*S KotlinDebug\n*F\n+ 1 PwaStateCollector.kt\ncom/intellij/analysis/pwa/statistics/PwaStateCollector\n*L\n28#1:55,2\n28#1:57,4\n*E\n"})
public final class PwaStateCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup PWA_GROUP = new EventLogGroup("analysis.pwa", 4, null, 4, null);
    @NotNull
    private final EventId1<Long> metadataIndexSize = EventLogGroup.registerEvent$default((EventLogGroup)this.PWA_GROUP, (String)"index.metadata", (EventField)((EventField)EventFields.Long$default((String)"size_bytes", null, (int)2, null)), null, (int)4, null);
    @NotNull
    private final EventId1<Long> stateIndexSize = EventLogGroup.registerEvent$default((EventLogGroup)this.PWA_GROUP, (String)"index.state", (EventField)((EventField)EventFields.Long$default((String)"size_bytes", null, (int)2, null)), null, (int)4, null);
    @NotNull
    private final EventId1<Long> tasksIndexSize = EventLogGroup.registerEvent$default((EventLogGroup)this.PWA_GROUP, (String)"index.tasks", (EventField)((EventField)EventFields.Long$default((String)"size_bytes", null, (int)2, null)), null, (int)4, null);

    @NotNull
    public EventLogGroup getGroup() {
        return this.PWA_GROUP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HashSet<MetricEvent> events = new HashSet<MetricEvent>();
        Path projectIndexDirPath = PwaPaths.INSTANCE.getProjectIndexDirPath(project);
        if (!Files.exists(projectIndexDirPath, new LinkOption[0])) {
            return SetsKt.emptySet();
        }
        Closeable closeable = Files.newDirectoryStream(projectIndexDirPath);
        Throwable object2 = null;
        try {
            void $this$associateByTo$iv$iv;
            Object children = (DirectoryStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)children);
            Iterable $this$associateBy$iv = (Iterable)children;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Path path;
                Path path2 = (Path)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)path);
                path = (Path)element$iv$iv;
                String string = PathsKt.getName((Path)path);
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)path);
                Long l = StatisticsUtil.roundToPowerOfTwo((long)PwaStateCollectorKt.access$getSizeInBytes(path));
                map.put(string, l);
            }
            children = destination$iv$iv;
        }
        catch (Throwable children) {
            Throwable throwable = children;
            throw children;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, object2);
        }
        Object indexNameToSize = children;
        block16: for (Map.Entry entry : indexNameToSize.entrySet()) {
            MetricEvent metricEvent;
            String indexName = (String)entry.getKey();
            long size = ((Number)entry.getValue()).longValue();
            switch (indexName) {
                case "metadata": {
                    metricEvent = this.metadataIndexSize.metric((Object)size);
                    break;
                }
                case "state": {
                    metricEvent = this.stateIndexSize.metric((Object)size);
                    break;
                }
                case "tasks": {
                    metricEvent = this.tasksIndexSize.metric((Object)size);
                    break;
                }
                default: {
                    continue block16;
                }
            }
            MetricEvent event = metricEvent;
            events.add(event);
        }
        return events;
    }
}

