/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage;

import com.intellij.analysis.pwa.storage.PwaPaths;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/analysis/pwa/storage/PwaCachesInvalidator;", "Lcom/intellij/ide/caches/CachesInvalidator;", "<init>", "()V", "invalidateCaches", "", "Companion", "intellij.pwa.core"})
public final class PwaCachesInvalidator
extends CachesInvalidator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void invalidateCaches() {
        Collection<Path> dirs = PwaPaths.INSTANCE.getAllPwaDirectories();
        for (Path projectDir : dirs) {
            Path projectBrokenMarkerFilePath = PwaPaths.INSTANCE.getProjectBrokenMarkerFilePath(projectDir);
            FileUtil.createIfDoesntExist((File)projectBrokenMarkerFilePath.toFile());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/analysis/pwa/storage/PwaCachesInvalidator$Companion;", "", "<init>", "()V", "invalidateProjectCaches", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.pwa.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void invalidateProjectCaches(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path indexDirPath = PwaPaths.INSTANCE.getProjectIndexDirPath(project);
            Path projectBrokenMarkerFilePath = PwaPaths.INSTANCE.getProjectBrokenMarkerFilePath(indexDirPath);
            FileUtil.createIfDoesntExist((File)projectBrokenMarkerFilePath.toFile());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

