/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage;

import com.intellij.analysis.pwa.analyser.FileIdList;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaHighPriorityFilesSuggester;
import com.intellij.analysis.pwa.storage.RawAnalysisBatch;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0012J(\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u001eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/analysis/pwa/storage/PwaTaskCache;", "", "suggesters", "", "Lcom/intellij/analysis/pwa/analyser/PwaHighPriorityFilesSuggester;", "<init>", "(Ljava/util/List;)V", "toAnalyseOnly", "Ljava/util/BitSet;", "toAnalyseInvalidatingDeps", "markAnalyseFilesInvalidatingDependencies", "", "files", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "markAnalyseFilesOnly", "isEmpty", "", "getFilesToAnalyseCount", "", "removeAnalysisStatus", "filesToAnalyseOnly", "Lcom/intellij/analysis/pwa/analyser/FileIdList;", "filesToAnalyseInvalidatingDeps", "clear", "prepareBatch", "Lcom/intellij/analysis/pwa/storage/RawAnalysisBatch;", "taskSize", "dispatchPrioritizedFiles", "prioritizedFiles", "filesToFind", "Lit/unimi/dsi/fastutil/ints/IntSet;", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaTaskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaTaskCache.kt\ncom/intellij/analysis/pwa/storage/PwaTaskCache\n+ 2 PwaTaskCache.kt\ncom/intellij/analysis/pwa/storage/PwaTaskCacheKt\n*L\n1#1,129:1\n124#2,6:130\n124#2,6:136\n*S KotlinDebug\n*F\n+ 1 PwaTaskCache.kt\ncom/intellij/analysis/pwa/storage/PwaTaskCache\n*L\n80#1:130,6\n87#1:136,6\n*E\n"})
public final class PwaTaskCache {
    @NotNull
    private final List<PwaHighPriorityFilesSuggester> suggesters;
    @NotNull
    private final BitSet toAnalyseOnly;
    @NotNull
    private final BitSet toAnalyseInvalidatingDeps;

    public PwaTaskCache(@NotNull List<? extends PwaHighPriorityFilesSuggester> suggesters) {
        Intrinsics.checkNotNullParameter(suggesters, (String)"suggesters");
        this.suggesters = suggesters;
        this.toAnalyseOnly = new BitSet();
        this.toAnalyseInvalidatingDeps = new BitSet();
    }

    public final void markAnalyseFilesInvalidatingDependencies(@NotNull FileIdSet files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        files.forEach(arg_0 -> PwaTaskCache.markAnalyseFilesInvalidatingDependencies$lambda$0(this, arg_0));
    }

    public final void markAnalyseFilesOnly(@NotNull FileIdSet files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        files.forEach(arg_0 -> PwaTaskCache.markAnalyseFilesOnly$lambda$1(this, arg_0));
    }

    public final boolean isEmpty() {
        return this.toAnalyseOnly.isEmpty() && this.toAnalyseInvalidatingDeps.isEmpty();
    }

    public final int getFilesToAnalyseCount() {
        return this.toAnalyseOnly.cardinality() + this.toAnalyseInvalidatingDeps.cardinality();
    }

    public final void removeAnalysisStatus(@NotNull FileIdList filesToAnalyseOnly, @NotNull FileIdList filesToAnalyseInvalidatingDeps) {
        Intrinsics.checkNotNullParameter((Object)filesToAnalyseOnly, (String)"filesToAnalyseOnly");
        Intrinsics.checkNotNullParameter((Object)filesToAnalyseInvalidatingDeps, (String)"filesToAnalyseInvalidatingDeps");
        filesToAnalyseOnly.forEach(arg_0 -> PwaTaskCache.removeAnalysisStatus$lambda$2(this, arg_0));
        filesToAnalyseInvalidatingDeps.forEach(arg_0 -> PwaTaskCache.removeAnalysisStatus$lambda$3(this, arg_0));
    }

    public final void clear() {
        this.toAnalyseOnly.clear();
        this.toAnalyseInvalidatingDeps.clear();
    }

    @Nullable
    public final RawAnalysisBatch prepareBatch(int taskSize) {
        if (this.getFilesToAnalyseCount() == 0) {
            return null;
        }
        int filesToFind = 0;
        filesToFind = taskSize;
        IntOpenHashSet filesToAnalyseOnly = new IntOpenHashSet();
        IntOpenHashSet filesToAnalyseInvalidatingDeps = new IntOpenHashSet();
        for (PwaHighPriorityFilesSuggester suggester : this.suggesters) {
            FileIdSet prioritizedFiles;
            if (suggester.suggestFilesForPriorityAnalysis(filesToFind) != null && (filesToFind = this.dispatchPrioritizedFiles(prioritizedFiles, filesToFind, (IntSet)filesToAnalyseOnly, (IntSet)filesToAnalyseInvalidatingDeps)) == 0) break;
        }
        if (filesToFind > 0) {
            int it;
            BitSet $this$forEachShortCircuited$iv = this.toAnalyseInvalidatingDeps;
            boolean $i$f$forEachShortCircuited = false;
            int index$iv = $this$forEachShortCircuited$iv.nextSetBit(0);
            while (index$iv >= 0) {
                it = index$iv;
                boolean bl = false;
                if (filesToAnalyseInvalidatingDeps.add(it)) {
                    filesToFind += -1;
                }
                if (!(filesToFind > 0)) break;
                index$iv = $this$forEachShortCircuited$iv.nextSetBit(index$iv + 1);
            }
            if (filesToFind > 0) {
                $this$forEachShortCircuited$iv = this.toAnalyseOnly;
                $i$f$forEachShortCircuited = false;
                index$iv = $this$forEachShortCircuited$iv.nextSetBit(0);
                while (index$iv >= 0) {
                    it = index$iv;
                    boolean bl = false;
                    if (filesToAnalyseOnly.add(it)) {
                        filesToFind += -1;
                    }
                    if (!(filesToFind > 0)) break;
                    index$iv = $this$forEachShortCircuited$iv.nextSetBit(index$iv + 1);
                }
            }
        }
        if (!(taskSize >= filesToAnalyseOnly.size() + filesToAnalyseInvalidatingDeps.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new RawAnalysisBatch(new FileIdSet((IntSet)filesToAnalyseOnly), new FileIdSet((IntSet)filesToAnalyseInvalidatingDeps));
    }

    private final int dispatchPrioritizedFiles(FileIdSet prioritizedFiles, int filesToFind, IntSet filesToAnalyseOnly, IntSet filesToAnalyseInvalidatingDeps) {
        int newFilesToFind = filesToFind;
        IntIterator intIterator = prioritizedFiles.getStorage().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext() && newFilesToFind > 0) {
            int fileId = iterator.nextInt();
            boolean added = this.toAnalyseOnly.get(fileId) ? filesToAnalyseOnly.add(fileId) : (this.toAnalyseInvalidatingDeps.get(fileId) ? filesToAnalyseInvalidatingDeps.add(fileId) : false);
            if (!added) continue;
            --newFilesToFind;
        }
        return newFilesToFind;
    }

    private static final void markAnalyseFilesInvalidatingDependencies$lambda$0(PwaTaskCache this$0, int it) {
        this$0.toAnalyseOnly.clear(it);
        this$0.toAnalyseInvalidatingDeps.set(it);
    }

    private static final void markAnalyseFilesOnly$lambda$1(PwaTaskCache this$0, int it) {
        if (!this$0.toAnalyseInvalidatingDeps.get(it)) {
            this$0.toAnalyseOnly.set(it);
        }
    }

    private static final void removeAnalysisStatus$lambda$2(PwaTaskCache this$0, int it) {
        this$0.toAnalyseOnly.clear(it);
    }

    private static final void removeAnalysisStatus$lambda$3(PwaTaskCache this$0, int it) {
        this$0.toAnalyseInvalidatingDeps.clear(it);
    }
}

