/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage.indexes;

import com.intellij.analysis.pwa.analyser.FileIdList;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.HashesList;
import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.analyser.PwaFileState;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.storage.PwaFileStateStorage;
import com.intellij.analysis.pwa.storage.PwaFileStateWithId;
import com.intellij.analysis.pwa.storage.PwaPersistentFileWithProblems;
import com.intellij.analysis.pwa.storage.indexes.PwaDependenciesIndexExtension;
import com.intellij.analysis.pwa.storage.indexes.PwaFileDependencyInfo;
import com.intellij.analysis.pwa.storage.serialization.DeclaredSymbolsHashesListExternalizer;
import com.intellij.analysis.pwa.storage.serialization.FileStateExternalizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.KeyCollectionForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\"\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\u0016\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0'2\u0006\u0010(\u001a\u00020)H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u0016\u0010-\u001a\u0004\u0018\u00010\r2\n\u0010.\u001a\u00060\fj\u0002`/H\u0016J\b\u00100\u001a\u00020\u001aH\u0016J\b\u00101\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/PwaIndexFileStateStorage;", "Lcom/intellij/analysis/pwa/storage/PwaFileStateStorage;", "folderPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "isEmpty", "", "lock", "", "stateMap", "Lcom/intellij/util/io/PersistentHashMap;", "", "Lcom/intellij/analysis/pwa/analyser/PwaFileOwnState;", "globalSymbolsMap", "Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "dependenciesIndex", "Lcom/intellij/util/indexing/impl/MapReduceIndex;", "Lcom/intellij/analysis/pwa/storage/indexes/PwaFileDependencyInfo;", "myFlushingFuture", "Ljava/util/concurrent/ScheduledFuture;", "createStateMap", "path", "createGlobalSymbolsMap", "createMap", "setGlobalSymbols", "", "id", "hashes", "getGlobalSymbols", "updateStates", "changed", "", "Lcom/intellij/analysis/pwa/storage/PwaFileStateWithId;", "findFilesWithDependencies", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "nameHashes", "Lcom/intellij/analysis/pwa/analyser/HashesList;", "getStates", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "fileIds", "Lcom/intellij/analysis/pwa/analyser/FileIdList;", "getAllFilesWithProblems", "", "Lcom/intellij/analysis/pwa/storage/PwaPersistentFileWithProblems;", "getState", "fileId", "Lcom/intellij/analysis/pwa/analyser/VFileId;", "clear", "close", "Companion", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaIndexFileStateStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaIndexFileStateStorage.kt\ncom/intellij/analysis/pwa/storage/indexes/PwaIndexFileStateStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,185:1\n14#2:186\n*S KotlinDebug\n*F\n+ 1 PwaIndexFileStateStorage.kt\ncom/intellij/analysis/pwa/storage/indexes/PwaIndexFileStateStorage\n*L\n30#1:186\n*E\n"})
public final class PwaIndexFileStateStorage
implements PwaFileStateStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path folderPath;
    @NotNull
    private final Object lock;
    @NotNull
    private PersistentHashMap<Integer, PwaFileOwnState> stateMap;
    @NotNull
    private PersistentHashMap<Integer, SymbolHashesList> globalSymbolsMap;
    @NotNull
    private final MapReduceIndex<Integer, Integer, PwaFileDependencyInfo> dependenciesIndex;
    @NotNull
    private final ScheduledFuture<?> myFlushingFuture;
    private static final int CACHE_SIZE_BYTES = 16384;
    @NotNull
    private static final Logger logger;

    public PwaIndexFileStateStorage(@NotNull Path folderPath) {
        Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
        this.folderPath = folderPath;
        this.lock = new Object();
        this.stateMap = this.createStateMap(this.folderPath);
        this.globalSymbolsMap = this.createGlobalSymbolsMap(this.folderPath);
        this.dependenciesIndex = this.createMap(this.folderPath);
        this.myFlushingFuture = FlushingDaemon.runPeriodically(() -> PwaIndexFileStateStorage.myFlushingFuture$lambda$3(this));
    }

    @Override
    public boolean isEmpty() {
        return this.stateMap.processKeysWithExistingMapping(arg_0 -> PwaIndexFileStateStorage.isEmpty$lambda$1(PwaIndexFileStateStorage::isEmpty$lambda$0, arg_0));
    }

    private final PersistentHashMap<Integer, PwaFileOwnState> createStateMap(Path path) {
        return new PersistentHashMap(path.resolve("state"), (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)FileStateExternalizer.INSTANCE);
    }

    private final PersistentHashMap<Integer, SymbolHashesList> createGlobalSymbolsMap(Path path) {
        return new PersistentHashMap(path.resolve("globalSymbols"), (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)DeclaredSymbolsHashesListExternalizer.INSTANCE);
    }

    private final MapReduceIndex<Integer, Integer, PwaFileDependencyInfo> createMap(Path path) {
        Path storageFile = path.resolve("depsStorage");
        Path mapFile = path.resolve("depsMap");
        MapIndexStorage storage = new MapIndexStorage(storageFile, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)new IntInlineKeyDescriptor(), 16384, false, true, false, false, null);
        PersistentMapBasedForwardIndex forwardIndex = new PersistentMapBasedForwardIndex(mapFile, false);
        KeyCollectionForwardIndexAccessor forwardIndexAccessor = new KeyCollectionForwardIndexAccessor((IndexExtension)PwaDependenciesIndexExtension.INSTANCE);
        PwaDependenciesIndexExtension pwaDependenciesIndexExtension = PwaDependenciesIndexExtension.INSTANCE;
        return (MapReduceIndex)new MapReduceIndex<Integer, Integer, PwaFileDependencyInfo>((MapIndexStorage<Integer, Integer>)storage, forwardIndex, (KeyCollectionForwardIndexAccessor<Integer, Integer>)forwardIndexAccessor, pwaDependenciesIndexExtension){

            public void checkCanceled() {
                ProgressManager.checkCanceled();
            }

            protected void requestRebuild(Throwable e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalSymbols(int id, @NotNull SymbolHashesList hashes) {
        Intrinsics.checkNotNullParameter((Object)hashes, (String)"hashes");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.globalSymbolsMap.put((Object)id, (Object)hashes);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SymbolHashesList getGlobalSymbols(int id) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            SymbolHashesList symbolHashesList = (SymbolHashesList)this.globalSymbolsMap.get((Object)id);
            return symbolHashesList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStates(@NotNull Iterable<? extends PwaFileStateWithId> changed) {
        Intrinsics.checkNotNullParameter(changed, (String)"changed");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            for (PwaFileStateWithId pwaFileStateWithId : changed) {
                boolean bl2;
                int fileId = pwaFileStateWithId.getFileId();
                PwaFileState fileState = pwaFileStateWithId.getState();
                if (fileState == null) {
                    this.stateMap.remove((Object)fileId);
                    bl2 = this.dependenciesIndex.mapInputAndPrepareUpdate(fileId, null).update();
                    continue;
                }
                this.stateMap.put((Object)fileId, (Object)fileState.getOwnState());
                bl2 = this.dependenciesIndex.mapInputAndPrepareUpdate(fileId, (Object)new PwaFileDependencyInfo(fileId, fileState.getUsedSymbols())).update();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileIdSet findFilesWithDependencies(@NotNull HashesList nameHashes) {
        Intrinsics.checkNotNullParameter((Object)nameHashes, (String)"nameHashes");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            IntOpenHashSet files = new IntOpenHashSet();
            nameHashes.forEach(arg_0 -> PwaIndexFileStateStorage.findFilesWithDependencies$lambda$10$lambda$9(this, files, arg_0));
            FileIdSet fileIdSet = new FileIdSet((IntSet)files);
            return fileIdSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Int2ObjectMap<PwaFileOwnState> getStates(@NotNull FileIdList fileIds) {
        Intrinsics.checkNotNullParameter((Object)fileIds, (String)"fileIds");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Int2ObjectOpenHashMap states = new Int2ObjectOpenHashMap();
            fileIds.forEach(arg_0 -> PwaIndexFileStateStorage.getStates$lambda$12$lambda$11(states, this, arg_0));
            Int2ObjectMap int2ObjectMap = (Int2ObjectMap)states;
            return int2ObjectMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<PwaPersistentFileWithProblems> getAllFilesWithProblems() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ArrayList filesWithProblems = new ArrayList();
            this.stateMap.processKeysWithExistingMapping(arg_0 -> PwaIndexFileStateStorage.getAllFilesWithProblems$lambda$15$lambda$14(arg_0 -> PwaIndexFileStateStorage.getAllFilesWithProblems$lambda$15$lambda$13(this, filesWithProblems, arg_0), arg_0));
            List list = filesWithProblems;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PwaFileOwnState getState(int fileId) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            PwaFileOwnState pwaFileOwnState = (PwaFileOwnState)this.stateMap.get((Object)fileId);
            return pwaFileOwnState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.dependenciesIndex.clear();
            this.stateMap.closeAndClean();
            this.stateMap = this.createStateMap(this.folderPath);
            this.globalSymbolsMap.closeAndClean();
            this.globalSymbolsMap = this.createGlobalSymbolsMap(this.folderPath);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.myFlushingFuture.cancel(false);
            try {
                this.dependenciesIndex.flush();
                this.dependenciesIndex.dispose();
                this.stateMap.force();
                this.stateMap.close();
                this.globalSymbolsMap.force();
                this.globalSymbolsMap.close();
            }
            catch (Exception e) {
                logger.warn("Exception occurred while closing PWA state index", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean isEmpty$lambda$0(Integer it) {
        return false;
    }

    private static final boolean isEmpty$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void myFlushingFuture$lambda$3(PwaIndexFileStateStorage this$0) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.stateMap.isClosed()) {
                return;
            }
            try {
                this$0.stateMap.force();
                this$0.globalSymbolsMap.force();
                this$0.dependenciesIndex.flush();
            }
            catch (Exception e) {
                logger.warn("Error while flushing PWA indexes", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean findFilesWithDependencies$lambda$10$lambda$9$lambda$7(IntOpenHashSet $files, int n, Integer filesUsesDep) {
        Intrinsics.checkNotNull((Object)filesUsesDep);
        $files.add(filesUsesDep.intValue());
        return true;
    }

    private static final boolean findFilesWithDependencies$lambda$10$lambda$9$lambda$8(Function2 $tmp0, int p0, Object p1) {
        return (Boolean)$tmp0.invoke((Object)p0, p1);
    }

    private static final void findFilesWithDependencies$lambda$10$lambda$9(PwaIndexFileStateStorage this$0, IntOpenHashSet $files, int dependency) {
        this$0.dependenciesIndex.getData((Object)dependency).forEach((arg_0, arg_1) -> PwaIndexFileStateStorage.findFilesWithDependencies$lambda$10$lambda$9$lambda$8((arg_0, arg_1) -> PwaIndexFileStateStorage.findFilesWithDependencies$lambda$10$lambda$9$lambda$7($files, arg_0, arg_1), arg_0, arg_1));
    }

    private static final void getStates$lambda$12$lambda$11(Int2ObjectOpenHashMap $states, PwaIndexFileStateStorage this$0, int it) {
        Integer n = it;
        ((Map)$states).put(n, this$0.stateMap.get((Object)it));
    }

    private static final boolean getAllFilesWithProblems$lambda$15$lambda$13(PwaIndexFileStateStorage this$0, ArrayList $filesWithProblems, Integer it) {
        PwaFileOwnState state = (PwaFileOwnState)this$0.stateMap.get((Object)it);
        if (!((Collection)state.getProblems()).isEmpty()) {
            Intrinsics.checkNotNull((Object)it);
            $filesWithProblems.add(new PwaPersistentFileWithProblems(it, state.getProblems()));
        }
        return true;
    }

    private static final boolean getAllFilesWithProblems$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaIndexFileStateStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PwaIndexFileStateStorage.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003\u00a8\u0006\t"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/PwaIndexFileStateStorage$Companion;", "", "<init>", "()V", "CACHE_SIZE_BYTES", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "intellij.pwa.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

