/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage.indexes;

import com.intellij.analysis.pwa.storage.PwaMetadataStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorLongDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/PwaIndexMetadataStorage;", "Lcom/intellij/analysis/pwa/storage/PwaMetadataStorage;", "folderPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "imlToModCount", "Lcom/intellij/util/io/PersistentHashMap;", "", "", "lock", "", "myFlushingFuture", "Ljava/util/concurrent/ScheduledFuture;", "isSame", "", "Lit/unimi/dsi/fastutil/ints/Int2LongMap;", "putAll", "", "clear", "close", "createMap", "storagePath", "Companion", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaIndexMetadataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaIndexMetadataStorage.kt\ncom/intellij/analysis/pwa/storage/indexes/PwaIndexMetadataStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,84:1\n14#2:85\n*S KotlinDebug\n*F\n+ 1 PwaIndexMetadataStorage.kt\ncom/intellij/analysis/pwa/storage/indexes/PwaIndexMetadataStorage\n*L\n17#1:85\n*E\n"})
public final class PwaIndexMetadataStorage
implements PwaMetadataStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path folderPath;
    @NotNull
    private PersistentHashMap<Integer, Long> imlToModCount;
    @NotNull
    private final Object lock;
    @NotNull
    private final ScheduledFuture<?> myFlushingFuture;
    @NotNull
    private static final Logger logger;

    public PwaIndexMetadataStorage(@NotNull Path folderPath) {
        Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
        this.folderPath = folderPath;
        this.imlToModCount = this.createMap(this.folderPath);
        this.lock = new Object();
        this.myFlushingFuture = FlushingDaemon.runPeriodically(() -> PwaIndexMetadataStorage.myFlushingFuture$lambda$1(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSame(@NotNull Int2LongMap imlToModCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)imlToModCount, (String)"imlToModCount");
        Object object = this.lock;
        synchronized (object) {
            boolean dataFromStorageIsSame;
            block4: {
                boolean bl = false;
                Ref.IntRef size = new Ref.IntRef();
                dataFromStorageIsSame = this.imlToModCount.processKeysWithExistingMapping(arg_0 -> PwaIndexMetadataStorage.isSame$lambda$4$lambda$3(arg_0 -> PwaIndexMetadataStorage.isSame$lambda$4$lambda$2(size, this, imlToModCount, arg_0), arg_0));
                if (size.element == imlToModCount.size()) break block4;
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = dataFromStorageIsSame;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(@NotNull Int2LongMap imlToModCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)imlToModCount, (String)"imlToModCount");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            imlToModCount.forEach((arg_0, arg_1) -> PwaIndexMetadataStorage.putAll$lambda$6$lambda$5(this, arg_0, arg_1));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.imlToModCount.closeAndClean();
            this.imlToModCount = this.createMap(this.folderPath);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.myFlushingFuture.cancel(false);
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                this.imlToModCount.force();
                this.imlToModCount.close();
            }
            catch (IOException e) {
                logger.warn("Error while closing index", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final PersistentHashMap<Integer, Long> createMap(Path storagePath) {
        return new PersistentHashMap(storagePath.resolve("metadata"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorLongDescriptor.INSTANCE, 1024, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void myFlushingFuture$lambda$1(PwaIndexMetadataStorage this$0) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.imlToModCount.isClosed()) {
                return;
            }
            try {
                this$0.imlToModCount.force();
            }
            catch (Exception e) {
                logger.warn("Error while flushing PWA indexes", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean isSame$lambda$4$lambda$2(Ref.IntRef $size, PwaIndexMetadataStorage this$0, Int2LongMap $imlToModCount, Integer imlId) {
        int n = $size.element;
        $size.element = n + 1;
        Long savedModCount = (Long)this$0.imlToModCount.get((Object)imlId);
        Intrinsics.checkNotNull((Object)imlId);
        Long l = savedModCount;
        return l != null && $imlToModCount.get(imlId.intValue()) == l.longValue();
    }

    private static final boolean isSame$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void putAll$lambda$6$lambda$5(PwaIndexMetadataStorage this$0, Integer imlId, Long modCount) {
        this$0.imlToModCount.put((Object)imlId, (Object)modCount);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaIndexMetadataStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PwaIndexMetadataStorage.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/PwaIndexMetadataStorage$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "intellij.pwa.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

