/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage.indexes;

import com.intellij.analysis.pwa.analyser.FileIdList;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.storage.PwaAnalysisRequirementStatus;
import com.intellij.analysis.pwa.storage.PwaTaskStorage;
import com.intellij.analysis.pwa.storage.RawAnalysisBatch;
import com.intellij.analysis.pwa.storage.serialization.PwaAnalysisRequirementStatusExternalizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.file.Path;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/PwaIndexTaskStorage;", "Lcom/intellij/analysis/pwa/storage/PwaTaskStorage;", "folderPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "map", "Lcom/intellij/util/io/PersistentHashMap;", "", "Lcom/intellij/analysis/pwa/storage/PwaAnalysisRequirementStatus;", "lock", "", "myFlushingFuture", "Ljava/util/concurrent/ScheduledFuture;", "createMap", "markAnalyzeFilesInvalidatingDependencies", "", "files", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "markAnalyzeFilesOnly", "getAllFilesToAnalyse", "Lcom/intellij/analysis/pwa/storage/RawAnalysisBatch;", "removeAnalysisStatus", "filesToAnalyseOnly", "Lcom/intellij/analysis/pwa/analyser/FileIdList;", "filesToAnalyseInvalidatingDeps", "clear", "close", "Companion", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaIndexTaskStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaIndexTaskStorage.kt\ncom/intellij/analysis/pwa/storage/indexes/PwaIndexTaskStorage\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n14#2:116\n*S KotlinDebug\n*F\n+ 1 PwaIndexTaskStorage.kt\ncom/intellij/analysis/pwa/storage/indexes/PwaIndexTaskStorage\n*L\n21#1:116\n*E\n"})
public final class PwaIndexTaskStorage
implements PwaTaskStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path folderPath;
    @NotNull
    private PersistentHashMap<Integer, PwaAnalysisRequirementStatus> map;
    @NotNull
    private final Object lock;
    @NotNull
    private final ScheduledFuture<?> myFlushingFuture;
    @NotNull
    private static final Logger logger;

    public PwaIndexTaskStorage(@NotNull Path folderPath) {
        Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
        this.folderPath = folderPath;
        this.map = this.createMap();
        this.lock = new Object();
        this.myFlushingFuture = FlushingDaemon.runPeriodically(() -> PwaIndexTaskStorage.myFlushingFuture$lambda$1(this));
    }

    private final PersistentHashMap<Integer, PwaAnalysisRequirementStatus> createMap() {
        return new PersistentHashMap(this.folderPath.resolve("tasks"), (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)PwaAnalysisRequirementStatusExternalizer.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAnalyzeFilesInvalidatingDependencies(@NotNull FileIdSet files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            files.forEach(arg_0 -> PwaIndexTaskStorage.markAnalyzeFilesInvalidatingDependencies$lambda$3$lambda$2(this, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAnalyzeFilesOnly(@NotNull FileIdSet files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            files.forEach(arg_0 -> PwaIndexTaskStorage.markAnalyzeFilesOnly$lambda$5$lambda$4(this, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RawAnalysisBatch getAllFilesToAnalyse() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            IntSet filesToAnalyseOnly = (IntSet)new IntOpenHashSet();
            IntSet filesToAnalyseInvalidatingDeps = (IntSet)new IntOpenHashSet();
            this.map.processKeysWithExistingMapping(arg_0 -> PwaIndexTaskStorage.getAllFilesToAnalyse$lambda$8$lambda$7(arg_0 -> PwaIndexTaskStorage.getAllFilesToAnalyse$lambda$8$lambda$6(this, filesToAnalyseOnly, filesToAnalyseInvalidatingDeps, arg_0), arg_0));
            RawAnalysisBatch rawAnalysisBatch = new RawAnalysisBatch(new FileIdSet(filesToAnalyseOnly), new FileIdSet(filesToAnalyseInvalidatingDeps));
            return rawAnalysisBatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAnalysisStatus(@NotNull FileIdList filesToAnalyseOnly, @NotNull FileIdList filesToAnalyseInvalidatingDeps) {
        Intrinsics.checkNotNullParameter((Object)filesToAnalyseOnly, (String)"filesToAnalyseOnly");
        Intrinsics.checkNotNullParameter((Object)filesToAnalyseInvalidatingDeps, (String)"filesToAnalyseInvalidatingDeps");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            filesToAnalyseInvalidatingDeps.forEach(arg_0 -> PwaIndexTaskStorage.removeAnalysisStatus$lambda$11$lambda$9(this, arg_0));
            filesToAnalyseOnly.forEach(arg_0 -> PwaIndexTaskStorage.removeAnalysisStatus$lambda$11$lambda$10(this, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.map.closeAndClean();
            this.map = this.createMap();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.myFlushingFuture.cancel(false);
            try {
                this.map.force();
                this.map.close();
            }
            catch (Exception e) {
                logger.warn("Exception occurred while closing PWA task index", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void myFlushingFuture$lambda$1(PwaIndexTaskStorage this$0) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            if (this$0.map.isClosed()) {
                return;
            }
            try {
                this$0.map.force();
            }
            catch (Exception e) {
                logger.warn("Error while flushing PWA indexes", (Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void markAnalyzeFilesInvalidatingDependencies$lambda$3$lambda$2(PwaIndexTaskStorage this$0, int it) {
        this$0.map.put((Object)it, (Object)PwaAnalysisRequirementStatus.InvalidatingDependencies);
    }

    private static final void markAnalyzeFilesOnly$lambda$5$lambda$4(PwaIndexTaskStorage this$0, int it) {
        PwaAnalysisRequirementStatus oldStatus = (PwaAnalysisRequirementStatus)((Object)this$0.map.get((Object)it));
        if (oldStatus != PwaAnalysisRequirementStatus.InvalidatingDependencies) {
            this$0.map.put((Object)it, (Object)PwaAnalysisRequirementStatus.FileOnly);
        }
    }

    private static final boolean getAllFilesToAnalyse$lambda$8$lambda$6(PwaIndexTaskStorage this$0, IntSet $filesToAnalyseOnly, IntSet $filesToAnalyseInvalidatingDeps, Integer it) {
        Object object = this$0.map.get((Object)it);
        Intrinsics.checkNotNull((Object)object);
        return switch (WhenMappings.$EnumSwitchMapping$0[((PwaAnalysisRequirementStatus)((Object)object)).ordinal()]) {
            case 1 -> {
                Intrinsics.checkNotNull((Object)it);
                yield $filesToAnalyseOnly.add(it.intValue());
            }
            case 2 -> {
                Intrinsics.checkNotNull((Object)it);
                yield $filesToAnalyseInvalidatingDeps.add(it.intValue());
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean getAllFilesToAnalyse$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void removeAnalysisStatus$lambda$11$lambda$9(PwaIndexTaskStorage this$0, int it) {
        this$0.map.remove((Object)it);
    }

    private static final void removeAnalysisStatus$lambda$11$lambda$10(PwaIndexTaskStorage this$0, int it) {
        if (this$0.map.get((Object)it) == PwaAnalysisRequirementStatus.FileOnly) {
            this$0.map.remove((Object)it);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaIndexTaskStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PwaIndexTaskStorage.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u00a8\u0006\u0007"}, d2={"Lcom/intellij/analysis/pwa/storage/indexes/PwaIndexTaskStorage$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "intellij.pwa.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PwaAnalysisRequirementStatus.values().length];
            try {
                nArray[PwaAnalysisRequirementStatus.FileOnly.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PwaAnalysisRequirementStatus.InvalidatingDependencies.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

