/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage.rocksDb;

import com.intellij.analysis.pwa.storage.rocksDb.PwaRocksDbIOException;
import com.intellij.analysis.pwa.storage.rocksDb.PwaRocksDbWrapperKt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IoKt;
import com.intellij.util.lang.DirectByteBufferPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001(B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0012\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J>\u0010\u0015\u001a\u00020\u001626\u0010\u0017\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0019\u0012\b\b\b\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u0019\u0012\b\b\b\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00160\u0018J>\u0010\u001b\u001a\u00020\u001626\u0010\u001c\u001a2\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u0019\u0012\b\b\b\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u0019\u0012\b\b\b\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00160\u0018J\u001b\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u001fJ\n\u0010$\u001a\u0004\u0018\u00010\u0011H\u0002J\u0017\u0010%\u001a\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'H\u0082\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/analysis/pwa/storage/rocksDb/PwaRocksDbWrapper;", "K", "V", "", "db", "Lorg/rocksdb/RocksDB;", "pool", "Lcom/intellij/util/lang/DirectByteBufferPool;", "name", "", "keyExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "valueExternalizer", "<init>", "(Lorg/rocksdb/RocksDB;Lcom/intellij/util/lang/DirectByteBufferPool;Ljava/lang/String;Lcom/intellij/util/io/DataExternalizer;Lcom/intellij/util/io/DataExternalizer;)V", "lock", "family", "Lorg/rocksdb/ColumnFamilyHandle;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "process", "", "itemProcessor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "value", "processRaw", "itemHandler", "Ljava/nio/ByteBuffer;", "put", "", "(Ljava/lang/Object;Ljava/lang/Object;)V", "delete", "(Ljava/lang/Object;)V", "clear", "createFamily", "syncAndCatching", "b", "Lkotlin/Function0;", "Companion", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaRocksDbWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaRocksDbWrapper.kt\ncom/intellij/analysis/pwa/storage/rocksDb/PwaRocksDbWrapper\n*L\n1#1,133:1\n114#1,8:134\n114#1,8:142\n114#1,8:150\n114#1,8:158\n114#1,8:166\n*S KotlinDebug\n*F\n+ 1 PwaRocksDbWrapper.kt\ncom/intellij/analysis/pwa/storage/rocksDb/PwaRocksDbWrapper\n*L\n34#1:134,8\n53#1:142,8\n82#1:150,8\n91#1:158,8\n99#1:166,8\n*E\n"})
public final class PwaRocksDbWrapper<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RocksDB db;
    @NotNull
    private final DirectByteBufferPool pool;
    @NotNull
    private final String name;
    @NotNull
    private final DataExternalizer<K> keyExternalizer;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;
    @NotNull
    private final Object lock;
    @Nullable
    private ColumnFamilyHandle family;
    private static final int DEFAULT_VALUE_SIZE = 16384;

    public PwaRocksDbWrapper(@NotNull RocksDB db, @NotNull DirectByteBufferPool pool2, @NotNull String name, @NotNull DataExternalizer<K> keyExternalizer, @NotNull DataExternalizer<V> valueExternalizer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)pool2, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(keyExternalizer, (String)"keyExternalizer");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        this.db = db;
        this.pool = pool2;
        this.name = name;
        this.keyExternalizer = keyExternalizer;
        this.valueExternalizer = valueExternalizer;
        this.lock = new Object();
        this.family = this.createFamily();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V get(K key) throws IOException {
        PwaRocksDbWrapper this_$iv = this;
        boolean $i$f$syncAndCatching = false;
        try {
            Object object = this_$iv.lock;
            synchronized (object) {
                byte[] byArray;
                block6: {
                    boolean bl = false;
                    boolean bl2 = false;
                    byte[] keyBytes = PwaRocksDbWrapperKt.access$serialize(this.keyExternalizer, key);
                    if (this.db.get(this.family, keyBytes) != null) break block6;
                    V v = null;
                    return v;
                }
                byte[] valueBytes = byArray;
                Object object2 = PwaRocksDbWrapperKt.access$deserialize(this.valueExternalizer, valueBytes);
                return (V)object2;
            }
        }
        catch (RocksDBException e$iv) {
            throw new PwaRocksDbIOException(e$iv);
        }
    }

    public final boolean process(@NotNull Function2<? super K, ? super V, Boolean> itemProcessor) throws IOException {
        Intrinsics.checkNotNullParameter(itemProcessor, (String)"itemProcessor");
        return this.processRaw((Function2<ByteBuffer, ByteBuffer, Boolean>)((Function2)(arg_0, arg_1) -> PwaRocksDbWrapper.process$lambda$1(itemProcessor, this, arg_0, arg_1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean processRaw(@NotNull Function2<? super ByteBuffer, ? super ByteBuffer, Boolean> itemHandler) throws IOException {
        Intrinsics.checkNotNullParameter(itemHandler, (String)"itemHandler");
        PwaRocksDbWrapper this_$iv = this;
        boolean $i$f$syncAndCatching = false;
        try {
            Object object = this_$iv.lock;
            synchronized (object) {
                block14: {
                    boolean bl;
                    Throwable throwable;
                    AutoCloseable autoCloseable;
                    block13: {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        autoCloseable = this.db.newIterator(this.family);
                        throwable = null;
                        try {
                            RocksIterator iterator = (RocksIterator)autoCloseable;
                            boolean bl4 = false;
                            iterator.seekToFirst();
                            while (iterator.isValid()) {
                                ByteBuffer valueBuffer;
                                ByteBuffer keyBuffer;
                                Intrinsics.checkNotNullExpressionValue((Object)this.pool.allocate(4), (String)"allocate(...)");
                                iterator.key(keyBuffer);
                                Intrinsics.checkNotNullExpressionValue((Object)this.pool.allocate(16384), (String)"allocate(...)");
                                int size = iterator.value(valueBuffer);
                                if (size > 16384) {
                                    this.pool.release(valueBuffer);
                                    valueBuffer = this.pool.allocate(size);
                                    iterator.value(valueBuffer);
                                }
                                boolean shouldContinue = (Boolean)itemHandler.invoke((Object)keyBuffer, (Object)valueBuffer);
                                this.pool.release(keyBuffer);
                                this.pool.release(valueBuffer);
                                if (!shouldContinue) {
                                    boolean bl5 = false;
                                    bl = bl5;
                                    break block13;
                                }
                                iterator.next();
                            }
                            Unit unit = Unit.INSTANCE;
                            break block14;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    return bl;
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
                Unit unit = Unit.INSTANCE;
                return true;
            }
        }
        catch (RocksDBException e$iv) {
            throw new PwaRocksDbIOException(e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(K key, V value) throws IOException {
        PwaRocksDbWrapper this_$iv = this;
        boolean $i$f$syncAndCatching = false;
        try {
            Object object = this_$iv.lock;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = false;
                byte[] keyBytes = PwaRocksDbWrapperKt.access$serialize(this.keyExternalizer, key);
                byte[] valueBytes = PwaRocksDbWrapperKt.access$serialize(this.valueExternalizer, value);
                this.db.put(this.family, keyBytes, valueBytes);
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (RocksDBException e$iv) {
            throw new PwaRocksDbIOException(e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete(K key) throws IOException {
        PwaRocksDbWrapper this_$iv = this;
        boolean $i$f$syncAndCatching = false;
        try {
            Object object = this_$iv.lock;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = false;
                byte[] keyBytes = PwaRocksDbWrapperKt.access$serialize(this.keyExternalizer, key);
                this.db.delete(this.family, keyBytes);
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (RocksDBException e$iv) {
            throw new PwaRocksDbIOException(e$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws IOException {
        PwaRocksDbWrapper this_$iv = this;
        boolean $i$f$syncAndCatching = false;
        try {
            Object object = this_$iv.lock;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = false;
                this.db.dropColumnFamily(this.family);
                this.family = this.createFamily();
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (RocksDBException e$iv) {
            throw new PwaRocksDbIOException(e$iv);
        }
    }

    private final ColumnFamilyHandle createFamily() {
        try {
            byte[] byArray = this.name.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return this.db.createColumnFamily(new ColumnFamilyDescriptor(byArray));
        }
        catch (RocksDBException e) {
            throw new PwaRocksDbIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void syncAndCatching(Function0<Unit> b) {
        boolean $i$f$syncAndCatching = false;
        try {
            Object object = this.lock;
            synchronized (object) {
                try {
                    boolean bl = false;
                    b.invoke();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 5] lbl16 : MonitorExitStatement: MONITOREXIT : var4_3
                    InlineMarker.finallyEnd((int)1);
                }
            }
        }
        catch (RocksDBException e) {
            throw new PwaRocksDbIOException(e);
        }
        {
            return;
        }
    }

    private static final boolean process$lambda$1(Function2 $itemProcessor, PwaRocksDbWrapper this$0, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
        Intrinsics.checkNotNullParameter((Object)keyBuffer, (String)"keyBuffer");
        Intrinsics.checkNotNullParameter((Object)valueBuffer, (String)"valueBuffer");
        byte[] keyBytes = IoKt.toByteArray$default((ByteBuffer)keyBuffer, (boolean)false, (int)1, null);
        byte[] valueBytes = IoKt.toByteArray$default((ByteBuffer)valueBuffer, (boolean)false, (int)1, null);
        return (Boolean)$itemProcessor.invoke(PwaRocksDbWrapperKt.access$deserialize(this$0.keyExternalizer, keyBytes), PwaRocksDbWrapperKt.access$deserialize(this$0.valueExternalizer, valueBytes));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/analysis/pwa/storage/rocksDb/PwaRocksDbWrapper$Companion;", "", "<init>", "()V", "DEFAULT_VALUE_SIZE", "", "intellij.pwa.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

