/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.utils;

import com.intellij.analysis.pwa.utils.ListAccessor;
import com.intellij.util.io.DataInputOutputUtil;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/analysis/pwa/utils/ByteBufferListAccessor;", "Lcom/intellij/analysis/pwa/utils/ListAccessor;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "size", "", "index", "getIndex", "()I", "setIndex", "(I)V", "cached", "current", "advance", "", "isValid", "", "readInt", "intellij.pwa.core"})
public final class ByteBufferListAccessor
implements ListAccessor {
    @NotNull
    private final ByteBuffer buffer;
    private final int size;
    private int index;
    private int cached;

    public ByteBufferListAccessor(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.size = this.readInt();
        this.cached = this.size == 0 ? Integer.MIN_VALUE : this.readInt();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int current() {
        return this.cached;
    }

    @Override
    public void advance() {
        int n = this.getIndex();
        this.setIndex(n + 1);
        this.cached = this.isValid() ? this.readInt() : Integer.MIN_VALUE;
    }

    @Override
    public boolean isValid() {
        return this.getIndex() < this.size;
    }

    private final int readInt() {
        return DataInputOutputUtil.readINT((ByteBuffer)this.buffer);
    }
}

