/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.utils;

import com.intellij.openapi.util.text.StringHash;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0007JA\u0010\f\u001a\u00020\u0005\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00050\u0012H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J<\u0010\f\u001a\u00020\u0005\"\u0004\b\u0000\u0010\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u00152\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00050\u0012H\u0086\b\u00f8\u0001\u0000J\u0012\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0019"}, d2={"Lcom/intellij/analysis/pwa/utils/PwaHashUtils;", "", "<init>", "()V", "EMPTY", "", "hashAssociative", "hash1", "hash2", "combineHash", "lhs", "rhs", "hash", "T", "arr", "", "noElementsHash", "hasher", "Lkotlin/Function1;", "([Ljava/lang/Object;ILkotlin/jvm/functions/Function1;)I", "iterable", "", "hashText", "text", "", "intellij.pwa.core"})
public final class PwaHashUtils {
    @NotNull
    public static final PwaHashUtils INSTANCE = new PwaHashUtils();
    private static final int EMPTY = 59;

    private PwaHashUtils() {
    }

    @JvmStatic
    public static final int hashAssociative(int hash1, int hash2) {
        return hash1 + hash2;
    }

    @JvmStatic
    public static final int combineHash(int lhs, int rhs) {
        return lhs ^ rhs + -1640531527 + (lhs << 6) + (lhs >> 2);
    }

    public final <T> int hash(@NotNull T[] arr, int noElementsHash, @NotNull Function1<? super T, Integer> hasher) {
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        Intrinsics.checkNotNullParameter(hasher, (String)"hasher");
        boolean $i$f$hash = false;
        int hash = noElementsHash;
        for (T el : arr) {
            hash = PwaHashUtils.combineHash(hash, ((Number)hasher.invoke(el)).intValue());
        }
        return hash;
    }

    public final <T> int hash(@NotNull Iterable<? extends T> iterable, int noElementsHash, @NotNull Function1<? super T, Integer> hasher) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        Intrinsics.checkNotNullParameter(hasher, (String)"hasher");
        boolean $i$f$hash = false;
        int hash = noElementsHash;
        for (T el : iterable) {
            hash = PwaHashUtils.combineHash(hash, ((Number)hasher.invoke(el)).intValue());
        }
        return hash;
    }

    @JvmStatic
    public static final int hashText(@Nullable String text) {
        if (text == null) {
            return 59;
        }
        return StringHash.murmur((CharSequence)text);
    }
}

