/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.utils;

import com.intellij.analysis.pwa.PwaInternalSettings;
import com.intellij.analysis.pwa.utils.IntArrayListAccessor;
import com.intellij.analysis.pwa.utils.ListAccessor;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jz\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0004\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00050\f2\u0014\b\u0004\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00050\f2(\b\u0004\u0010\u000f\u001a\"\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\rj\u0002`\u0011\u0012\b\u0012\u00060\rj\u0002`\u0011\u0012\u0004\u0012\u00020\u00050\u0010H\u0086\b\u00f8\u0001\u0000J\u00f7\u0001\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2<\b\u0004\u0010\u0015\u001a6\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0017\u0012\u00150\rj\u0002`\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00050\u00162<\b\u0004\u0010\u001b\u001a6\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0017\u0012\u00150\rj\u0002`\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00050\u00162U\b\u0004\u0010\u001c\u001aO\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0017\u0012\u00150\rj\u0002`\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001d\u0012\u0017\u0012\u00150\rj\u0002`\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00050\u0010H\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0007J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0007J\u0016\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007J(\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J \u0010(\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0002J\u00e9\u0001\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020)2:\u0010\u0015\u001a6\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0017\u0012\u00150\rj\u0002`\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\n0\u00162:\u0010\u001b\u001a6\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0017\u0012\u00150\rj\u0002`\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\n0\u00162S\u0010\u001c\u001aO\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0017\u0012\u00150\rj\u0002`\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001d\u0012\u0017\u0012\u00150\rj\u0002`\u0011\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\n0\u0010H\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006*"}, d2={"Lcom/intellij/analysis/pwa/utils/PwaIntListUtils;", "", "<init>", "()V", "diff", "", "previous", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "current", "sanityChecksMayRun", "", "onAdd", "Lkotlin/Function1;", "", "onRemove", "onSame", "Lkotlin/Function3;", "Lcom/intellij/analysis/pwa/utils/ArrayIndex;", "syncSortedBypass", "first", "second", "onFirstEl", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "value", "index", "onSecondEl", "onBothEl", "firstIndex", "secondIndex", "isSortedDistinct", "sortDistinct", "list", "sortInPlace", "array", "work", "swapBoth", "i", "j", "swap", "Lcom/intellij/analysis/pwa/utils/ListAccessor;", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nPwaIntListUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PwaIntListUtils.kt\ncom/intellij/analysis/pwa/utils/PwaIntListUtils\n+ 2 PwaInternalSettings.kt\ncom/intellij/analysis/pwa/PwaInternalSettingsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n58#1,2:224\n60#1,5:230\n137#1,6:235\n66#1,2:241\n143#1,4:243\n70#1,2:247\n147#1,4:249\n74#1,2:253\n151#1,14:255\n78#1:269\n137#1,28:278\n23#2,4:216\n23#2,4:220\n23#2,4:226\n23#2,4:270\n23#2,4:274\n1734#3,3:306\n*S KotlinDebug\n*F\n+ 1 PwaIntListUtils.kt\ncom/intellij/analysis/pwa/utils/PwaIntListUtils\n*L\n39#1:224,2\n39#1:230,5\n39#1:235,6\n39#1:241,2\n39#1:243,4\n39#1:247,2\n39#1:249,4\n39#1:253,2\n39#1:255,14\n39#1:269\n62#1:278,28\n36#1:216,4\n37#1:220,4\n39#1:226,4\n59#1:270,4\n60#1:274,4\n82#1:306,3\n*E\n"})
public final class PwaIntListUtils {
    @NotNull
    public static final PwaIntListUtils INSTANCE = new PwaIntListUtils();

    private PwaIntListUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final void diff(@NotNull IntArrayList previous, @NotNull IntArrayList current, boolean sanityChecksMayRun, @NotNull Function1<? super Integer, Unit> onAdd, @NotNull Function1<? super Integer, Unit> onRemove, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Unit> onSame) {
        block21: {
            int firstIndex$iv;
            boolean bl;
            int n;
            int index$iv;
            boolean bl2;
            int value;
            boolean bl3;
            int value$iv;
            void second$iv$iv;
            void first$iv$iv;
            Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            Intrinsics.checkNotNullParameter(onAdd, (String)"onAdd");
            Intrinsics.checkNotNullParameter(onRemove, (String)"onRemove");
            Intrinsics.checkNotNullParameter(onSame, (String)"onSame");
            boolean $i$f$diff = false;
            if (sanityChecksMayRun) {
                boolean $i$f$ensure = false;
                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                    boolean bl4 = false;
                    if (!INSTANCE.isSortedDistinct(previous)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
                $i$f$ensure = false;
                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                    boolean bl5 = false;
                    if (!INSTANCE.isSortedDistinct(current)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
            }
            PwaIntListUtils this_$iv = this;
            boolean $i$f$syncSortedBypass = false;
            if (sanityChecksMayRun) {
                boolean $i$f$ensure = false;
                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                    boolean bl6 = false;
                    if (!(CollectionsKt.sorted((Iterable)((Iterable)previous)).size() == previous.size())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
                $i$f$ensure = false;
                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                    boolean bl7 = false;
                    if (!(CollectionsKt.sorted((Iterable)((Iterable)current)).size() == current.size())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
            }
            PwaIntListUtils $i$f$ensure = this_$iv;
            ListAccessor bl7 = new IntArrayListAccessor(previous);
            ListAccessor listAccessor = new IntArrayListAccessor(current);
            boolean $i$f$syncSortedBypass2 = false;
            while (first$iv$iv.isValid() && second$iv$iv.isValid()) {
                int firstElem$iv$iv = first$iv$iv.current();
                int secondElem$iv$iv = second$iv$iv.current();
                if (firstElem$iv$iv < secondElem$iv$iv) {
                    int n2 = first$iv$iv.getIndex();
                    value$iv = firstElem$iv$iv;
                    bl3 = false;
                    value = value$iv;
                    bl2 = false;
                    onRemove.invoke((Object)value);
                    if (true) {
                        first$iv$iv.advance();
                        continue;
                    }
                } else if (firstElem$iv$iv > secondElem$iv$iv) {
                    index$iv = second$iv$iv.getIndex();
                    value$iv = secondElem$iv$iv;
                    n = 0;
                    value = value$iv;
                    bl = false;
                    onAdd.invoke((Object)value);
                    if (true) {
                        second$iv$iv.advance();
                        continue;
                    }
                } else {
                    void currentIndex;
                    void previousIndex;
                    void secondIndex$iv;
                    n = second$iv$iv.getIndex();
                    index$iv = first$iv$iv.getIndex();
                    value$iv = firstElem$iv$iv;
                    boolean bl8 = false;
                    bl = secondIndex$iv;
                    int n3 = firstIndex$iv;
                    value = value$iv;
                    boolean bl9 = false;
                    onSame.invoke((Object)value, (Object)((int)previousIndex), (Object)((int)currentIndex));
                    if (true) {
                        first$iv$iv.advance();
                        second$iv$iv.advance();
                        continue;
                    }
                }
                break block21;
            }
            while (first$iv$iv.isValid()) {
                firstIndex$iv = first$iv$iv.getIndex();
                value$iv = first$iv$iv.current();
                bl3 = false;
                value = value$iv;
                bl2 = false;
                onRemove.invoke((Object)value);
                if (true) {
                    first$iv$iv.advance();
                    continue;
                }
                break block21;
            }
            while (second$iv$iv.isValid()) {
                index$iv = second$iv$iv.getIndex();
                value$iv = second$iv$iv.current();
                n = 0;
                value = value$iv;
                bl = false;
                onAdd.invoke((Object)value);
                if (!true) break;
                second$iv$iv.advance();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void syncSortedBypass(@NotNull IntArrayList first, @NotNull IntArrayList second, boolean sanityChecksMayRun, @NotNull Function2<? super Integer, ? super Integer, Unit> onFirstEl, @NotNull Function2<? super Integer, ? super Integer, Unit> onSecondEl, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Unit> onBothEl) {
        block16: {
            int firstIndex;
            int n;
            int index;
            boolean bl;
            int value;
            void second$iv;
            void first$iv;
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            Intrinsics.checkNotNullParameter(onFirstEl, (String)"onFirstEl");
            Intrinsics.checkNotNullParameter(onSecondEl, (String)"onSecondEl");
            Intrinsics.checkNotNullParameter(onBothEl, (String)"onBothEl");
            boolean $i$f$syncSortedBypass = false;
            if (sanityChecksMayRun) {
                boolean $i$f$ensure = false;
                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                    boolean bl2 = false;
                    if (!(CollectionsKt.sorted((Iterable)((Iterable)first)).size() == first.size())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
                $i$f$ensure = false;
                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                    boolean bl3 = false;
                    if (!(CollectionsKt.sorted((Iterable)((Iterable)second)).size() == second.size())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
            }
            PwaIntListUtils $i$f$ensure = this;
            ListAccessor bl3 = new IntArrayListAccessor(first);
            ListAccessor listAccessor = new IntArrayListAccessor(second);
            boolean $i$f$syncSortedBypass2 = false;
            while (first$iv.isValid() && second$iv.isValid()) {
                int firstElem$iv = first$iv.current();
                int secondElem$iv = second$iv.current();
                if (firstElem$iv < secondElem$iv) {
                    int n2 = first$iv.getIndex();
                    value = firstElem$iv;
                    bl = false;
                    onFirstEl.invoke((Object)value, (Object)index);
                    if (true) {
                        first$iv.advance();
                        continue;
                    }
                } else if (firstElem$iv > secondElem$iv) {
                    index = second$iv.getIndex();
                    value = secondElem$iv;
                    n = 0;
                    onSecondEl.invoke((Object)value, (Object)index);
                    if (true) {
                        second$iv.advance();
                        continue;
                    }
                } else {
                    void secondIndex;
                    n = second$iv.getIndex();
                    index = first$iv.getIndex();
                    value = firstElem$iv;
                    boolean bl4 = false;
                    onBothEl.invoke((Object)value, (Object)firstIndex, (Object)((int)secondIndex));
                    if (true) {
                        first$iv.advance();
                        second$iv.advance();
                        continue;
                    }
                }
                break block16;
            }
            while (first$iv.isValid()) {
                firstIndex = first$iv.getIndex();
                value = first$iv.current();
                bl = false;
                onFirstEl.invoke((Object)value, (Object)index);
                if (true) {
                    first$iv.advance();
                    continue;
                }
                break block16;
            }
            while (second$iv.isValid()) {
                index = second$iv.getIndex();
                value = second$iv.current();
                n = 0;
                onSecondEl.invoke((Object)value, (Object)index);
                if (!true) break;
                second$iv.advance();
            }
        }
    }

    public final boolean isSortedDistinct(@NotNull IntArrayList first) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            int prev = 0;
            prev = Integer.MIN_VALUE;
            Iterable $this$all$iv = (Iterable)first;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    Integer it = (Integer)element$iv;
                    boolean bl3 = false;
                    if (prev >= it) {
                        bl2 = false;
                    } else {
                        prev = it;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Contract(pure=true)
    @NotNull
    public final IntArrayList sortDistinct(@NotNull IntArrayList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        if (!list.isEmpty()) {
            list.sort(IntComparators.NATURAL_COMPARATOR);
            Ref.IntRef previous = new Ref.IntRef();
            previous.element = list.getInt(0) + 1;
            IntArrayList newList = new IntArrayList();
            list.forEach(arg_0 -> PwaIntListUtils.sortDistinct$lambda$11(previous, newList, arg_0));
            return newList;
        }
        return list;
    }

    public final void sortInPlace(@NotNull IntArrayList array, @NotNull IntArrayList work) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        boolean bl2 = bl = array.size() == work.size() && array != work;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (array.size() == 0) {
            return;
        }
        Arrays.quickSort((int)0, (int)array.size(), (arg_0, arg_1) -> PwaIntListUtils.sortInPlace$lambda$12(array, arg_0, arg_1), (arg_0, arg_1) -> PwaIntListUtils.sortInPlace$lambda$13(array, work, arg_0, arg_1));
    }

    private final void swapBoth(int i, int j, IntArrayList array, IntArrayList work) {
        this.swap(array, i, j);
        this.swap(work, i, j);
    }

    private final void swap(IntArrayList array, int i, int j) {
        int temp = array.getInt(i);
        array.set(i, array.getInt(j));
        array.set(j, temp);
    }

    public final void syncSortedBypass(@NotNull ListAccessor first, @NotNull ListAccessor second, @NotNull Function2<? super Integer, ? super Integer, Boolean> onFirstEl, @NotNull Function2<? super Integer, ? super Integer, Boolean> onSecondEl, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Boolean> onBothEl) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Intrinsics.checkNotNullParameter(onFirstEl, (String)"onFirstEl");
        Intrinsics.checkNotNullParameter(onSecondEl, (String)"onSecondEl");
        Intrinsics.checkNotNullParameter(onBothEl, (String)"onBothEl");
        boolean $i$f$syncSortedBypass = false;
        while (first.isValid() && second.isValid()) {
            int firstElem = first.current();
            int secondElem = second.current();
            if (firstElem < secondElem) {
                if (!((Boolean)onFirstEl.invoke((Object)firstElem, (Object)first.getIndex())).booleanValue()) {
                    return;
                }
                first.advance();
                continue;
            }
            if (firstElem > secondElem) {
                if (!((Boolean)onSecondEl.invoke((Object)secondElem, (Object)second.getIndex())).booleanValue()) {
                    return;
                }
                second.advance();
                continue;
            }
            if (!((Boolean)onBothEl.invoke((Object)firstElem, (Object)first.getIndex(), (Object)second.getIndex())).booleanValue()) {
                return;
            }
            first.advance();
            second.advance();
        }
        while (first.isValid()) {
            if (!((Boolean)onFirstEl.invoke((Object)first.current(), (Object)first.getIndex())).booleanValue()) {
                return;
            }
            first.advance();
        }
        while (second.isValid()) {
            if (!((Boolean)onSecondEl.invoke((Object)second.current(), (Object)second.getIndex())).booleanValue()) {
                return;
            }
            second.advance();
        }
    }

    private static final void sortDistinct$lambda$11(Ref.IntRef $previous, IntArrayList $newList, int it) {
        if ($previous.element != it) {
            $newList.add(it);
        }
        $previous.element = it;
    }

    private static final int sortInPlace$lambda$12(IntArrayList $array, int i1, int i2) {
        return Intrinsics.compare((int)$array.getInt(i1), (int)$array.getInt(i2));
    }

    private static final void sortInPlace$lambda$13(IntArrayList $array, IntArrayList $work, int i1, int i2) {
        INSTANCE.swapBoth(i1, i2, $array, $work);
    }
}

