/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.utils;

import com.intellij.analysis.pwa.analyser.PwaFileWithProblems;
import com.intellij.analysis.pwa.analyser.PwaProblem;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0007J\b\u0010\n\u001a\u00020\u0006H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/pwa/utils/TestErrorStorage;", "", "<init>", "()V", "problems", "", "", "Lcom/intellij/analysis/pwa/analyser/PwaFileWithProblems;", "update", "", "toString", "intellij.pwa.core"})
public final class TestErrorStorage {
    @NotNull
    private final Map<String, PwaFileWithProblems> problems;

    public TestErrorStorage() {
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.problems = map;
    }

    public final void update(@NotNull PwaFileWithProblems problems) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        this.problems.put(problems.getFile().getPath(), problems);
    }

    @NotNull
    public String toString() {
        StringJoiner joiner = new StringJoiner("\n----\n");
        for (Map.Entry<String, PwaFileWithProblems> entry : this.problems.entrySet()) {
            String path = entry.getKey();
            PwaFileWithProblems problems = entry.getValue();
            if (problems.getProblems().isEmpty()) continue;
            Iterable iterable = problems.getProblems();
            Comparator<Object> comparator = Comparator.comparingInt(arg_0 -> TestErrorStorage.toString$lambda$1(TestErrorStorage::toString$lambda$0, arg_0)).thenComparingInt(arg_0 -> TestErrorStorage.toString$lambda$3(TestErrorStorage::toString$lambda$2, arg_0)).thenComparing(arg_0 -> TestErrorStorage.toString$lambda$5(TestErrorStorage::toString$lambda$4, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
            String fileErrors = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)iterable, comparator), (CharSequence)"\n", null, null, (int)0, null, TestErrorStorage::toString$lambda$6, (int)30, null);
            joiner.add(path + ":\n" + fileErrors);
        }
        String string = joiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final int toString$lambda$0(PwaProblem it) {
        return it.getLine();
    }

    private static final int toString$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int toString$lambda$2(PwaProblem it) {
        return it.getColumn();
    }

    private static final int toString$lambda$3(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final String toString$lambda$4(PwaProblem problem) {
        return problem.getText();
    }

    private static final String toString$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final CharSequence toString$lambda$6(PwaProblem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }
}

