/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.utils;

import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0001\u00a8\u0006\t"}, d2={"collectAnalyzableFileIdsUnderRoot", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "Lit/unimi/dsi/fastutil/ints/IntSet;", "filters", "", "Lcom/intellij/analysis/pwa/support/PwaFileFilter;", "intellij.pwa.core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/analysis/pwa/utils/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,23:1\n1755#2,3:24\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/intellij/analysis/pwa/utils/UtilsKt\n*L\n18#1:24,3\n*E\n"})
public final class UtilsKt {
    @RequiresReadLock
    public static final void collectAnalyzableFileIdsUnderRoot(@NotNull VirtualFile root, @NotNull IntSet files, @NotNull List<? extends PwaFileFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        VfsUtil.iterateChildrenRecursively((VirtualFile)root, UtilsKt::collectAnalyzableFileIdsUnderRoot$lambda$0, arg_0 -> UtilsKt.collectAnalyzableFileIdsUnderRoot$lambda$2(filters, files, arg_0));
    }

    private static final boolean collectAnalyzableFileIdsUnderRoot$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean collectAnalyzableFileIdsUnderRoot$lambda$2(List $filters, IntSet $files, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ProgressManager.checkCanceled();
        if (file instanceof VirtualFileWithId) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = $filters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PwaFileFilter filter = (PwaFileFilter)element$iv;
                        boolean bl2 = false;
                        if (!filter.fastShouldAnalyse(file)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                $files.add(((VirtualFileWithId)file).getId());
            }
        }
        return true;
    }
}

