/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.action;

import com.intellij.flyway.FlywayCreator;
import com.intellij.flyway.FlywayHelper;
import com.intellij.flyway.JavaMigrationModel;
import com.intellij.flyway.msg.FlywayResourceBundle;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.ui.dialog.ClassAndPackageCreationDialog;
import com.intellij.jpa.jpb.model.ui.dialog.StudioElementCreationGridDialog;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBTextField;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u0012\u001a\u00020\rH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/flyway/action/FlywayJavaMigrationDialog;", "Lcom/intellij/jpa/jpb/model/ui/dialog/ClassAndPackageCreationDialog;", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiDirectory;)V", "setupComponents", "", "setupTopPanel", "getPackageRecentKey", "", "getClassNameErrorMessage", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "createResult", "getHelpId", "Companion", "intellij.flyway"})
public final class FlywayJavaMigrationDialog
extends ClassAndPackageCreationDialog<PsiFile> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RECENT_KEY = "FlywayJavaMigrationDialog.RecentKey";

    public FlywayJavaMigrationDialog(@NotNull Project project, @NotNull PsiDirectory directory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super(project, directory, FlywayResourceBundle.message("flyway.java.based.migration", new Object[0]));
        this.init();
    }

    public void setupComponents() {
        super.setupComponents();
        this.addLanguageSelectIfNeeded();
    }

    protected void setupTopPanel() {
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String versionedName = FlywayHelper.Companion.getInstance(project).generateVersionedName(CollectionsKt.emptyList());
        this.classNameField.setText(StringsKt.replace$default((String)StringsKt.replace$default((String)versionedName, (char)'.', (char)'_', (boolean)false, (int)4, null), (char)'-', (char)'_', (boolean)false, (int)4, null));
        StudioElementCreationGridDialog studioElementCreationGridDialog = (StudioElementCreationGridDialog)this;
        String string = JpaModelBundle.messageWithColon((String)"EntityPropertiesPanel.className", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageWithColon(...)");
        JBTextField jBTextField = this.classNameField;
        Intrinsics.checkNotNullExpressionValue((Object)jBTextField, (String)"classNameField");
        StudioElementCreationGridDialog.addComponent$default((StudioElementCreationGridDialog)studioElementCreationGridDialog, (String)string, (JComponent)((JComponent)jBTextField), null, null, null, (int)28, null);
    }

    @NotNull
    protected String getPackageRecentKey() {
        return RECENT_KEY;
    }

    @NotNull
    protected String getClassNameErrorMessage() {
        String string = FlywayResourceBundle.message("Validation.javaMigrationExists", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.classNameField;
    }

    @Nullable
    protected PsiFile createResult() {
        String string = this.targetPackageField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.classNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        JavaMigrationModel model = new JavaMigrationModel(string, string2);
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        FlywayCreator flywayCreator = FlywayCreator.Companion.getInstance(project);
        PsiDirectory psiDirectory = this.getSelectedDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"getSelectedDirectory(...)");
        return flywayCreator.createJavaMigrationFile(model, psiDirectory, this.getGenerationLanguage());
    }

    @NotNull
    protected String getHelpId() {
        return JpaHelpConstants.Flyway.INSTANCE.getJavaBasedMigrations();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/flyway/action/FlywayJavaMigrationDialog$Companion;", "", "<init>", "()V", "RECENT_KEY", "", "intellij.flyway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

