/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.turbocharger;

import com.intellij.execution.CommandLineUtil;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.layout.LayoutBuilderKt;
import com.intellij.util.Restarter;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\tH\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/turbocharger/BuildTurbochargedIndexCmdAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "command", "", "chosenFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "notificationContent", "findDirectExecutable", "Ljava/nio/file/Path;", "starterPath", "intellij.indexing.shared.turbocharger"})
@SourceDebugExtension(value={"SMAP\nBuildTurbochargedIndexCmdAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildTurbochargedIndexCmdAction.kt\ncom/intellij/indexing/shared/turbocharger/BuildTurbochargedIndexCmdAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class BuildTurbochargedIndexCmdAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FileChooserDescriptor fileChooserDescriptor = new OpenProjectFileChooserDescriptor(false).withTitle(SharedIndexesBundle.message((String)"shared.index.choose.project.command.line.copied", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withTitle(...)");
        LayoutBuilderKt.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (AnActionEvent)e, arg_0 -> BuildTurbochargedIndexCmdAction.actionPerformed$lambda$0(this, e, arg_0));
    }

    private final String command(VirtualFile chosenFile) {
        String string;
        String string2 = chosenFile.getCanonicalPath();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = CommandLineUtil.posixQuote((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"posixQuote(...)");
        String projectPath = string3;
        Path path = Restarter.getIdeStarter();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            string = CommandLineUtil.posixQuote((String)((Object)this.findDirectExecutable(it).toAbsolutePath()).toString());
        } else {
            string = null;
        }
        String starterPath = string;
        String cmd = starterPath + " project-with-shared-caches " + projectPath;
        return SystemInfo.isWindows ? "& " + cmd : cmd;
    }

    @NlsContexts.NotificationContent
    private final String notificationContent() {
        String string;
        if (SystemInfo.isWindows) {
            String string2 = SharedIndexesBundle.message((String)"shared.index.command.line.copied.ps", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = SharedIndexesBundle.message((String)"shared.index.command.line.copied", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final Path findDirectExecutable(Path starterPath) {
        Path path;
        if (SystemInfo.isMac) {
            Path path2 = starterPath.resolve("Contents");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path path3 = path2.resolve("MacOS");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path path4 = path3;
            String string = ApplicationNamesInfo.getInstance().getScriptName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScriptName(...)");
            Path path5 = path4.resolve(string);
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        } else {
            path = starterPath;
        }
        return path;
    }

    private static final Unit actionPerformed$lambda$0(BuildTurbochargedIndexCmdAction this$0, AnActionEvent $e, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String cmd = this$0.command(file);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(cmd));
        NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexes User Action Response or Request").createNotification(this$0.notificationContent(), NotificationType.INFORMATION).notify($e.getProject());
        return Unit.INSTANCE;
    }
}

