/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.turbocharger;

import com.intellij.openapi.project.ex.PerProjectInstancePaths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/turbocharger/IsolatedCachePaths;", "", "dataPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getDataPath", "()Ljava/nio/file/Path;", "indexPath", "getIndexPath", "vfsPath", "getVfsPath", "dataExists", "", "Companion", "intellij.indexing.shared.turbocharger"})
public final class IsolatedCachePaths {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path dataPath;
    @NotNull
    private final Path indexPath;
    @NotNull
    private final Path vfsPath;

    private IsolatedCachePaths(Path dataPath) {
        this.dataPath = dataPath;
        Path path = this.dataPath.resolve("index");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.indexPath = path;
        Path path2 = this.dataPath.resolve("vfs");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.vfsPath = path2;
    }

    @NotNull
    public final Path getDataPath() {
        return this.dataPath;
    }

    @NotNull
    public final Path getIndexPath() {
        return this.indexPath;
    }

    @NotNull
    public final Path getVfsPath() {
        return this.vfsPath;
    }

    public final boolean dataExists() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(this.dataPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    public /* synthetic */ IsolatedCachePaths(Path dataPath, DefaultConstructorMarker $constructor_marker) {
        this(dataPath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0015\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/indexing/shared/turbocharger/IsolatedCachePaths$Companion;", "", "<init>", "()V", "forProjectPath", "Lcom/intellij/indexing/shared/turbocharger/IsolatedCachePaths;", "path", "Ljava/nio/file/Path;", "forInstancePaths", "instancePaths", "Lcom/intellij/openapi/project/ex/PerProjectInstancePaths;", "forBarePath", "forBarePath$intellij_indexing_shared_turbocharger", "intellij.indexing.shared.turbocharger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IsolatedCachePaths forProjectPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.forInstancePaths(new PerProjectInstancePaths(path));
        }

        private final IsolatedCachePaths forInstancePaths(PerProjectInstancePaths instancePaths) {
            Path path = instancePaths.getSystemDir().resolve("turbocharged");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return this.forBarePath$intellij_indexing_shared_turbocharger(path);
        }

        @NotNull
        public final IsolatedCachePaths forBarePath$intellij_indexing_shared_turbocharger(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new IsolatedCachePaths(path, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

